/*
 * Decompiled with CFR 0.152.
 */
package exnihiloadscensio.tiles;

import exnihiloadscensio.config.Config;
import exnihiloadscensio.enchantments.ENEnchantments;
import exnihiloadscensio.networking.PacketHandler;
import exnihiloadscensio.registries.SieveRegistry;
import exnihiloadscensio.registries.types.Siftable;
import exnihiloadscensio.util.BlockInfo;
import exnihiloadscensio.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileSieve
extends TileEntity {
    private BlockInfo currentStack;
    private byte progress = 0;
    private ItemStack meshStack;
    private long lastSieveAction = 0L;
    private UUID lastPlayer;
    private static Random rand = new Random();

    public boolean setMesh(ItemStack newMesh) {
        return this.setMesh(newMesh, false);
    }

    public boolean setMesh(ItemStack newMesh, boolean simulate) {
        if (this.progress != 0 || this.currentStack != null) {
            return false;
        }
        if (this.meshStack == null) {
            if (!simulate) {
                this.meshStack = newMesh.func_77946_l();
                this.func_70296_d();
            }
            return true;
        }
        if (this.meshStack != null && newMesh == null) {
            if (!simulate) {
                this.meshStack = null;
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public boolean addBlock(ItemStack stack) {
        if (this.currentStack == null && SieveRegistry.canBeSifted(stack)) {
            if (this.meshStack == null) {
                return false;
            }
            int meshLevel = this.meshStack.func_77952_i();
            for (Siftable siftable : SieveRegistry.getDrops(stack)) {
                if (siftable.getMeshLevel() != meshLevel) continue;
                this.currentStack = new BlockInfo(stack);
                PacketHandler.sendNBTUpdate(this);
                return true;
            }
        }
        return false;
    }

    public boolean doSieving(EntityPlayer player) {
        if (this.currentStack == null) {
            return false;
        }
        if (this.field_145850_b.func_82737_E() - this.lastSieveAction < 4L) {
            return false;
        }
        if (this.field_145850_b.func_82737_E() - this.lastSieveAction == 0L && this.lastPlayer.equals(player.func_110124_au())) {
            if (Config.setFireToMacroUsers) {
                player.func_70015_d(1);
            }
            player.func_146105_b(new TextComponentString("Bad").func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150227_a(Boolean.valueOf(true))));
        }
        this.lastSieveAction = this.field_145850_b.func_82737_E();
        this.lastPlayer = player.func_110124_au();
        int efficiency = EnchantmentHelper.func_77506_a((Enchantment)ENEnchantments.efficiency, (ItemStack)this.meshStack);
        efficiency += EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)this.meshStack);
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)ENEnchantments.fortune, (ItemStack)this.meshStack);
        fortune += EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)this.meshStack);
        fortune = (int)((float)fortune + player.func_184817_da());
        int luckOfTheSea = EnchantmentHelper.func_77506_a((Enchantment)ENEnchantments.luckOfTheSea, (ItemStack)this.meshStack);
        if ((luckOfTheSea += EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_151370_z, (ItemStack)this.meshStack)) > 0) {
            luckOfTheSea = (int)((float)luckOfTheSea + player.func_184817_da());
        }
        this.progress = (byte)(this.progress + (10 + 5 * efficiency));
        PacketHandler.sendNBTUpdate(this);
        if (this.progress >= 100) {
            List<ItemStack> drops = SieveRegistry.getRewardDrops(rand, this.currentStack.getBlockState(), this.meshStack.func_77960_j(), fortune);
            if (drops == null) {
                drops = new ArrayList<ItemStack>();
            }
            int fishToDrop = (int)Math.round(rand.nextGaussian() + (double)luckOfTheSea / 2.0);
            fishToDrop = Math.min(fishToDrop, 0);
            fishToDrop = Math.max(fishToDrop, luckOfTheSea);
            for (int i = 0; i < fishToDrop; ++i) {
                int fishMeta = 0;
                switch (rand.nextInt(7)) {
                    case 3: 
                    case 4: {
                        fishMeta = 1;
                        break;
                    }
                    case 5: {
                        fishMeta = 2;
                        break;
                    }
                    case 6: {
                        fishMeta = 3;
                    }
                }
                drops.add(new ItemStack(Items.field_151115_aP, 1, fishMeta));
            }
            TileEntity container = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, -1, 0));
            if (Config.sievesAutoOutput && container != null && container.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
                IItemHandler handler = (IItemHandler)container.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                for (ItemStack drop : drops) {
                    ItemStack remaining = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)drop, (boolean)false);
                    if (remaining == null) continue;
                    Util.dropItemInWorld(this, null, remaining, 1.0);
                }
            } else {
                drops.forEach(stack -> Util.dropItemInWorld(this, player, stack, 1.0));
            }
            this.resetSieve();
        }
        return true;
    }

    public boolean isSieveSimilar(TileSieve sieve) {
        if (sieve == null) {
            return false;
        }
        if (this.meshStack == null || sieve.getMeshStack() == null) {
            return false;
        }
        return this.meshStack.func_77952_i() == sieve.getMeshStack().func_77952_i() && this.progress == sieve.getProgress() && BlockInfo.areEqual(this.currentStack, sieve.getCurrentStack());
    }

    public boolean isSieveSimilarToInput(TileSieve sieve) {
        if (this.meshStack == null || sieve.getMeshStack() == null) {
            return false;
        }
        return this.meshStack.func_77952_i() == sieve.getMeshStack().func_77952_i() && this.progress == sieve.getProgress() && sieve.getCurrentStack() == null;
    }

    private void resetSieve() {
        this.progress = 0;
        this.currentStack = null;
        PacketHandler.sendNBTUpdate(this);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture() {
        if (this.currentStack != null) {
            return Util.getTextureFromBlockState(this.currentStack.getBlockState());
        }
        return null;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        if (this.currentStack != null) {
            NBTTagCompound stackTag = this.currentStack.writeToNBT(new NBTTagCompound());
            tag.func_74782_a("stack", (NBTBase)stackTag);
        }
        if (this.meshStack != null) {
            NBTTagCompound meshTag = this.meshStack.func_77955_b(new NBTTagCompound());
            tag.func_74782_a("mesh", (NBTBase)meshTag);
        }
        tag.func_74774_a("progress", this.progress);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.currentStack = tag.func_74764_b("stack") ? BlockInfo.readFromNBT(tag.func_74775_l("stack")) : null;
        this.meshStack = tag.func_74764_b("mesh") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("mesh")) : null;
        this.progress = tag.func_74771_c("progress");
        super.func_145839_a(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = this.func_189515_b(new NBTTagCompound());
        return tag;
    }

    public BlockInfo getCurrentStack() {
        return this.currentStack;
    }

    public byte getProgress() {
        return this.progress;
    }

    public ItemStack getMeshStack() {
        return this.meshStack;
    }
}

