/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemCustomRingTeleport
extends Item {
    public ItemCustomRingTeleport(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        Direction direction = context.func_196000_l();
        ItemStack stackRing = context.func_195999_j().func_184614_ca();
        if (ItemCustomRingTeleport.getPosition(stackRing) == null && player.func_70093_af()) {
            ItemCustomRingTeleport.setPosition(stackRing, world, pos.func_177972_a(direction), player);
            player.func_145747_a((ITextComponent)new StringTextComponent("Location set!"));
            return ActionResultType.SUCCESS;
        }
        if (ItemCustomRingTeleport.getPosition(stackRing) != null) {
            player.func_145747_a((ITextComponent)new StringTextComponent("Location already set."));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemCustomRingTeleport.getPosition(stack) != null && !player.func_70093_af()) {
            this.teleport(player, world, stack);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        if (ItemCustomRingTeleport.getPosition(stack) != null && player.func_70093_af()) {
            ItemCustomRingTeleport.setPosition(stack, world, null, player);
            player.func_145747_a((ITextComponent)new StringTextComponent("Location cleared!"));
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public void teleport(PlayerEntity player, World world, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        int currentDim = player.field_71093_bK.func_186068_a();
        BlockPos pos = ItemCustomRingTeleport.getPosition(stack);
        if (ItemCustomRingTeleport.getDimension(stack) == currentDim) {
            player.func_70634_a((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
        } else {
            player.func_145747_a((ITextComponent)new StringTextComponent("You are not currently in the stored dimension"));
        }
    }

    public static BlockPos getPosition(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        CompoundNBT tags = stack.func_77978_p();
        if (tags.func_74764_b("pos")) {
            return NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)tags.func_74781_a("pos")));
        }
        return null;
    }

    public static void setPosition(ItemStack stack, World world, BlockPos pos, PlayerEntity player) {
        if (world.field_72995_K) {
            return;
        }
        CompoundNBT tags = !stack.func_77942_o() ? new CompoundNBT() : stack.func_77978_p();
        if (pos == null) {
            tags.func_82580_o("pos");
            tags.func_82580_o("dim");
        } else {
            tags.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
            tags.func_74768_a("dim", player.field_71093_bK.func_186068_a());
        }
        stack.func_77982_d(tags);
    }

    public static int getDimension(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return Integer.MAX_VALUE;
        }
        CompoundNBT tags = stack.func_77978_p();
        if (tags.func_74764_b("dim")) {
            return tags.func_74762_e("dim");
        }
        return Integer.MAX_VALUE;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        list.add((ITextComponent)new StringTextComponent(TextFormatting.BLUE + "Allows player to teleport to saved location on right-click"));
        list.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Does not work across dimensions"));
        list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "Set: " + TextFormatting.AQUA + "point at a block and sneak + right-click"));
        list.add((ITextComponent)new StringTextComponent(TextFormatting.WHITE + "Clear: " + TextFormatting.AQUA + "point in the air and sneak + right-click"));
        if (ItemCustomRingTeleport.getPosition(stack) != null) {
            BlockPos pos = ItemCustomRingTeleport.getPosition(stack);
            list.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "Location Stored:"));
            list.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Dim: " + ItemCustomRingTeleport.getDimension(stack) + "  X: " + pos.func_177958_n() + "  Y: " + pos.func_177956_o() + "  Z: " + pos.func_177952_p()));
        }
    }
}

