/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.PageRef;
import gigaherz.guidebook.guidebook.elements.IPageElement;
import gigaherz.guidebook.guidebook.elements.Image;
import gigaherz.guidebook.guidebook.elements.Link;
import gigaherz.guidebook.guidebook.elements.Paragraph;
import gigaherz.guidebook.guidebook.elements.Space;
import gigaherz.guidebook.guidebook.elements.Stack;
import gigaherz.guidebook.guidebook.elements.Template;
import gigaherz.guidebook.guidebook.templates.TemplateDefinition;
import gigaherz.guidebook.guidebook.templates.TemplateElement;
import gigaherz.guidebook.guidebook.templates.TemplateLibrary;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BookDocument {
    private static final float DEFAULT_FONT_SIZE = 1.0f;
    private float fontSize = 1.0f;
    private final ResourceLocation bookLocation;
    private String bookName;
    private ResourceLocation bookCover;
    final List<ChapterData> chapters = Lists.newArrayList();
    private Table<Item, Integer, PageRef> stackLinks = HashBasedTable.create();
    final Map<String, Integer> chaptersByName = Maps.newHashMap();
    final Map<String, PageRef> pagesByName = Maps.newHashMap();
    private final Map<String, TemplateDefinition> templates = Maps.newHashMap();
    private int totalPairs = 0;
    private IBookGraphics rendering;

    public BookDocument(ResourceLocation bookLocation) {
        this.bookLocation = bookLocation;
    }

    public ResourceLocation getBookLocation() {
        return this.bookLocation;
    }

    @Nullable
    public String getBookName() {
        return this.bookName;
    }

    @Nullable
    public ResourceLocation getBookCover() {
        return this.bookCover;
    }

    public ChapterData getChapter(int i) {
        return this.chapters.get(i);
    }

    @Nullable
    public PageRef getStackLink(ItemStack stack) {
        Item item = stack.func_77973_b();
        int damage = stack.func_77952_i();
        if (this.stackLinks.containsRow((Object)item)) {
            if (this.stackLinks.containsColumn((Object)damage)) {
                return (PageRef)this.stackLinks.get((Object)item, (Object)damage);
            }
            if (this.stackLinks.contains((Object)item, (Object)-1)) {
                return (PageRef)this.stackLinks.get((Object)item, (Object)-1);
            }
        }
        return null;
    }

    public int getTotalPairCount() {
        return this.totalPairs;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public int chapterCount() {
        return this.chapters.size();
    }

    public void findTextures(Set<ResourceLocation> textures) {
        if (this.bookCover != null) {
            textures.add(this.bookCover);
        }
        for (ChapterData chapter : this.chapters) {
            for (PageData page : chapter.pages) {
                for (IPageElement element : page.elements) {
                    element.findTextures(textures);
                }
            }
        }
    }

    public void initializeWithLoadError(Exception e) {
        ChapterData ch = new ChapterData(0);
        this.chapters.add(ch);
        PageData pg = new PageData(0);
        ch.pages.add(pg);
        pg.elements.add(new Paragraph("Error loading book:"));
        pg.elements.add(new Paragraph(TextFormatting.RED + e.toString()));
    }

    public void parseBook(InputStream stream) {
        try {
            this.chapters.clear();
            this.bookName = "";
            this.bookCover = null;
            this.totalPairs = 0;
            this.fontSize = 1.0f;
            this.chaptersByName.clear();
            this.pagesByName.clear();
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            Node root = doc.getChildNodes().item(0);
            if (root.hasAttributes()) {
                NamedNodeMap attributes = root.getAttributes();
                Node n = attributes.getNamedItem("title");
                if (n != null) {
                    this.bookName = n.getTextContent();
                }
                if ((n = attributes.getNamedItem("cover")) != null) {
                    this.bookCover = new ResourceLocation(n.getTextContent());
                }
                if ((n = attributes.getNamedItem("fontSize")) != null) {
                    Float f = Floats.tryParse((String)n.getTextContent());
                    this.fontSize = f != null ? f.floatValue() : 1.0f;
                }
            }
            NodeList chaptersList = root.getChildNodes();
            for (int i = 0; i < chaptersList.getLength(); ++i) {
                Node chapterItem = chaptersList.item(i);
                String nodeName = chapterItem.getNodeName();
                if (nodeName.equals("template")) {
                    BookDocument.parseTemplateDefinition(chapterItem, this.templates);
                    continue;
                }
                if (nodeName.equals("include")) {
                    NamedNodeMap attributes = chapterItem.getAttributes();
                    Node n = attributes.getNamedItem("ref");
                    TemplateLibrary tpl = TemplateLibrary.get(n.getTextContent());
                    this.templates.putAll(tpl.templates);
                    continue;
                }
                if (nodeName.equals("chapter")) {
                    this.parseChapter(chapterItem);
                    continue;
                }
                if (!nodeName.equals("stack-links")) continue;
                this.parseStackLinks(chapterItem);
            }
            int prevCount = 0;
            for (ChapterData chapter : this.chapters) {
                chapter.startPair = prevCount;
                prevCount += chapter.pagePairs;
            }
            this.totalPairs = prevCount;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.initializeWithLoadError(e);
        }
    }

    private static void parseTemplateDefinition(Node templateItem, Map<String, TemplateDefinition> templates) {
        if (!templateItem.hasAttributes()) {
            return;
        }
        TemplateDefinition page = new TemplateDefinition();
        NamedNodeMap attributes = templateItem.getAttributes();
        Node n = attributes.getNamedItem("id");
        if (n == null) {
            return;
        }
        templates.put(n.getTextContent(), page);
        BookDocument.parseChildElements(templateItem, page.elements, templates);
        attributes.removeNamedItem("id");
        page.attributes = attributes;
    }

    private void parseChapter(Node chapterItem) {
        NamedNodeMap attributes;
        Node n;
        ChapterData chapter = new ChapterData(this.chapters.size());
        this.chapters.add(chapter);
        if (chapterItem.hasAttributes() && (n = (attributes = chapterItem.getAttributes()).getNamedItem("id")) != null) {
            chapter.id = n.getTextContent();
            this.chaptersByName.put(chapter.id, chapter.num);
        }
        NodeList pagesList = chapterItem.getChildNodes();
        for (int j = 0; j < pagesList.getLength(); ++j) {
            Node pageItem = pagesList.item(j);
            String nodeName = pageItem.getNodeName();
            if (!nodeName.equals("page")) continue;
            this.parsePage(chapter, pageItem);
        }
        chapter.pagePairs = (chapter.pages.size() + 1) / 2;
    }

    private void parsePage(ChapterData chapter, Node pageItem) {
        NamedNodeMap attributes;
        Node n;
        PageData page = new PageData(chapter.pages.size());
        chapter.pages.add(page);
        if (pageItem.hasAttributes() && (n = (attributes = pageItem.getAttributes()).getNamedItem("id")) != null) {
            page.id = n.getTextContent();
            this.pagesByName.put(page.id, new PageRef(chapter.num, page.num));
            chapter.pagesByName.put(page.id, page.num);
        }
        BookDocument.parseChildElements(pageItem, page.elements, this.templates);
    }

    public static void parseChildElements(Node pageItem, List<IPageElement> elements, Map<String, TemplateDefinition> templates) {
        NodeList elementsList = pageItem.getChildNodes();
        for (int k = 0; k < elementsList.getLength(); ++k) {
            IPageElement i;
            IPageElement s;
            Paragraph p;
            Node elementItem = elementsList.item(k);
            String nodeName = elementItem.getNodeName();
            if (nodeName.equals("p")) {
                p = new Paragraph(elementItem.getTextContent());
                elements.add(p);
                if (!elementItem.hasAttributes()) continue;
                p.parse(elementItem.getAttributes());
                continue;
            }
            if (nodeName.equals("title")) {
                p = new Paragraph(elementItem.getTextContent());
                p.alignment = 1;
                p.space = 4;
                p.underline = true;
                p.italics = true;
                elements.add(p);
                if (!elementItem.hasAttributes()) continue;
                p.parse(elementItem.getAttributes());
                continue;
            }
            if (nodeName.equals("link")) {
                Link link = new Link(elementItem.getTextContent());
                elements.add(link);
                if (!elementItem.hasAttributes()) continue;
                link.parse(elementItem.getAttributes());
                continue;
            }
            if (nodeName.equals("space") || nodeName.equals("group")) {
                s = new Space();
                elements.add(s);
                if (elementItem.hasAttributes()) {
                    ((Space)s).parse(elementItem.getAttributes());
                }
                ArrayList elementList = Lists.newArrayList();
                BookDocument.parseChildElements(elementItem, elementList, templates);
                ((Space)s).innerElements.addAll(elementList);
                continue;
            }
            if (nodeName.equals("stack")) {
                s = new Stack();
                elements.add(s);
                if (!elementItem.hasAttributes()) continue;
                ((Stack)s).parse(elementItem.getAttributes());
                continue;
            }
            if (nodeName.equals("image")) {
                i = new Image();
                elements.add(i);
                if (!elementItem.hasAttributes()) continue;
                ((Image)i).parse(elementItem.getAttributes());
                continue;
            }
            if (nodeName.equals("element")) {
                i = new TemplateElement();
                elements.add(i);
                if (!elementItem.hasAttributes()) continue;
                ((TemplateElement)i).parse(elementItem.getAttributes());
                continue;
            }
            if (!templates.containsKey(nodeName)) continue;
            TemplateDefinition tDef = templates.get(nodeName);
            Template t = new Template();
            t.parse(tDef.attributes);
            elements.add(t);
            if (elementItem.hasAttributes()) {
                t.parse(elementItem.getAttributes());
            }
            ArrayList elementList = Lists.newArrayList();
            BookDocument.parseChildElements(elementItem, elementList, templates);
            List<IPageElement> effectiveList = tDef.applyTemplate(elementList);
            t.innerElements.addAll(effectiveList);
        }
    }

    private void parseStackLinks(Node refsItem) {
        NodeList refsList = refsItem.getChildNodes();
        for (int j = 0; j < refsList.getLength(); ++j) {
            Item item;
            Node item_node;
            Node refItem = refsList.item(j);
            String nodeName = refItem.getNodeName();
            if (!nodeName.equals("stack") || !refItem.hasAttributes() || (item_node = refItem.getAttributes().getNamedItem("item")) == null || (item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(item_node.getTextContent()))) == null) continue;
            int damage_value = 0;
            Node meta = refItem.getAttributes().getNamedItem("meta");
            if (meta != null) {
                damage_value = meta.getTextContent().equals("*") ? -1 : Ints.tryParse((String)meta.getTextContent());
            }
            String ref = refItem.getTextContent();
            this.stackLinks.put((Object)item, (Object)damage_value, (Object)PageRef.fromString(ref));
        }
    }

    public void setRendering(IBookGraphics rendering) {
        this.rendering = rendering;
    }

    @Nullable
    public IBookGraphics getRendering() {
        return this.rendering;
    }

    public class PageData {
        public final int num;
        public String id;
        public final List<IPageElement> elements = Lists.newArrayList();

        private PageData(int num) {
            this.num = num;
        }
    }

    public class ChapterData {
        public final int num;
        public String id;
        public final List<PageData> pages = Lists.newArrayList();
        public final Map<String, Integer> pagesByName = Maps.newHashMap();
        public int pagePairs;
        public int startPair;

        private ChapterData(int num) {
            this.num = num;
        }

        public int pairCount() {
            return this.pagePairs;
        }
    }
}

