/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook;

import com.google.common.base.Strings;
import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.guidebook.client.BookRegistry;
import gigaherz.guidebook.shadow.common.ItemRegistered;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemGuidebook
extends ItemRegistered {
    public ItemGuidebook(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77655_b("gbook.guidebook");
        this.func_77637_a(GuidebookMod.tabMagic);
        this.func_77627_a(true);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.showBook(worldIn, stack);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        EnumActionResult result = this.showBook(worldIn, itemStackIn);
        return ActionResult.newResult((EnumActionResult)result, (Object)itemStackIn);
    }

    private EnumActionResult showBook(World worldIn, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Book", 8)) {
            return EnumActionResult.FAIL;
        }
        GuidebookMod.proxy.displayBook(nbt.func_74779_i("Book"));
        return EnumActionResult.SUCCESS;
    }

    public ItemStack of(ResourceLocation book) {
        ItemStack stack = new ItemStack((Item)this);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Book", book.toString());
        stack.func_77982_d(tag);
        return stack;
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        BookRegistry.LOADED_BOOKS.keySet().stream().map(this::of).forEach(subItems::add);
    }

    @Nullable
    public String getBookLocation(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            return tag.func_74779_i("Book");
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        String book;
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        if (advanced && !Strings.isNullOrEmpty((String)(book = this.getBookLocation(stack)))) {
            tooltip.add(String.format("Book: " + book, new Object[0]));
        }
    }

    public String func_77653_i(ItemStack stack) {
        String book = this.getBookLocation(stack);
        if (!Strings.isNullOrEmpty((String)book)) {
            return GuidebookMod.proxy.getBookName(book);
        }
        return super.func_77653_i(stack);
    }
}

