/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.guidebook.BookDocument;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PageRef {
    public int chapter;
    public int page;
    public boolean resolvedNames = false;
    public String chapterName;
    public String pageName;

    public PageRef(int chapter, int page) {
        this.chapter = chapter;
        this.page = page;
        this.resolvedNames = true;
    }

    public PageRef(String chapter, @Nullable String page) {
        this.chapterName = chapter;
        this.pageName = page;
    }

    public boolean resolve(BookDocument bookDocument) {
        block6: {
            if (!this.resolvedNames) {
                try {
                    if (!Strings.isNullOrEmpty((String)this.chapterName)) {
                        Integer ch = Ints.tryParse((String)this.chapterName);
                        this.chapter = ch != null ? ch.intValue() : bookDocument.chaptersByName.get(this.chapterName).intValue();
                        if (!Strings.isNullOrEmpty((String)this.pageName)) {
                            Integer pg = Ints.tryParse((String)this.pageName);
                            this.page = pg != null ? pg.intValue() : bookDocument.chapters.get((int)this.chapter).pagesByName.get(this.pageName).intValue();
                        }
                        break block6;
                    }
                    if (!Strings.isNullOrEmpty((String)this.pageName)) {
                        PageRef temp = bookDocument.pagesByName.get(this.pageName);
                        temp.resolve(bookDocument);
                        this.chapter = temp.chapter;
                        this.page = temp.page;
                        break block6;
                    }
                    throw new InvalidPageRefException("Invalid format: missing page and chapter");
                }
                catch (Exception e) {
                    String ref_string = (Strings.isNullOrEmpty((String)this.chapterName) ? "<none>" : this.chapterName) + ":" + (Strings.isNullOrEmpty((String)this.pageName) ? "<none>" : this.pageName);
                    GuidebookMod.logger.error(String.format("Invalid page reference: \"%s\" in book \"%s\" caused by: %s", ref_string, bookDocument.getBookName(), e.toString()));
                    return false;
                }
            }
        }
        return true;
    }

    public PageRef copy() {
        return new PageRef(this.chapter, this.page);
    }

    public static PageRef fromString(@Nonnull String refString) {
        if (refString.indexOf(58) >= 0) {
            String[] parts = refString.split(":");
            return new PageRef(parts[0], parts[1]);
        }
        return new PageRef(refString, null);
    }

    public static class InvalidPageRefException
    extends Exception {
        public InvalidPageRefException(String s) {
            super(s);
        }
    }
}

