/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.client;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.guidebook.BookDocument;
import gigaherz.guidebook.guidebook.templates.TemplateLibrary;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.io.FileUtils;

public class BookRegistry {
    public static final Set<ResourceLocation> REGISTRY = Sets.newHashSet();
    public static final Map<ResourceLocation, BookDocument> LOADED_BOOKS = Maps.newHashMap();
    private static Type listType = new TypeToken<List<String>>(){}.getType();
    private static boolean initialized = false;
    private static Field _defaultResourcePacks = ReflectionHelper.findField(Minecraft.class, (String[])new String[]{"field_110449_ao", "defaultResourcePacks"});

    public static void registerBook(ResourceLocation loc) {
        if (Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
            throw new IllegalStateException("Books must be registered before init, preferably in the BookRegistryEvent.");
        }
        REGISTRY.add(loc);
    }

    @Nullable
    public static BookDocument get(ResourceLocation loc) {
        return LOADED_BOOKS.get(loc);
    }

    public static void parseAllBooks(IResourceManager manager) {
        TemplateLibrary.clear();
        LOADED_BOOKS.clear();
        HashSet toLoad = Sets.newHashSet(REGISTRY);
        for (String domain : manager.func_135055_a()) {
            try {
                List resources = manager.func_135056_b(new ResourceLocation(domain, "books.json"));
                for (IResource res : resources) {
                    BookRegistry.loadBooksData(toLoad, res.func_110527_b());
                }
            }
            catch (FileNotFoundException resources) {
            }
            catch (IOException e) {
                GuidebookMod.logger.error("Error loading books from resourcepacks", (Throwable)e);
            }
        }
        BookRegistry.loadRawBookFiles(manager);
        for (ResourceLocation loc : toLoad) {
            if (LOADED_BOOKS.containsKey(loc)) continue;
            LOADED_BOOKS.put(loc, BookRegistry.parseBook(manager, loc));
        }
    }

    private static void loadBooksData(Set<ResourceLocation> toLoad, InputStream stream) {
        List yourList = (List)new Gson().fromJson((Reader)new InputStreamReader(stream), listType);
        toLoad.addAll(yourList.stream().map(ResourceLocation::new).collect(Collectors.toList()));
    }

    private static BookDocument parseBook(IResourceManager manager, ResourceLocation location) {
        BookDocument bookDocument = new BookDocument(location);
        try {
            IResource res = manager.func_110536_a(bookDocument.getBookLocation());
            InputStream stream = res.func_110527_b();
            bookDocument.parseBook(stream);
        }
        catch (IOException e) {
            bookDocument.initializeWithLoadError(e);
        }
        return bookDocument;
    }

    private static BookDocument parseBook(IResourceManager manager, ResourceLocation location, File file) {
        BookDocument bookDocument = new BookDocument(location);
        try {
            FileInputStream stream = new FileInputStream(file);
            bookDocument.parseBook(stream);
        }
        catch (IOException e) {
            bookDocument.initializeWithLoadError(e);
        }
        return bookDocument;
    }

    private static void loadRawBookFiles(IResourceManager manager) {
        File booksFolder = GuidebookMod.booksDirectory;
        if (!booksFolder.exists()) {
            GuidebookMod.logger.info("The books folder does not exist, creating...");
            if (!booksFolder.mkdirs()) {
                GuidebookMod.logger.info("The books folder could not be created. Books can't be loaded from it.");
                return;
            }
        }
        if (!booksFolder.exists() || !booksFolder.isDirectory()) {
            GuidebookMod.logger.info("There's a file called books, but it's not a directory. Books can't be loaded from it.");
            return;
        }
        Collection xmlFiles = FileUtils.listFiles((File)booksFolder, (String[])new String[]{"xml"}, (boolean)true);
        for (File f : xmlFiles) {
            ResourceLocation loc;
            if (!f.isFile() || LOADED_BOOKS.containsKey(loc = new ResourceLocation("gbook", BookRegistry.relativePath(booksFolder, f)))) continue;
            LOADED_BOOKS.put(loc, BookRegistry.parseBook(manager, loc, f));
        }
    }

    private static String relativePath(File base, File sub) {
        return base.toURI().relativize(sub.toURI()).getPath();
    }

    public static void initReloadHandler() {
        if (initialized) {
            return;
        }
        initialized = true;
        IResourceManager rm = Minecraft.func_71410_x().func_110442_L();
        if (rm instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)rm).func_110542_a(BookRegistry::parseAllBooks);
        }
    }

    public static void injectCustomResourcePack() {
        File resourcesFolder = new File(GuidebookMod.booksDirectory, "resources");
        if (!resourcesFolder.exists()) {
            GuidebookMod.logger.info("The resources folder does not exist, creating...");
            if (!resourcesFolder.mkdirs()) {
                GuidebookMod.logger.info("The resources folder could not be created, and it won't be injected as a resource pack folder.");
                return;
            }
        }
        if (!resourcesFolder.exists() || !resourcesFolder.isDirectory()) {
            GuidebookMod.logger.info("There's a file called books, but it's not a directory, so it won't be injected as a resource pack folder.");
            return;
        }
        try {
            List rp = (List)_defaultResourcePacks.get(Minecraft.func_71410_x());
            rp.add(new FolderResourcePack(resourcesFolder){
                String prefix = "assets/gbook/";

                protected InputStream func_110591_a(String name) throws IOException {
                    if ("pack.mcmeta".equals(name)) {
                        return new ByteArrayInputStream("{\"pack\":{\"description\": \"dummy\",\"pack_format\": 2}}".getBytes(Charsets.UTF_8));
                    }
                    if (!name.startsWith(this.prefix)) {
                        throw new FileNotFoundException(name);
                    }
                    return super.func_110591_a(name.substring(this.prefix.length()));
                }

                protected boolean func_110593_b(String name) {
                    if ("pack.mcmeta".equals(name)) {
                        return true;
                    }
                    if (!name.startsWith(this.prefix)) {
                        return false;
                    }
                    return super.func_110593_b(name.substring(this.prefix.length()));
                }

                public Set<String> func_110587_b() {
                    return Collections.singleton("gbook");
                }
            });
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }
}

