/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.client;

import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.guidebook.BookDocument;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.PageRef;
import gigaherz.guidebook.guidebook.client.GuiGuidebook;
import gigaherz.guidebook.guidebook.elements.IClickablePageElement;
import gigaherz.guidebook.guidebook.elements.IContainerPageElement;
import gigaherz.guidebook.guidebook.elements.IHoverPageElement;
import gigaherz.guidebook.guidebook.elements.IPageElement;
import java.util.Collection;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.Rectangle;

public class BookRendering
implements IBookGraphics {
    public static final int DEFAULT_BOOK_WIDTH = 276;
    public static final int DEFAULT_BOOK_HEIGHT = 198;
    public static final int DEFAULT_INNER_MARGIN = 22;
    public static final int DEFAULT_OUTER_MARGIN = 10;
    public static final int DEFAULT_VERTICAL_MARGIN = 18;
    private BookDocument book;
    int scaledWidth;
    int scaledHeight;
    final Minecraft mc = Minecraft.func_71410_x();
    final GuiGuidebook gui;
    private int bookWidth;
    private int bookHeight;
    private int innerMargin;
    private int outerMargin;
    private int verticalMargin;
    private int pageWidth = this.bookWidth / 2 - this.innerMargin - this.outerMargin;
    private int pageHeight = this.bookHeight - this.verticalMargin;
    final Stack<PageRef> history = new Stack();
    private int currentChapter = 0;
    private int currentPair = 0;
    private boolean hasScale;
    private float scalingFactor;

    BookRendering(BookDocument book, GuiGuidebook gui) {
        this.book = book;
        this.gui = gui;
    }

    public void computeScaledResolution2(Minecraft minecraftClient, float scaleFactorCoef) {
        int i;
        this.scaledWidth = minecraftClient.field_71443_c;
        this.scaledHeight = minecraftClient.field_71440_d;
        int scaleFactor = 1;
        boolean flag = minecraftClient.func_152349_b();
        int n = i = GuidebookMod.bookGUIScale < 0 ? minecraftClient.field_71474_y.field_74335_Z : GuidebookMod.bookGUIScale;
        if (i == 0) {
            i = 1000;
        }
        while (scaleFactor < i && this.scaledWidth / (scaleFactor + 1) >= 320 && this.scaledHeight / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        scaleFactor = MathHelper.func_76141_d((float)Math.max(1.0f, (float)scaleFactor * scaleFactorCoef));
        if (flag && scaleFactor % 2 != 0 && scaleFactor != 1) {
            --scaleFactor;
        }
        double scaledWidthD = (double)this.scaledWidth / (double)scaleFactor;
        double scaledHeightD = (double)this.scaledHeight / (double)scaleFactor;
        this.scaledWidth = MathHelper.func_76143_f((double)scaledWidthD);
        this.scaledHeight = MathHelper.func_76143_f((double)scaledHeightD);
    }

    @Override
    public void setScalingFactor() {
        float fontSize = this.book.getFontSize();
        if (MathHelper.func_180185_a((float)fontSize, (float)1.0f)) {
            this.scaledWidth = this.gui.field_146294_l;
            this.scaledHeight = this.gui.field_146295_m;
            this.hasScale = false;
            this.scalingFactor = 1.0f;
            this.bookWidth = 276;
            this.bookHeight = 198;
            this.innerMargin = 22;
            this.outerMargin = 10;
            this.verticalMargin = 18;
        } else {
            ScaledResolution sr = new ScaledResolution(this.mc);
            this.computeScaledResolution2(this.mc, fontSize);
            this.hasScale = true;
            this.scalingFactor = Math.min((float)sr.func_78326_a() / (float)this.scaledWidth, (float)sr.func_78328_b() / (float)this.scaledHeight);
            this.bookWidth = (int)(276.0f / fontSize);
            this.bookHeight = (int)(198.0f / fontSize);
            this.innerMargin = (int)(22.0f / fontSize);
            this.outerMargin = (int)(10.0f / fontSize);
            this.verticalMargin = (int)(18.0f / fontSize);
        }
        this.pageWidth = this.bookWidth / 2 - this.innerMargin - this.outerMargin;
        this.pageHeight = this.bookHeight - this.verticalMargin;
    }

    @Override
    public float getScalingFactor() {
        return this.scalingFactor;
    }

    @Override
    public boolean canGoBack() {
        return this.currentPair > 0 || this.currentChapter > 0;
    }

    @Override
    public boolean canGoNextPage() {
        return this.currentPair + 1 < this.book.getChapter((int)this.currentChapter).pagePairs || this.currentChapter + 1 < this.book.chapterCount();
    }

    @Override
    public boolean canGoPrevPage() {
        return this.currentPair > 0 || this.currentChapter > 0;
    }

    @Override
    public boolean canGoNextChapter() {
        return this.currentChapter + 1 < this.book.chapterCount();
    }

    @Override
    public boolean canGoPrevChapter() {
        return this.currentChapter > 0;
    }

    @Override
    public void navigateTo(PageRef target) {
        if (!target.resolve(this.book)) {
            return;
        }
        this.pushHistory();
        this.currentChapter = Math.max(0, Math.min(this.book.chapterCount() - 1, target.chapter));
        this.currentPair = Math.max(0, Math.min(this.book.getChapter((int)this.currentChapter).pagePairs - 1, target.page / 2));
    }

    @Override
    public void nextPage() {
        if (this.currentPair + 1 < this.book.getChapter((int)this.currentChapter).pagePairs) {
            this.pushHistory();
            ++this.currentPair;
        } else if (this.currentChapter + 1 < this.book.chapterCount()) {
            this.pushHistory();
            this.currentPair = 0;
            ++this.currentChapter;
        }
    }

    @Override
    public void prevPage() {
        if (this.currentPair > 0) {
            this.pushHistory();
            --this.currentPair;
        } else if (this.currentChapter > 0) {
            this.pushHistory();
            --this.currentChapter;
            this.currentPair = this.book.getChapter(this.currentChapter).pairCount() - 1;
        }
    }

    @Override
    public void nextChapter() {
        if (this.currentChapter + 1 < this.book.chapterCount()) {
            this.pushHistory();
            this.currentPair = 0;
            ++this.currentChapter;
        }
    }

    @Override
    public void prevChapter() {
        if (this.currentChapter > 0) {
            this.pushHistory();
            this.currentPair = 0;
            --this.currentChapter;
        }
    }

    @Override
    public void navigateBack() {
        if (this.history.size() > 0) {
            PageRef target = this.history.pop();
            target.resolve(this.book);
            this.currentChapter = target.chapter;
            this.currentPair = target.page / 2;
        } else {
            this.currentChapter = 0;
            this.currentPair = 0;
        }
    }

    private void pushHistory() {
        this.history.push(new PageRef(this.currentChapter, this.currentPair * 2));
    }

    private int getSplitWidth(FontRenderer fontRenderer, String s) {
        int height = fontRenderer.func_78267_b(s, this.pageWidth);
        return height > fontRenderer.field_78288_b ? this.pageWidth : fontRenderer.func_78256_a(s);
    }

    @Override
    public int addStringWrapping(int left, int top, String s, int color, int align) {
        FontRenderer fontRenderer = this.gui.getFontRenderer();
        if (align == 1) {
            left += (this.pageWidth - this.getSplitWidth(fontRenderer, s)) / 2;
        } else if (align == 2) {
            left += this.pageWidth - this.getSplitWidth(fontRenderer, s);
        }
        fontRenderer.func_78279_b(s, left, top, this.pageWidth, color);
        return fontRenderer.func_78267_b(s, this.pageWidth);
    }

    @Override
    public boolean mouseClicked(int mouseButton) {
        Minecraft mc = Minecraft.func_71410_x();
        int dw = this.hasScale ? this.scaledWidth : this.gui.field_146294_l;
        int dh = this.hasScale ? this.scaledHeight : this.gui.field_146295_m;
        int mouseX = Mouse.getX() * dw / mc.field_71443_c;
        int mouseY = dh - Mouse.getY() * dh / mc.field_71440_d;
        if (mouseButton == 0) {
            BookDocument.ChapterData ch = this.book.getChapter(this.currentChapter);
            BookDocument.PageData pg = ch.pages.get(this.currentPair * 2);
            if (this.mouseClickPage(mouseX, mouseY, pg)) {
                return true;
            }
            if (this.currentPair * 2 + 1 < ch.pages.size() && this.mouseClickPage(mouseX, mouseY, pg = ch.pages.get(this.currentPair * 2 + 1))) {
                return true;
            }
        }
        return false;
    }

    private boolean mouseClickPage(int mX, int mY, BookDocument.PageData pg) {
        return this.mouseClickContainer(mX, mY, pg.elements);
    }

    private boolean mouseClickContainer(int mX, int mY, Collection<IPageElement> elements) {
        for (IPageElement e : elements) {
            if (e instanceof IClickablePageElement) {
                IClickablePageElement l = (IClickablePageElement)e;
                Rectangle b = l.getBounds();
                if (mX < b.getX() || mX > b.getX() + b.getWidth() || mY < b.getY() || mY > b.getY() + b.getHeight()) continue;
                l.click(this);
                return true;
            }
            if (!(e instanceof IContainerPageElement)) continue;
            this.mouseClickContainer(mX, mY, ((IContainerPageElement)e).getChildren());
        }
        return false;
    }

    @Override
    public boolean mouseHover(int mouseX, int mouseY) {
        BookDocument.ChapterData ch = this.book.getChapter(this.currentChapter);
        BookDocument.PageData pg = ch.pages.get(this.currentPair * 2);
        if (this.mouseHoverPage(mouseX, mouseY, pg)) {
            return true;
        }
        return this.currentPair * 2 + 1 < ch.pages.size() && this.mouseHoverPage(mouseX, mouseY, pg = ch.pages.get(this.currentPair * 2 + 1));
    }

    private boolean mouseHoverPage(int mouseX, int mouseY, BookDocument.PageData pg) {
        Minecraft mc = Minecraft.func_71410_x();
        int dw = this.hasScale ? this.scaledWidth : this.gui.field_146294_l;
        int dh = this.hasScale ? this.scaledHeight : this.gui.field_146295_m;
        int mX = Mouse.getX() * dw / mc.field_71443_c;
        int mY = dh - Mouse.getY() * dh / mc.field_71440_d;
        return this.mouseHoverContainer(mouseX, mouseY, mX, mY, pg.elements);
    }

    private boolean mouseHoverContainer(int mouseX, int mouseY, int mX, int mY, Collection<IPageElement> elements) {
        for (IPageElement e : elements) {
            if (e instanceof IHoverPageElement) {
                IHoverPageElement l = (IHoverPageElement)e;
                Rectangle b = l.getBounds();
                if (mX < b.getX() || mX > b.getX() + b.getWidth() || mY < b.getY() || mY > b.getY() + b.getHeight()) continue;
                l.mouseOver(this, mouseX, mouseY);
                return true;
            }
            if (!(e instanceof IContainerPageElement)) continue;
            this.mouseHoverContainer(mouseX, mouseY, mX, mY, ((IContainerPageElement)e).getChildren());
        }
        return false;
    }

    @Override
    public void drawCurrentPages() {
        int guiWidth = this.gui.field_146294_l;
        int guiHeight = this.gui.field_146295_m;
        if (this.hasScale) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)this.scalingFactor, (float)this.scalingFactor, (float)this.scalingFactor);
            guiWidth = this.scaledWidth;
            guiHeight = this.scaledHeight;
        }
        int left = guiWidth / 2 - this.pageWidth - this.innerMargin;
        int right = guiWidth / 2 + this.innerMargin;
        int top = (guiHeight - this.pageHeight) / 2 - 9;
        int bottom = top + this.pageHeight - 3;
        this.drawPage(left, top, this.currentPair * 2);
        this.drawPage(right, top, this.currentPair * 2 + 1);
        String cnt = "" + ((this.book.getChapter((int)this.currentChapter).startPair + this.currentPair) * 2 + 1) + "/" + this.book.getTotalPairCount() * 2;
        this.addStringWrapping(left, bottom, cnt, -16777216, 1);
        if (this.hasScale) {
            GlStateManager.func_179121_F();
        }
    }

    private void drawPage(int left, int top, int page) {
        BookDocument.ChapterData ch = this.book.getChapter(this.currentChapter);
        if (page >= ch.pages.size()) {
            return;
        }
        BookDocument.PageData pg = ch.pages.get(page);
        for (IPageElement e : pg.elements) {
            top += e.apply(this, left, top);
        }
    }

    @Override
    public BookDocument getBook() {
        return this.book;
    }

    @Override
    public int getPageWidth() {
        return this.pageWidth;
    }

    @Override
    public int getPageHeight() {
        return this.pageHeight;
    }

    @Override
    public void drawItemStack(int left, int top, int z, ItemStack stack, int color, float scale) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)left, (float)top, (float)z);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        RenderHelper.func_74520_c();
        this.gui.field_146297_k.func_175599_af().func_180450_b(stack, 0, 0);
        RenderHelper.func_74518_a();
        this.gui.field_146297_k.func_175599_af().func_180453_a(this.gui.getFontRenderer(), stack, 0, 0, null);
        GlStateManager.func_179121_F();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
    }

    @Override
    public void drawImage(ResourceLocation loc, int x, int y, int tx, int ty, int w, int h, int tw, int th, float scale) {
        int sh;
        int sw = tw != 0 ? tw : 256;
        int n = sh = th != 0 ? th : 256;
        if (w == 0) {
            w = sw;
        }
        if (h == 0) {
            h = sh;
        }
        ResourceLocation locExpanded = new ResourceLocation(loc.func_110624_b(), "textures/" + loc.func_110623_a() + ".png");
        this.gui.getRenderEngine().func_110577_a(locExpanded);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Gui.func_152125_a((int)x, (int)y, (float)tx, (float)ty, (int)w, (int)h, (int)((int)((float)w * scale)), (int)((int)((float)h * scale)), (float)sw, (float)sh);
    }

    @Override
    public Rectangle getStringBounds(String text, int left, int top) {
        FontRenderer fontRenderer = this.gui.getFontRenderer();
        int height = fontRenderer.func_78267_b(text, this.pageWidth);
        int width = height > fontRenderer.field_78288_b ? this.pageWidth : fontRenderer.func_78256_a(text);
        return new Rectangle(left, top, width, height);
    }

    @Override
    public void drawTooltip(ItemStack stack, int x, int y) {
        this.gui.drawTooltip(stack, x, y);
    }

    @Override
    public Object owner() {
        return this.gui;
    }
}

