/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.elements;

import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.elements.IPageElement;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Image
implements IPageElement {
    public ResourceLocation textureLocation;
    public int x = 0;
    public int y = 0;
    public int w = 0;
    public int h = 0;
    public int tx = 0;
    public int ty = 0;
    public int tw = 0;
    public int th = 0;
    public float scale = 1.0f;

    @Override
    public int apply(IBookGraphics nav, int left, int top) {
        this.drawImage(nav, left, top);
        return 0;
    }

    private void drawImage(IBookGraphics nav, int left, int top) {
        nav.drawImage(this.textureLocation, left + this.x, top + this.y, this.tx, this.ty, this.w, this.h, this.tw, this.th, this.scale);
    }

    @Override
    public void findTextures(Set<ResourceLocation> textures) {
    }

    @Override
    public void parse(NamedNodeMap attributes) {
        Node attr = attributes.getNamedItem("x");
        if (attr != null) {
            this.x = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("y")) != null) {
            this.y = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("w")) != null) {
            this.w = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("h")) != null) {
            this.h = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("tx")) != null) {
            this.tx = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("ty")) != null) {
            this.ty = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("tw")) != null) {
            this.tw = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("th")) != null) {
            this.th = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("src")) != null) {
            this.textureLocation = new ResourceLocation(attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("scale")) != null) {
            Float f = Floats.tryParse((String)attr.getTextContent());
            this.scale = f != null ? f.floatValue() : this.scale;
        }
    }

    @Override
    public IPageElement copy() {
        Image img = new Image();
        img.textureLocation = new ResourceLocation(this.textureLocation.toString());
        img.x = this.x;
        img.y = this.y;
        img.w = this.w;
        img.h = this.h;
        img.tx = this.tx;
        img.ty = this.ty;
        img.tw = this.tw;
        img.th = this.th;
        return img;
    }
}

