/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.elements;

import com.google.common.collect.Sets;
import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.PageRef;
import gigaherz.guidebook.guidebook.elements.IClickablePageElement;
import gigaherz.guidebook.guidebook.elements.IPageElement;
import gigaherz.guidebook.guidebook.elements.Paragraph;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.util.Rectangle;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Link
extends Paragraph
implements IClickablePageElement {
    private static final Set<String> PROTOCOLS = Sets.newHashSet((Object[])new String[]{"http", "https"});
    public String webTarget;
    public PageRef target;
    public int colorHover = -8926106;
    public boolean isHovering;
    public Rectangle bounds;

    public Link(String text) {
        super(text);
        this.underline = true;
        this.color = -8952116;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void click(IBookGraphics nav) {
        if (this.webTarget != null) {
            this.clickWeb(nav);
        }
        if (this.target != null) {
            nav.navigateTo(this.target);
        }
    }

    public void clickWeb(IBookGraphics nav) {
        GuiScreen parent = (GuiScreen)nav.owner();
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.field_71474_y.field_74359_p) {
            return;
        }
        try {
            URI uri = new URI(this.webTarget);
            String s = uri.getScheme();
            if (s == null) {
                throw new URISyntaxException(this.webTarget, "Missing protocol");
            }
            if (!PROTOCOLS.contains(s.toLowerCase(Locale.ROOT))) {
                throw new URISyntaxException(this.webTarget, "Unsupported protocol: " + s.toLowerCase(Locale.ROOT));
            }
            if (mc.field_71474_y.field_74358_q) {
                ReflectionHelper.setPrivateValue(GuiScreen.class, (Object)parent, (Object)uri, (String[])new String[]{"field_175286_t", "clickedLinkURI"});
                mc.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)parent, this.webTarget, 31102009, false));
            } else {
                Link.openWebLink(uri);
            }
        }
        catch (URISyntaxException urisyntaxexception) {
            GuidebookMod.logger.error("Can't open url {}", new Object[]{this.webTarget, urisyntaxexception});
        }
    }

    @Override
    public int apply(IBookGraphics nav, int left, int top) {
        this.bounds = nav.getStringBounds(this.text, left, top);
        return nav.addStringWrapping(left + this.indent, top, this.text, this.isHovering ? this.colorHover : this.color, this.alignment) + this.space;
    }

    @Override
    public void parse(NamedNodeMap attributes) {
        super.parse(attributes);
        Node attr = attributes.getNamedItem("ref");
        if (attr != null) {
            String ref = attr.getTextContent();
            this.target = PageRef.fromString(ref);
        }
        if ((attr = attributes.getNamedItem("href")) != null) {
            this.webTarget = attr.getTextContent();
        }
    }

    @Override
    public IPageElement copy() {
        Link link = new Link(this.text);
        link.alignment = this.alignment;
        link.color = this.color;
        link.indent = this.indent;
        link.space = this.space;
        link.bold = this.bold;
        link.italics = this.italics;
        link.underline = this.underline;
        link.target = this.target.copy();
        link.webTarget = this.webTarget;
        link.colorHover = this.colorHover;
        return link;
    }

    private static void openWebLink(URI url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, url);
        }
        catch (Throwable throwable1) {
            GuidebookMod.logger.error("Can't open url {}", new Object[]{url, throwable1});
        }
    }
}

