/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.elements;

import com.google.common.primitives.Ints;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.elements.IPageElement;
import net.minecraft.util.text.TextFormatting;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Paragraph
implements IPageElement {
    public final String text;
    public int alignment = 0;
    public int color = -16777216;
    public int indent = 0;
    public int space = 2;
    public boolean bold;
    public boolean italics;
    public boolean underline;

    public Paragraph(String text) {
        this.text = text;
    }

    @Override
    public int apply(IBookGraphics nav, int left, int top) {
        String textWithFormat = this.text;
        if (this.bold) {
            textWithFormat = TextFormatting.BOLD + textWithFormat;
        }
        if (this.italics) {
            textWithFormat = TextFormatting.ITALIC + textWithFormat;
        }
        if (this.underline) {
            textWithFormat = TextFormatting.UNDERLINE + textWithFormat;
        }
        return nav.addStringWrapping(left + this.indent, top, textWithFormat, this.color, this.alignment) + this.space;
    }

    @Override
    public void parse(NamedNodeMap attributes) {
        String text;
        Node attr = attributes.getNamedItem("align");
        if (attr != null) {
            String a;
            switch (a = attr.getTextContent()) {
                case "left": {
                    this.alignment = 0;
                    break;
                }
                case "center": {
                    this.alignment = 1;
                    break;
                }
                case "right": {
                    this.alignment = 2;
                }
            }
        }
        if ((attr = attributes.getNamedItem("indent")) != null) {
            this.indent = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("space")) != null) {
            this.space = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("bold")) != null && ("".equals(text = attr.getTextContent()) || "true".equals(text))) {
            this.bold = true;
        }
        if ((attr = attributes.getNamedItem("italics")) != null && ("".equals(text = attr.getTextContent()) || "true".equals(text))) {
            this.italics = true;
        }
        if ((attr = attributes.getNamedItem("underline")) != null && ("".equals(text = attr.getTextContent()) || "true".equals(text))) {
            this.underline = true;
        }
        if ((attr = attributes.getNamedItem("color")) != null) {
            String c = attr.getTextContent();
            if (c.startsWith("#")) {
                c = c.substring(1);
            }
            try {
                this.color = c.length() <= 6 ? 0xFF000000 | Integer.parseInt(c, 16) : Integer.parseInt(c, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public IPageElement copy() {
        Paragraph paragraph = new Paragraph(this.text);
        paragraph.alignment = this.alignment;
        paragraph.color = this.color;
        paragraph.indent = this.indent;
        paragraph.space = this.space;
        paragraph.bold = this.bold;
        paragraph.italics = this.italics;
        paragraph.underline = this.underline;
        return paragraph;
    }
}

