/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.elements;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.elements.IContainerPageElement;
import gigaherz.guidebook.guidebook.elements.IPageElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Space
implements IContainerPageElement {
    public final List<IPageElement> innerElements;
    public boolean asPercent;
    public int space;

    public Space() {
        this.innerElements = Lists.newArrayList();
    }

    public Space(List<IPageElement> innerElements) {
        this.innerElements = Lists.newArrayList(innerElements);
    }

    @Override
    public int apply(IBookGraphics nav, int left, int top) {
        int top0 = top;
        for (IPageElement child : this.innerElements) {
            top0 += child.apply(nav, left, top0);
        }
        return this.asPercent ? nav.getPageHeight() * this.space / 100 : this.space;
    }

    @Override
    public void parse(NamedNodeMap attributes) {
        Node attr = attributes.getNamedItem("height");
        if (attr != null) {
            String t = attr.getTextContent();
            if (t.endsWith("%")) {
                this.asPercent = true;
                t = t.substring(0, t.length() - 1);
            }
            this.space = Ints.tryParse((String)t);
        }
    }

    @Override
    public void findTextures(Set<ResourceLocation> textures) {
        for (IPageElement child : this.innerElements) {
            child.findTextures(textures);
        }
    }

    @Override
    public Collection<IPageElement> getChildren() {
        return this.innerElements;
    }

    @Override
    public IPageElement copy() {
        Space space = new Space();
        space.asPercent = this.asPercent;
        space.space = this.space;
        return space;
    }
}

