/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.elements;

import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.guidebook.IBookGraphics;
import gigaherz.guidebook.guidebook.PageRef;
import gigaherz.guidebook.guidebook.elements.IClickablePageElement;
import gigaherz.guidebook.guidebook.elements.IHoverPageElement;
import gigaherz.guidebook.guidebook.elements.IPageElement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.util.Rectangle;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Stack
implements IHoverPageElement,
IClickablePageElement {
    public static final int CYCLE_TIME = 1000;
    public static final String WILDCARD = "*";
    public ItemStack[] stacks;
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public float scale = 1.0f;
    public Rectangle bounds;

    @Override
    public int apply(IBookGraphics nav, int left, int top) {
        int width = (int)(16.0f * this.scale);
        int height = (int)(16.0f * this.scale);
        this.bounds = new Rectangle(left += this.x, top += this.y, width, height);
        ItemStack stack = this.getCurrentStack();
        if (stack != null && stack.field_77994_a > 0) {
            nav.drawItemStack(left, top, this.z, stack, -1, this.scale);
        }
        return 0;
    }

    @Override
    public void parse(NamedNodeMap attributes) {
        String oreName;
        List items;
        String itemName;
        Item item;
        int meta = 0;
        int stackSize = 1;
        NBTTagCompound tag = new NBTTagCompound();
        Node attr = attributes.getNamedItem("meta");
        if (attr != null) {
            meta = attr.getTextContent().equals(WILDCARD) ? -1 : Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("count")) != null) {
            stackSize = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("tag")) != null) {
            try {
                tag = JsonToNBT.func_180713_a((String)attr.getTextContent());
            }
            catch (NBTException e) {
                GuidebookMod.logger.warn("Invalid tag format: " + e.getMessage());
            }
        }
        if ((attr = attributes.getNamedItem("item")) != null && (item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName = attr.getTextContent()))) != null) {
            if ((meta == Short.MAX_VALUE || meta == -1) && item.func_77614_k()) {
                ArrayList processedItems = Lists.newArrayList();
                ArrayList subitems = Lists.newArrayList();
                item.func_150895_a(item, null, (List)subitems);
                for (ItemStack subitem : subitems) {
                    if (subitem == null) continue;
                    subitem = subitem.func_77946_l();
                    subitem.field_77994_a = stackSize;
                    subitem.func_77982_d(tag);
                    processedItems.add(subitem);
                }
                this.stacks = processedItems.toArray(new ItemStack[processedItems.size()]);
            } else {
                ItemStack stack = new ItemStack(item, stackSize, meta);
                stack.func_77982_d(tag);
                this.stacks = new ItemStack[]{stack};
            }
        }
        if ((attr = attributes.getNamedItem("ore")) != null && (items = OreDictionary.getOres((String)(oreName = attr.getTextContent()))).size() != 0) {
            ArrayList items_processed = Lists.newArrayList();
            for (ItemStack item2 : items) {
                meta = (item2 = item2.func_77946_l()).func_77960_j();
                if (meta == Short.MAX_VALUE && item2.func_77981_g()) {
                    ArrayList subitems = Lists.newArrayList();
                    item2.func_77973_b().func_150895_a(item2.func_77973_b(), null, (List)subitems);
                    for (ItemStack subitem : subitems) {
                        subitem = subitem.func_77946_l();
                        subitem.field_77994_a = stackSize;
                        subitem.func_77982_d(tag);
                        items_processed.add(subitem);
                    }
                    continue;
                }
                item2.field_77994_a = stackSize;
                items_processed.add(item2);
            }
            this.stacks = items_processed.toArray(new ItemStack[items_processed.size()]);
        }
        if ((attr = attributes.getNamedItem("x")) != null) {
            this.x = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("y")) != null) {
            this.y = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("z")) != null) {
            this.z = Ints.tryParse((String)attr.getTextContent());
        }
        if ((attr = attributes.getNamedItem("scale")) != null) {
            Float f = Floats.tryParse((String)attr.getTextContent());
            this.scale = f != null ? f.floatValue() : this.scale;
        }
    }

    @Override
    public IPageElement copy() {
        Stack stack = new Stack();
        if (this.stacks != null) {
            stack.stacks = new ItemStack[this.stacks.length];
            for (int i = 0; i < this.stacks.length; ++i) {
                stack.stacks[i] = this.stacks[i].func_77946_l();
            }
        } else {
            stack.stacks = null;
        }
        stack.x = this.x;
        stack.y = this.y;
        return stack;
    }

    @Override
    public void mouseOver(IBookGraphics nav, int x, int y) {
        ItemStack stack = this.getCurrentStack();
        if (stack != null && stack.field_77994_a > 0) {
            nav.drawTooltip(stack, x, y);
        }
    }

    @Override
    public void click(IBookGraphics nav) {
        ItemStack stack = this.getCurrentStack();
        if (stack == null) {
            return;
        }
        PageRef ref = nav.getBook().getStackLink(stack);
        if (ref != null) {
            nav.navigateTo(ref);
        }
    }

    @Nullable
    public ItemStack getCurrentStack() {
        if (this.stacks == null || this.stacks.length == 0) {
            return null;
        }
        long time = System.currentTimeMillis();
        return this.stacks[(int)(time / 1000L % (long)this.stacks.length)];
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }
}

