/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.templates;

import com.google.common.collect.Maps;
import gigaherz.guidebook.guidebook.BookDocument;
import gigaherz.guidebook.guidebook.templates.TemplateDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TemplateLibrary {
    public final Map<String, TemplateDefinition> templates = Maps.newHashMap();
    public static Map<String, TemplateLibrary> LIBRARIES = Maps.newHashMap();

    public void parseLibrary(InputStream stream) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(stream);
        doc.getDocumentElement().normalize();
        Node root = doc.getChildNodes().item(0);
        NodeList chaptersList = root.getChildNodes();
        for (int i = 0; i < chaptersList.getLength(); ++i) {
            Node chapterItem = chaptersList.item(i);
            String nodeName = chapterItem.getNodeName();
            if (!nodeName.equals("template")) continue;
            this.parseTemplateDefinition(chapterItem);
        }
    }

    private void parseTemplateDefinition(Node templateItem) {
        if (!templateItem.hasAttributes()) {
            return;
        }
        TemplateDefinition page = new TemplateDefinition();
        NamedNodeMap attributes = templateItem.getAttributes();
        Node n = attributes.getNamedItem("id");
        if (n == null) {
            return;
        }
        this.templates.put(n.getTextContent(), page);
        BookDocument.parseChildElements(templateItem, page.elements, this.templates);
        attributes.removeNamedItem("id");
        page.attributes = attributes;
    }

    public static void clear() {
        LIBRARIES.clear();
    }

    public static TemplateLibrary get(String path) {
        TemplateLibrary lib = LIBRARIES.get(path);
        if (lib == null) {
            try {
                lib = new TemplateLibrary();
                IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(path));
                InputStream stream = res.func_110527_b();
                lib.parseLibrary(stream);
                LIBRARIES.put(path, lib);
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
        }
        return lib;
    }
}

