/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.shadow.common;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class RenamingHelper {
    private final Map<ResourceLocation, Item> upgradeItemNames = Maps.newHashMap();
    private final Map<ResourceLocation, Block> upgradeBlockNames = Maps.newHashMap();
    private final Map<String, Class<? extends TileEntity>> nameToClassMap = (Map)ReflectionHelper.getPrivateValue(TileEntity.class, null, (String[])new String[]{"field_145855_i", "nameToClassMap"});

    public void addAlternativeName(Class<? extends TileEntity> clazz, String altName) {
        this.nameToClassMap.put(altName, clazz);
    }

    public void addAlternativeName(Item item, ResourceLocation altName) {
        this.upgradeItemNames.put(altName, item);
    }

    public void addAlternativeName(Block block, ResourceLocation altName) {
        this.upgradeBlockNames.put(altName, block);
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            this.addAlternativeName(item, altName);
        }
    }

    public void process(FMLMissingMappingsEvent ev) {
        for (FMLMissingMappingsEvent.MissingMapping missing : ev.get()) {
            if (missing.type == GameRegistry.Type.ITEM && this.upgradeItemNames.containsKey(missing.resourceLocation)) {
                missing.remap(this.upgradeItemNames.get(missing.resourceLocation));
            }
            if (missing.type != GameRegistry.Type.BLOCK || !this.upgradeBlockNames.containsKey(missing.resourceLocation)) continue;
            missing.remap(this.upgradeBlockNames.get(missing.resourceLocation));
        }
    }
}

