/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits;

import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import moe.nightfall.vic.integratedcircuits.IntegratedCircuits;
import moe.nightfall.vic.integratedcircuits.api.IAPI;
import moe.nightfall.vic.integratedcircuits.api.gate.GateIOProvider;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocket;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocketProvider;
import moe.nightfall.vic.integratedcircuits.gate.GateRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class API
implements IAPI {
    private List<ISocketProvider> providerList = Lists.newArrayList();
    private GateRegistry gateRegistry = new GateRegistry();

    @Override
    public ISocket getSocketAt(World world, BlockCoord pos, int side) {
        for (ISocketProvider provider : this.providerList) {
            ISocket socket = provider.getSocketAt(world, pos, side);
            if (socket == null) continue;
            return socket;
        }
        return null;
    }

    @Override
    public void registerSocketProvider(ISocketProvider provider) {
        this.providerList.add(provider);
    }

    @Override
    public GateRegistry getGateRegistry() {
        return this.gateRegistry;
    }

    @Override
    public MCDataOutput getWriteStream(World world, BlockCoord pos, int side) {
        return IntegratedCircuits.proxy.addStream(world, pos, side);
    }

    @Override
    public int updateRedstoneInput(ISocket socket, int side) {
        int rotation = socket.getRotationAbs(side);
        int face = socket.getSide();
        int abs = Rotation.rotateSide((int)face, (int)rotation);
        BlockCoord pos = socket.getPos().offset(abs);
        int input = 0;
        input = socket.getWorld().func_72878_l(pos.x, pos.y, pos.z, abs);
        if (socket.getConnectionTypeAtSide(side).isRedstone() && this.hasComparatorInput(socket, pos)) {
            input = this.updateComparatorInput(socket, pos, rotation);
        }
        if (input != 0) {
            return input;
        }
        if (input < 15 && socket.getWorld().func_147439_a(pos.x, pos.y, pos.z) == Blocks.field_150488_af) {
            input = Math.max(input, socket.getWorld().func_72805_g(pos.x, pos.y, pos.z));
        }
        if (input != 0) {
            return input;
        }
        Set<GateIOProvider> providerList = this.gateRegistry.getIOProviderList(socket.getWrapper().getClass());
        for (GateIOProvider provider : providerList) {
            provider.socket = socket;
            input = provider.calculateRedstoneInput(side, rotation, abs, pos);
            if (input == 0) continue;
            return input;
        }
        return input;
    }

    public boolean hasComparatorInput(ISocket socket, BlockCoord pos) {
        Block b = socket.getWorld().func_147439_a(pos.x, pos.y, pos.z);
        return b.func_149740_M();
    }

    public int updateComparatorInput(ISocket socket, BlockCoord pos, int rotation) {
        Block b = socket.getWorld().func_147439_a(pos.x, pos.y, pos.z);
        if (b != null && b.func_149740_M()) {
            return b.func_149736_g(socket.getWorld(), pos.x, pos.y, pos.z, rotation ^ 1);
        }
        return 0;
    }

    @Override
    public byte[] updateBundledInput(ISocket socket, int side) {
        int rotation = socket.getRotationAbs(side);
        int face = socket.getSide();
        int abs = Rotation.rotateSide((int)face, (int)rotation);
        BlockCoord pos = socket.getPos().offset(abs);
        byte[] input = this.updateBundledInputNative(socket, rotation, side, pos);
        if (input != null) {
            return input;
        }
        Set<GateIOProvider> providerList = this.gateRegistry.getIOProviderList(socket.getWrapper().getClass());
        for (GateIOProvider provider : providerList) {
            provider.socket = socket;
            input = provider.calculateBundledInput(side, rotation, abs, pos);
            if (input == null) continue;
            return input;
        }
        return input == null ? new byte[16] : input;
    }

    public byte[] updateBundledInputNative(ISocket socket, int rotation, int side, BlockCoord pos) {
        ISocket neighbour = this.getSocketAt(socket.getWorld(), pos, socket.getSide());
        if (neighbour != null) {
            return neighbour.getOutput()[(side + 2) % 4];
        }
        return null;
    }
}

