/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.Set;
import moe.nightfall.vic.integratedcircuits.IntegratedCircuits;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Config {
    public static Configuration config;
    public static Property showConfirmMessage;
    public static boolean showStartupMessage;
    public static boolean enablePropertyEdit;
    public static boolean enableTracker;
    public static int circuitCacheSize;
    public static boolean enableTooltips;
    public static int sevenSegmentMaxDigits;
    public static boolean enableLegacyLoader;
    public static int colorGreen;
    public static int colorOrange;
    public static int colorRed;

    private Config() {
    }

    public static void preInitialize(File file) {
        config = new Configuration(file);
        config.load();
        Config.loadValues();
        FMLCommonHandler.instance().bus().register((Object)new ChangeHandler());
    }

    public static void loadValues() {
        showConfirmMessage = config.get("GENERAL", "showConfirmMessage", true);
        showStartupMessage = config.getBoolean("showStartupMessage", "GENERAL", true, "");
        enablePropertyEdit = config.getBoolean("enablePropertyEdit", "GENERAL", true, "");
        circuitCacheSize = config.getInt("circuitCacheSize", "GENERAL", 20, 0, Integer.MAX_VALUE, "");
        enableTooltips = config.getBoolean("enableTooltips", "GENERAL", true, "");
        enableTracker = config.getBoolean("enableTracker", "GENERAL", true, "");
        sevenSegmentMaxDigits = config.getInt("sevenSegmentMaxDigits", "GENERAL", 16, 1, 16, "");
        enableLegacyLoader = config.getBoolean("enableLegacyLoader", "GENERAL", true, "");
        try {
            colorGreen = Integer.parseInt(config.getString("color1", "APPEARANCE", "00FF00", ""), 16) | 0xFF000000;
            colorOrange = Integer.parseInt(config.getString("color2", "APPEARANCE", "FF6600", ""), 16) | 0xFF000000;
            colorRed = Integer.parseInt(config.getString("color3", "APPEARANCE", "FF0000", ""), 16) | 0xFF000000;
        }
        catch (NumberFormatException e) {
            colorGreen = -16711936;
            colorOrange = -39424;
            colorRed = -65536;
        }
        config.setCategoryRequiresMcRestart("PARTS", true);
    }

    public static void postInitialize() {
        Config.loadlangKeys();
        Config.loadComments();
        config.save();
    }

    public static void save() {
        if (!showConfirmMessage.hasChanged()) {
            return;
        }
        config.save();
    }

    private static void loadlangKeys() {
        Set categories = config.getCategoryNames();
        for (String category : categories) {
            for (Property p : config.getCategory(category).setLanguageKey("config.integratedcircuits.category.l" + category).values()) {
                Config.addLanguageKeyOrRedirect(p, "config.integratedcircuits." + category + "." + p.getName());
            }
        }
    }

    private static void addLanguageKeyOrRedirect(Property p, String languageKey) {
        String name = StatCollector.func_74838_a((String)languageKey);
        if (name != null && !name.equals(languageKey)) {
            p.setLanguageKey(languageKey);
        } else {
            String redirectKey = languageKey.replace(p.getName(), "redirect");
            String redirectValue = StatCollector.func_74838_a((String)redirectKey);
            if (redirectValue != null && !redirectValue.equals(redirectKey)) {
                redirectValue = redirectValue.replace("%s", p.getName().toLowerCase());
                Config.addLanguageKeyOrRedirect(p, redirectValue);
            } else {
                p.setLanguageKey(languageKey);
            }
        }
    }

    private static void loadComments() {
        Set categories = config.getCategoryNames();
        for (String category : categories) {
            String categoryComment = MiscUtils.translateFormatted("config.integratedcircuits.category." + category + ".tooltip", new Object[0]);
            if (categoryComment != null && !categoryComment.isEmpty()) {
                config.addCustomCategoryComment(category, categoryComment.replace("\\n", "\n").replaceAll("\r", ""));
            }
            for (Property p : config.getCategory(category).values()) {
                String comment;
                String langKey = p.getLanguageKey();
                if (langKey.equals(p.getName())) {
                    langKey = "config.integratedcircuits." + category + "." + p.getName().toLowerCase();
                }
                if ((comment = MiscUtils.translateFormatted(langKey + ".tooltip", new Object[0])) != null && !comment.isEmpty()) {
                    p.comment = comment.replace("\\n", "\n").replaceAll("\r", "") + " [default: " + p.getDefault() + "]";
                    continue;
                }
                p.comment = "[default: " + p.getDefault() + "]";
                if (!IntegratedCircuits.developmentEnvironment) continue;
                p.comment = p.comment + " \n[debug] missing description in " + langKey + ".tooltip ";
            }
        }
    }

    public static class ChangeHandler {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.modID.equals("integratedcircuits")) {
                Config.loadValues();
                Config.loadComments();
                config.save();
            }
        }
    }
}

