/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPart;
import moe.nightfall.vic.integratedcircuits.misc.CraftingAmount;
import moe.nightfall.vic.integratedcircuits.misc.ItemAmount;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import moe.nightfall.vic.integratedcircuits.net.PacketAssemblerChangeLaser;
import moe.nightfall.vic.integratedcircuits.net.PacketAssemblerUpdate;
import moe.nightfall.vic.integratedcircuits.net.PacketAssemblerUpdateInsufficient;
import moe.nightfall.vic.integratedcircuits.proxy.ClientProxy;
import moe.nightfall.vic.integratedcircuits.proxy.CommonProxy;
import moe.nightfall.vic.integratedcircuits.tile.TileEntityAssembler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class LaserHelper {
    private Laser[] lasers = new Laser[4];
    private TileEntityAssembler te;
    public boolean isRunning;
    public int offset;
    public int position;

    public LaserHelper(TileEntityAssembler te, int offset) {
        this.te = te;
        this.offset = offset;
    }

    public int getPosition() {
        return this.position;
    }

    public Laser getLaser(int id) {
        return this.lasers[id];
    }

    public int getLaserAmount() {
        int r = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.lasers[i] == null) continue;
            ++r;
        }
        return r;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateStatus() {
        this.isRunning = false;
        for (Laser laser : this.lasers) {
            if (laser == null || !laser.isRunning) continue;
            this.isRunning = true;
            return;
        }
    }

    public void createLaser(int id, ItemStack laser) {
        this.lasers[id] = laser == null ? null : new Laser(this.te, id);
        this.te.contents[this.offset + id] = laser;
        if (MiscUtils.isServer() && this.te.func_145831_w() != null) {
            CommonProxy.networkWrapper.sendToDimension((IMessage)new PacketAssemblerChangeLaser(this.te.field_145851_c, this.te.field_145848_d, this.te.field_145849_e, id, laser), this.te.func_145831_w().field_73011_w.field_76574_g);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagList lasers = new NBTTagList();
        for (int i = 0; i < 4; ++i) {
            NBTTagCompound comp = new NBTTagCompound();
            if (this.getLaser(i) != null) {
                this.getLaser(i).writeToNBT(comp);
            }
            lasers.func_74742_a((NBTBase)comp);
        }
        tag.func_74782_a("lasers", (NBTBase)lasers);
        tag.func_74757_a("isRunning", this.isRunning);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList lasers = tag.func_150295_c("lasers", 10);
        for (int i = 0; i < 4; ++i) {
            NBTTagCompound comp = lasers.func_150305_b(i);
            if (comp.func_82582_d()) continue;
            ItemStack stack = this.te.contents[i + this.offset];
            this.createLaser(i, stack);
            this.getLaser(i).readFromNBT(comp);
        }
        this.isRunning = tag.func_74767_n("isRunning");
    }

    public void reload() {
        for (Laser laser : this.lasers) {
            if (laser == null) continue;
            laser.reload();
        }
    }

    public void reset() {
        this.isRunning = false;
        this.position = 0;
        for (Laser laser : this.lasers) {
            if (laser == null) continue;
            laser.isRunning = false;
            laser.reset();
        }
    }

    public void start() {
        this.te.excMatrix = new boolean[this.te.size][this.te.size];
        this.isRunning = true;
        for (Laser laser : this.lasers) {
            if (laser == null) continue;
            laser.start();
        }
    }

    public void update() {
        if (this.isRunning) {
            boolean b = false;
            for (int i = 0; i < 4; ++i) {
                Laser laser = this.getLaser(i);
                if (laser == null) continue;
                laser.update(0.0f);
                if (laser.isRunning) {
                    b = true;
                }
                if (!laser.canUpdate()) continue;
                laser.findNext();
            }
            if (!b) {
                this.isRunning = false;
                this.te.onCircuitFinished();
            }
        }
    }

    public static class Laser {
        public int x;
        public int y;
        public int id;
        public float iX;
        public float iY;
        public float iZ;
        public float length;
        private float rotSpeed = 0.4f;
        private float laserSpeed = 1.0f;
        private float lastAY;
        private float lastAZ;
        private float aY;
        private float aZ;
        private float rotTimeAZ;
        private float rotTimeAY;
        private TileEntityAssembler te;
        public boolean isActive = true;
        public boolean isRunning = false;
        private int lastModified;
        private ForgeDirection direction;
        private int step;
        private int max;
        private int turn;

        private Laser(TileEntityAssembler te, int id) {
            this.te = te;
            this.id = id;
            if (MiscUtils.isClient()) {
                this.lastModified = ClientProxy.clientTicks;
            } else {
                this.lastModified = CommonProxy.serverTicks;
                this.reset();
            }
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.isActive = tag.func_74767_n("isActive");
            this.isRunning = tag.func_74767_n("isRunning");
            this.x = tag.func_74762_e("x");
            this.y = tag.func_74762_e("y");
            this.step = tag.func_74762_e("step");
            this.max = tag.func_74762_e("max");
            this.turn = tag.func_74762_e("turn");
            this.direction = ForgeDirection.getOrientation((int)tag.func_74762_e("direction"));
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74757_a("isActive", this.isActive);
            tag.func_74757_a("isRunning", this.isRunning);
            tag.func_74768_a("x", this.x);
            tag.func_74768_a("y", this.y);
            tag.func_74768_a("step", this.step);
            tag.func_74768_a("max", this.max);
            tag.func_74768_a("turn", this.turn);
            tag.func_74768_a("direction", this.direction.ordinal());
            return tag;
        }

        private void reload() {
            float w2 = 0.0f;
            this.lastAY = this.aY;
            this.lastAZ = this.aZ;
            this.iY = this.aY;
            this.iZ = this.aZ;
            if (this.te.refMatrix != null && this.isRunning) {
                float x2 = (float)this.x + 0.5f;
                float y2 = (float)this.y + 0.5f;
                if (this.id == 3 || this.id == 1) {
                    x2 = (float)this.y + 0.5f;
                    y2 = (float)this.x + 0.5f;
                }
                if (this.id == 3 || this.id == 0) {
                    x2 = (float)this.te.size - x2;
                }
                if (this.id == 1 || this.id == 0) {
                    y2 = (float)this.te.size - y2;
                }
                float w1 = 0.625f * (x2 / (float)this.te.size) + (0.1875f - (0.5f - (float)Math.sin(0.7853981633974483) * 0.5f));
                float h1 = 0.625f * (y2 / (float)this.te.size) + (0.1875f - (0.5f - (float)Math.sin(0.7853981633974483) * 0.5f));
                this.aZ = (float)Math.atan(w1 / h1);
                w2 = (float)((double)w1 / Math.sin(this.aZ));
                this.aZ = (float)Math.toDegrees(this.aZ) - 45.0f;
                this.aY = 90.0f - (float)Math.toDegrees(Math.atan(w2 / 0.35f));
                this.length = w2 / (float)Math.sin(Math.toRadians(90.0f - this.aY));
            } else {
                this.aY = 0.0f;
                this.aZ = 0.0f;
            }
        }

        public float getInterpolated(float partialTicks, float f1, float f2, float speed) {
            float dif = f2 - f1;
            float dif2 = MathHelper.func_76131_a((float)(((float)ClientProxy.clientTicks + partialTicks - (float)this.lastModified) / speed), (float)0.0f, (float)1.0f);
            if (dif2 >= 1.0f) {
                return f2;
            }
            return f1 + dif * dif2;
        }

        public void findNext() {
            while (this.isRunning) {
                if (!this.te.excMatrix[this.x][this.y]) {
                    Vec2 pos = new Vec2(this.x, this.y);
                    CircuitPart part = this.te.cdata.getPart(pos);
                    CraftingAmount amount = new CraftingAmount();
                    part.getCraftingCost(amount, this.te.cdata, pos);
                    ItemAmount insufficient = this.te.craftingSupply.getInsufficient();
                    if (!this.te.craftingSupply.request(amount)) {
                        this.te.updateStatus(2);
                        ItemAmount insufficient2 = this.te.craftingSupply.getInsufficient();
                        if (insufficient == null || !insufficient.hasEqualItem(insufficient2)) {
                            CommonProxy.networkWrapper.sendToAllAround((IMessage)new PacketAssemblerUpdateInsufficient(this.te.field_145851_c, this.te.field_145848_d, this.te.field_145849_e, this.te.craftingSupply.getInsufficient()), new NetworkRegistry.TargetPoint(this.te.func_145831_w().field_73011_w.field_76574_g, (double)this.te.field_145851_c, (double)this.te.field_145848_d, (double)this.te.field_145849_e, 8.0));
                        }
                        return;
                    }
                    this.te.updateStatus(1);
                    this.te.excMatrix[this.x][this.y] = true;
                    if (this.te.refMatrix[this.x][this.y] != 0) {
                        this.setAim(this.x, this.y);
                        return;
                    }
                }
                this.x += this.direction.offsetX;
                this.y += this.direction.offsetZ;
                --this.step;
                ++this.te.laserHelper.position;
                if (this.step > 0) continue;
                ++this.turn;
                this.step = this.max--;
                this.direction = MiscUtils.rot(this.direction);
                if (this.turn != 2) continue;
                this.turn = 0;
                if (this.max >= 0) continue;
                this.isRunning = false;
                this.reset();
            }
        }

        public void start() {
            this.isRunning = true;
            this.reset();
        }

        public void setAim(int x, int y) {
            if (MiscUtils.isServer()) {
                CommonProxy.networkWrapper.sendToDimension((IMessage)new PacketAssemblerUpdate(this.isRunning, x, y, this.id, this.te.field_145851_c, this.te.field_145848_d, this.te.field_145849_e), this.te.func_145831_w().field_73011_w.field_76574_g);
            }
            this.x = x;
            this.y = y;
            this.isActive = false;
            this.lastModified = MiscUtils.isClient() ? ClientProxy.clientTicks : CommonProxy.serverTicks;
            this.reload();
            this.rotTimeAZ = Math.abs(this.lastAZ - this.aZ) * this.rotSpeed;
            this.rotTimeAY = Math.abs(this.lastAY - this.aY) * this.rotSpeed;
        }

        public void reset() {
            this.step = this.te.size - 1;
            this.max = this.te.size - 1;
            this.turn = 0;
            this.x = 0;
            this.y = 0;
            switch (this.id) {
                case 0: {
                    this.x = this.te.size - 1;
                    this.y = this.te.size - 1;
                    break;
                }
                case 1: {
                    this.x = this.te.size - 1;
                    break;
                }
                case 3: {
                    this.y = this.te.size - 1;
                }
            }
            switch (this.id) {
                case 0: {
                    this.direction = ForgeDirection.WEST;
                    break;
                }
                case 1: {
                    this.direction = ForgeDirection.SOUTH;
                    break;
                }
                case 2: {
                    this.direction = ForgeDirection.EAST;
                    break;
                }
                default: {
                    this.direction = ForgeDirection.NORTH;
                }
            }
            this.lastModified = MiscUtils.isClient() ? ClientProxy.clientTicks : CommonProxy.serverTicks;
            this.reload();
            if (this.te.func_145831_w() != null && !MiscUtils.isClient()) {
                CommonProxy.networkWrapper.sendToDimension((IMessage)new PacketAssemblerUpdate(this.isRunning, this.x, this.y, this.id, this.te.field_145851_c, this.te.field_145848_d, this.te.field_145849_e), this.te.func_145831_w().field_73011_w.field_76574_g);
            }
        }

        public boolean canUpdate() {
            return this.isActive && (float)CommonProxy.serverTicks >= (float)this.lastModified + this.laserSpeed;
        }

        public void update(float partialTicks) {
            if (!this.isActive) {
                if (this.te.func_145831_w().field_72995_K) {
                    this.iZ = this.getInterpolated(partialTicks, this.lastAZ, this.aZ, this.rotTimeAZ);
                    this.iY = this.getInterpolated(partialTicks, this.lastAY, this.aY, this.rotTimeAY);
                    if (this.iZ == this.aZ && this.iY == this.aY) {
                        this.isActive = true;
                        this.lastModified = ClientProxy.clientTicks;
                    }
                } else if ((float)(CommonProxy.serverTicks - this.lastModified) > this.rotTimeAY && (float)(CommonProxy.serverTicks - this.lastModified) > this.rotTimeAZ) {
                    this.isActive = true;
                    this.lastModified = CommonProxy.serverTicks;
                }
            }
        }
    }
}

