/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.asm;

import java.lang.reflect.Method;
import java.util.Set;
import moe.nightfall.vic.integratedcircuits.API;
import moe.nightfall.vic.integratedcircuits.IntegratedCircuits;
import moe.nightfall.vic.integratedcircuits.api.IntegratedCircuitsAPI;
import moe.nightfall.vic.integratedcircuits.api.gate.GateIOProvider;
import moe.nightfall.vic.integratedcircuits.asm.StaticForwarder;
import moe.nightfall.vic.integratedcircuits.gate.GateRegistry;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class GPInjectorTransformer
implements IClassTransformer,
Opcodes {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.startsWith("moe.nightfall.vic.integratedcircuits.api") || transformedName.equals("moe.nightfall.vic.integratedcircuits.IntegratedCircuits") || transformedName.equals("moe.nightfall.vic.integratedcircuits.API")) {
            return basicClass;
        }
        for (IntegratedCircuitsAPI.Type type : IntegratedCircuitsAPI.Type.values()) {
            if (!type.classname.equals(transformedName)) continue;
            return this.transform(type, basicClass);
        }
        return basicClass;
    }

    private byte[] transform(IntegratedCircuitsAPI.Type type, byte[] basicClass) {
        Type ioProviderType = Type.getType(GateIOProvider.class);
        GateRegistry gateRegistry = IntegratedCircuits.API.getGateRegistry();
        gateRegistry.lock();
        IntegratedCircuits.logger.info("Injecting gate providers to class " + type.classname);
        ClassNode clazzNode = new ClassNode();
        ClassReader cr = new ClassReader(basicClass);
        cr.accept((ClassVisitor)clazzNode, 0);
        Set<Class<?>> intfMapping = gateRegistry.getInterfaceMapping(type);
        for (Class<?> intf : intfMapping) {
            clazzNode.interfaces.add(Type.getInternalName(intf));
            for (Method m : intf.getMethods()) {
                boolean isVoid = m.getReturnType() == null;
                String desc = Type.getMethodDescriptor((Method)m);
                MethodVisitor mv = clazzNode.visitMethod(1, m.getName(), desc, null, this.getExceptionTypes(m));
                mv.visitCode();
                mv.visitFieldInsn(178, Type.getInternalName(IntegratedCircuits.class), "API", Type.getDescriptor(API.class));
                mv.visitMethodInsn(182, Type.getInternalName(API.class), "getGateRegistry", Type.getMethodDescriptor((Type)Type.getType(GateRegistry.class), (Type[])new Type[0]), false);
                mv.visitLdcInsn((Object)Type.getType(intf));
                mv.visitMethodInsn(182, Type.getInternalName(GateRegistry.class), "getProvider", Type.getMethodDescriptor((Type)ioProviderType, (Type[])new Type[]{Type.getType(Class.class)}), false);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(184, Type.getInternalName(StaticForwarder.class), "inject", Type.getMethodDescriptor((Type)ioProviderType, (Type[])new Type[]{ioProviderType, Type.getType(Object.class)}), false);
                Class<?>[] parameters = m.getParameterTypes();
                for (int i = 0; i < parameters.length; ++i) {
                    mv.visitVarInsn(Type.getType(parameters[i]).getOpcode(21), i + 1);
                }
                mv.visitMethodInsn(185, Type.getInternalName(intf), m.getName(), desc, true);
                mv.visitInsn(isVoid ? 177 : Type.getType(m.getReturnType()).getOpcode(172));
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
        }
        IntegratedCircuits.logger.info("Injected interfaces " + intfMapping);
        ClassWriter cw = new ClassWriter(1);
        clazzNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public String[] getExceptionTypes(Method m) {
        Class<?>[] execTypes = m.getExceptionTypes();
        String[] exc = new String[execTypes.length];
        for (int i = 0; i < m.getExceptionTypes().length; ++i) {
            exc[i] = Type.getInternalName(execTypes[i]);
        }
        return exc;
    }
}

