/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.client;

import codechicken.lib.vec.Transformation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import moe.nightfall.vic.integratedcircuits.client.PartRenderer;
import moe.nightfall.vic.integratedcircuits.client.Resources;
import moe.nightfall.vic.integratedcircuits.client.model.ModelSegment;
import moe.nightfall.vic.integratedcircuits.gate.Gate7Segment;
import moe.nightfall.vic.integratedcircuits.misc.RenderUtils;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class Gate7SegmentRenderer
extends PartRenderer<Gate7Segment> {
    private int display;
    private int color;

    public Gate7SegmentRenderer() {
        this.models.add(new ModelSegment());
    }

    @Override
    public void prepare(Gate7Segment part) {
    }

    @Override
    public void prepareInv(ItemStack stack) {
        this.display = 127;
        this.color = stack.func_77960_j();
    }

    @Override
    public void prepareDynamic(Gate7Segment part, float partialTicks) {
        this.display = part.digit;
        this.color = part.color;
    }

    @Override
    public void renderDynamic(Transformation t) {
        GL11.glPushMatrix();
        t.glApply();
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        GL11.glTranslatef((float)0.265625f, (float)0.0645f, (float)0.171875f);
        GL11.glDisable((int)2896);
        Gate7SegmentRenderer.render7Segment(this.display, 0.020833334f, this.color);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public static void render7Segment(int display, float scale, int color) {
        Gate7SegmentRenderer.renderSegment((display & 2) != 0, 17, 4, 20, 15, scale, color);
        Gate7SegmentRenderer.renderSegment((display & 4) != 0, 17, 18, 20, 29, scale, color);
        Gate7SegmentRenderer.renderSegment((display & 1) != 0, 6, 1, 17, 4, scale, color);
        Gate7SegmentRenderer.renderSegment((display & 0x40) != 0, 6, 15, 17, 18, scale, color);
        Gate7SegmentRenderer.renderSegment((display & 8) != 0, 6, 29, 17, 32, scale, color);
        Gate7SegmentRenderer.renderSegment((display & 0x10) != 0, 3, 18, 6, 29, scale, color);
        Gate7SegmentRenderer.renderSegment((display & 0x20) != 0, 3, 4, 6, 15, scale, color);
        Gate7SegmentRenderer.renderSegment((display & 0x80) != 0, 20, 29, 23, 32, scale, color);
    }

    public static void renderSegment(boolean enabled, int x1, int y1, int x2, int y2, float scale, int color) {
        color = MapColor.func_151644_a((int)color).field_76291_p;
        if (enabled) {
            RenderUtils.applyColorIRGB(color);
            RenderUtils.setBrightness(240.0f, 240.0f);
        } else {
            RenderUtils.applyColorIRGB(color, 0.2f);
        }
        double u1 = Resources.ICON_IC_SEGMENT.func_94214_a((double)x1 / 2.0);
        double u2 = Resources.ICON_IC_SEGMENT.func_94214_a((double)x2 / 2.0);
        double v1 = Resources.ICON_IC_SEGMENT.func_94207_b((double)y1 / 2.0);
        double v2 = Resources.ICON_IC_SEGMENT.func_94207_b((double)y2 / 2.0);
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78382_b();
        tes.func_78374_a((double)((float)x1 * scale), 0.0, (double)((float)y1 * scale), u1, v1);
        tes.func_78374_a((double)((float)x1 * scale), 0.0, (double)((float)y2 * scale), u1, v2);
        tes.func_78374_a((double)((float)x2 * scale), 0.0, (double)((float)y2 * scale), u2, v2);
        tes.func_78374_a((double)((float)x2 * scale), 0.0, (double)((float)y1 * scale), u2, v1);
        tes.func_78381_a();
        if (enabled) {
            RenderUtils.resetBrightness();
        }
    }
}

