/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.client;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import moe.nightfall.vic.integratedcircuits.api.IPartRenderer;
import moe.nightfall.vic.integratedcircuits.client.model.IComponentModel;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

@SideOnly(value=Side.CLIENT)
public abstract class PartRenderer<T>
implements IPartRenderer<T> {
    protected List<IComponentModel> models = Lists.newLinkedList();

    @Override
    public void prepare(T part) {
    }

    @Override
    public void prepareInv(ItemStack stack) {
    }

    @Override
    public void prepareDynamic(T part, float partialTicks) {
    }

    @Override
    public void renderStatic(Transformation t) {
        for (IComponentModel m : this.models) {
            m.renderModel(t);
        }
    }

    @Override
    public void renderDynamic(Transformation t) {
    }

    @Override
    public List<IComponentModel> getModels() {
        return this.models;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.prepareInv(item);
        switch (type) {
            case ENTITY: {
                this.renderPart(item, -0.3f, 0.0f, -0.3f, 0.6f);
                break;
            }
            case EQUIPPED: {
                this.renderPart(item, 0.0f, 0.15f, 0.0f, 1.0f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderPart(item, 1.0f, -0.2f, -0.4f, 2.0f);
                break;
            }
            case INVENTORY: {
                this.renderPart(item, 0.0f, 0.2f, 0.0f, 1.0f);
                break;
            }
        }
    }

    protected void renderPart(ItemStack stack, float x, float y, float z, float scale) {
        TextureUtils.bindAtlas((int)0);
        CCRenderState.reset();
        CCRenderState.setDynamic();
        CCRenderState.pullLightmap();
        this.prepareInv(stack);
        CCRenderState.startDrawing();
        this.renderStatic((Transformation)new Scale((double)scale).with((Transformation)new Translation((double)x, (double)y, (double)z)));
        CCRenderState.draw();
        this.renderDynamic((Transformation)new Scale((double)scale).with((Transformation)new Translation((double)x, (double)y, (double)z)));
    }
}

