/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import moe.nightfall.vic.integratedcircuits.IntegratedCircuits;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ShaderHelper {
    public static int SHADER_BLUR;

    public static void loadShaders() {
        IntegratedCircuits.logger.info("Loading shaders, GLSL version supported: " + GL11.glGetString((int)35724));
        if (!OpenGlHelper.field_148824_g) {
            return;
        }
        SHADER_BLUR = ShaderHelper.createProgramm("/assets/integratedcircuits/shader/blur.vert", "/assets/integratedcircuits/shader/blur.frag");
    }

    public static int createProgramm(String vertexShader, String fragmentShader) {
        int vertShader = 0;
        int fragShader = 0;
        try {
            if (vertexShader != null) {
                vertShader = ShaderHelper.createShader(vertexShader, 35633);
            }
            if (fragmentShader != null) {
                fragShader = ShaderHelper.createShader(fragmentShader, 35632);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return 0;
        }
        int program = ARBShaderObjects.glCreateProgramObjectARB();
        if (program == 0) {
            return 0;
        }
        if (vertShader != 0) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertShader);
        }
        if (fragShader != 0) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragShader);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            IntegratedCircuits.logger.fatal(ARBShaderObjects.glGetInfoLogARB((int)program, (int)ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35716)));
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            IntegratedCircuits.logger.fatal(ARBShaderObjects.glGetInfoLogARB((int)program, (int)ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35716)));
            return 0;
        }
        return program;
    }

    public static int createShader(String filename, int shaderType) throws Exception {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            InputStream in = ShaderHelper.class.getResourceAsStream(filename);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            CharBuffer cbuf = CharBuffer.allocate(in.available());
            reader.read(cbuf);
            reader.close();
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)new String(cbuf.array()));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ARBShaderObjects.glGetInfoLogARB((int)shader, (int)ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35716)));
            }
            return shader;
        }
        catch (Exception exc) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            throw exc;
        }
    }

    public static void printErrorLog(int program) {
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        ARBShaderObjects.glGetObjectParameterARB((int)program, (int)35716, (IntBuffer)intBuffer);
        int length = intBuffer.get();
        if (length > 1) {
            ByteBuffer infoLog = BufferUtils.createByteBuffer((int)length);
            intBuffer.flip();
            ARBShaderObjects.glGetInfoLogARB((int)program, (IntBuffer)intBuffer, (ByteBuffer)infoLog);
            byte[] infoBytes = new byte[length];
            infoLog.get(infoBytes);
            String out = new String(infoBytes);
            IntegratedCircuits.logger.fatal("Shader info log:\n" + out);
        }
    }

    public static void bindShader(int program) {
        if (!OpenGlHelper.field_148824_g) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)program);
    }

    public static void releaseShader() {
        ARBShaderObjects.glUseProgramObjectARB((int)0);
    }
}

