/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.client;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.render.uv.IconTransformation;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import moe.nightfall.vic.integratedcircuits.Config;
import moe.nightfall.vic.integratedcircuits.Content;
import moe.nightfall.vic.integratedcircuits.api.IPartRenderer;
import moe.nightfall.vic.integratedcircuits.api.IntegratedCircuitsAPI;
import moe.nightfall.vic.integratedcircuits.api.gate.IGate;
import moe.nightfall.vic.integratedcircuits.api.gate.IGateItem;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocket;
import moe.nightfall.vic.integratedcircuits.client.PartRenderer;
import moe.nightfall.vic.integratedcircuits.client.Resources;
import moe.nightfall.vic.integratedcircuits.client.model.ModelBase;
import moe.nightfall.vic.integratedcircuits.proxy.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SocketRenderer
extends PartRenderer<ISocket> {
    private ISocket socket;
    private float partialTicks;

    public SocketRenderer(String iconName) {
        this.models.add(new ModelBase(iconName));
    }

    @Override
    public void prepare(ISocket socket) {
        this.socket = socket;
        if (socket != null && socket.getGate() != null) {
            IntegratedCircuitsAPI.getGateRegistry().getRenderer(socket.getGate().getClass()).prepare(socket.getGate());
        }
    }

    @Override
    public void prepareInv(ItemStack stack) {
        this.socket = null;
    }

    @Override
    public void prepareDynamic(ISocket socket, float partialTicks) {
        this.partialTicks = partialTicks;
        this.socket = socket;
        if (socket != null && socket.getGate() != null) {
            IntegratedCircuitsAPI.getGateRegistry().getRenderer(socket.getGate().getClass()).prepareDynamic(socket.getGate(), partialTicks);
        }
    }

    @Override
    public void renderStatic(Transformation t) {
        if (this.socket != null) {
            Transformation rotation = Rotation.sideOrientation((int)this.socket.getSide(), (int)this.socket.getRotation()).at(Vector3.center);
            t = rotation.with(t);
            this.renderConnections(t);
        }
        super.renderStatic(t);
        t = new Translation(0.0, 0.125, 0.0).with(t);
        if (this.socket != null && this.socket.getGate() != null) {
            IntegratedCircuitsAPI.getGateRegistry().getRenderer(this.socket.getGate().getClass()).renderStatic(t);
        }
    }

    protected void renderCreativeTabConnections(Transformation t, Cuboid6 dimensions) {
        for (int i = 0; i < 4; ++i) {
            double size = this.getInset(i, dimensions);
            this.renderBundledConnection(t, i, size, 0, 0);
        }
    }

    protected void renderConnections(Transformation t) {
        if (this.socket == null || this.socket.getGate() == null) {
            return;
        }
        int face = this.socket.getSide();
        for (int i = 0; i < 4; ++i) {
            double size = this.getInset(i);
            ISocket.EnumConnectionType type = this.socket.getConnectionTypeAtSide(i);
            if (type.isRedstone()) {
                this.renderRedstoneConnection(t, i, size);
                continue;
            }
            if (!type.isBundled()) continue;
            this.renderBundledConnection(t, i, size, face, this.socket.getRotationAbs(i));
        }
    }

    private void renderRedstoneConnection(Transformation t, int i, double size) {
        IIcon icon = (this.socket.getRedstoneIO() & 1 << i) != 0 ? Resources.ICON_IC_RSWIRE_ON : Resources.ICON_IC_RSWIRE_OFF;
        CCModel model = CCModel.quadModel((int)72);
        model.generateBox(0, 7.0, 2.0, 0.0, 2.0, 0.32, size, 0.0, 0.0, 16.0, 16.0, 16.0);
        model.generateBox(24, 6.0, 2.0, 0.0, 1.0, 0.16, size, 9.0, 0.0, 16.0, 16.0, 16.0);
        model.generateBox(48, 9.0, 2.0, 0.0, 1.0, 0.16, size, 9.0, 0.0, 16.0, 16.0, 16.0);
        model.computeNormals();
        model.apply(new Rotation((double)(-i) * Math.PI / 2.0, 0.0, 1.0, 0.0).at(Vector3.center));
        model.apply(t);
        model.computeLighting(LightModel.standardLightModel);
        model.render(new CCRenderState.IVertexOperation[]{new IconTransformation(icon)});
    }

    private void renderBundledConnection(Transformation t, int i, double size, int face, int abs) {
        CCModel model = CCModel.quadModel((int)24);
        model.generateBlock(0, 0.3125, 0.0, 0.0, 0.6875, 0.25, size / 16.0);
        model.computeNormals();
        model.apply(new Rotation((double)(-i) * Math.PI / 2.0, 0.0, 1.0, 0.0).at(Vector3.center));
        model.apply(t);
        model.computeLighting(LightModel.standardLightModel);
        boolean flipped = abs == 3 || abs == 2 && (face == 0 || face == 3 || face == 4) || abs == 0 && (face == 1 || face == 2 || face == 5);
        model.render(new CCRenderState.IVertexOperation[]{new IconTransformation(flipped ? Resources.ICON_IC_WIRE : Resources.ICON_IC_WIRE_FLIPPED)});
    }

    protected double getInset(int side) {
        return this.getInset(side, this.socket.getGate().getDimension());
    }

    protected double getInset(int side, Cuboid6 dimensions) {
        double inset;
        switch (side) {
            case 0: {
                inset = dimensions.min.z;
                break;
            }
            case 1: {
                inset = 16.0 - dimensions.max.x;
                break;
            }
            case 2: {
                inset = 16.0 - dimensions.max.z;
                break;
            }
            default: {
                inset = dimensions.min.x;
            }
        }
        return inset;
    }

    @Override
    public void renderDynamic(Transformation t) {
        EntityClientPlayerMP player;
        ItemStack stack;
        if (this.socket != null && this.socket.getGate() != null) {
            Transformation rotation = Rotation.sideOrientation((int)this.socket.getSide(), (int)this.socket.getRotation()).at(Vector3.center);
            IntegratedCircuitsAPI.getGateRegistry().getRenderer(this.socket.getGate().getClass()).renderDynamic((Transformation)new Translation(0.0, 0.125, 0.0).with(rotation).with(t));
        } else if (this.socket != null && (stack = (player = Minecraft.func_71410_x().field_71439_g).func_71045_bC()) != null && stack.func_77973_b() instanceof IGateItem) {
            MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
            BlockCoord pos = this.socket.getPos();
            if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && mop.field_72311_b == pos.x && mop.field_72312_c == pos.y && mop.field_72309_d == pos.z && mop.field_72310_e == (this.socket.getSide() ^ 1)) {
                if (!player.field_71071_by.func_146028_b(Content.itemSolderingIron) && !player.field_71075_bZ.field_75098_d) {
                    if (Config.enableTooltips) {
                        ClientProxy.drawTooltip(I18n.func_135052_a((String)"tooltip.integratedcircuits.socket", (Object[])new Object[0]));
                    }
                    return;
                }
                String gateID = ((IGateItem)stack.func_77973_b()).getGateID(stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, pos);
                IPartRenderer<IGate> renderer = IntegratedCircuitsAPI.getGateRegistry().getRenderer(gateID);
                int rotation = Rotation.getSidedRotation((EntityPlayer)player, (int)(this.socket.getSide() ^ 1));
                t = new Translation(0.0, 0.125, 0.0).with(Rotation.sideOrientation((int)this.socket.getSide(), (int)rotation).at(Vector3.center)).with(t);
                TextureUtils.bindAtlas((int)0);
                CCRenderState.reset();
                CCRenderState.setDynamic();
                CCRenderState.pullLightmap();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glEnable((int)3008);
                renderer.prepareInv(stack);
                CCRenderState.alphaOverride = (int)(120.0 + 20.0 * Math.sin((double)((float)ClientProxy.clientTicks + this.partialTicks) / 5.0));
                CCRenderState.startDrawing();
                renderer.renderStatic(t);
                CCRenderState.draw();
                renderer.renderDynamic(t);
                CCRenderState.alphaOverride = 0;
                GL11.glDisable((int)3042);
            }
        }
    }
}

