/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

public class TextureRenderer {
    private Set<Entry> schedule = Sets.newLinkedHashSet();
    private List<Integer> textureList = Lists.newLinkedList();
    private Framebuffer fbo;

    public TextureRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START && this.schedule.size() > 0) {
            int currentFBO = GL11.glGetInteger((int)36006);
            if (this.fbo == null) {
                this.fbo = new Framebuffer(256, 256, false);
            }
            this.fbo.func_147609_e();
            this.fbo.func_147610_a(false);
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glViewport((int)0, (int)0, (int)256, (int)256);
            GL11.glOrtho((double)0.0, (double)256.0, (double)256.0, (double)0.0, (double)-1.0, (double)1.0);
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            for (Entry entry : this.schedule) {
                this.updateFramebuffer(entry, event.renderTickTime);
            }
            this.schedule.clear();
            GL11.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            this.fbo.func_147609_e();
            OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)currentFBO);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        try {
            for (Integer texture : this.textureList) {
                TextureUtil.func_147942_a((int)texture);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.textureList.clear();
    }

    public void schedule(Entry entry) {
        this.schedule.add(entry);
    }

    public void delete(Entry entry) {
        TextureUtil.func_147942_a((int)entry.texture);
    }

    private void updateFramebuffer(Entry entry, float partial) {
        if (entry.texture == -1) {
            this.fbo.field_147617_g = TextureUtil.func_110996_a();
            entry.texture = this.fbo.field_147617_g;
            this.textureList.add(entry.texture);
            this.fbo.func_147607_a(9728);
            GL11.glBindTexture((int)3553, (int)this.fbo.field_147617_g);
            GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)this.fbo.field_147622_a, (int)this.fbo.field_147620_b, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
            OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.fbo.field_147616_f);
        }
        this.fbo.field_147617_g = entry.texture;
        OpenGlHelper.func_153188_a((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153200_g, (int)3553, (int)this.fbo.field_147617_g, (int)0);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        entry.render(partial);
        GL11.glPopMatrix();
    }

    public static abstract class Entry {
        private int texture = -1;

        public final int textureID() {
            return this.texture;
        }

        public abstract void render(float var1);
    }
}

