/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.client.gui.cad;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import moe.nightfall.vic.integratedcircuits.client.gui.cad.CADHandler;
import moe.nightfall.vic.integratedcircuits.client.gui.cad.GuiCAD;
import moe.nightfall.vic.integratedcircuits.client.gui.component.GuiTextArea;
import moe.nightfall.vic.integratedcircuits.cp.CircuitProperties;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.misc.RenderUtils;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBComment;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBDeleteComment;
import moe.nightfall.vic.integratedcircuits.proxy.CommonProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import org.lwjgl.opengl.GL11;

public class CommentHandler
extends CADHandler {
    private CircuitProperties.Comment selectedComment;
    private Map<CircuitProperties.Comment, Vec2> sizeCache = new WeakHashMap<CircuitProperties.Comment, Vec2>();
    public Mode mode = Mode.EDIT;
    private GuiTextArea textArea = new GuiTextArea(0, 0).setBackgroundColor(-1).setTextColor(-16777216).setCursorColor(-16777216).setVisible(false).setActive(false);
    private double dragRelX;
    private double dragRelY;

    @Override
    public void render(GuiCAD parent, int mx, int my) {
        CircuitProperties.Comment hovered = this.getIntersecting(parent, parent.boardAbs2RelX(mx), parent.boardAbs2RelY(my));
        GL11.glPushMatrix();
        GL11.glScalef((float)0.03125f, (float)0.03125f, (float)0.03125f);
        for (CircuitProperties.Comment comment : parent.getCircuitData().getProperties().getComments()) {
            if (this.mode == Mode.EDIT && this.selectedComment == comment) {
                this.renderEditComment(comment, my, my);
                continue;
            }
            this.renderComment(comment, hovered == comment);
        }
        GL11.glPopMatrix();
    }

    private void refreshCache(GuiCAD parent) {
        this.sizeCache.clear();
        for (CircuitProperties.Comment comment : parent.getCircuitData().getProperties().getComments()) {
            this.sizeCache.put(comment, this.calculateSize(comment));
        }
    }

    private Vec2 calculateSize(CircuitProperties.Comment comment) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        String[] text = MiscUtils.stringNewlineSplit(comment.text);
        int width = 10;
        int height = Math.max(fr.field_78288_b, text.length * fr.field_78288_b) + 10;
        for (int i = 0; i < text.length; ++i) {
            width = Math.max(width, fr.func_78256_a(text[i]));
        }
        return new Vec2(width += 10, height);
    }

    private Vec2 getSize(CircuitProperties.Comment comment) {
        Vec2 size = this.sizeCache.get(comment);
        if (size == null) {
            size = this.calculateSize(comment);
            this.sizeCache.put(comment, size);
        }
        return size;
    }

    private CircuitProperties.Comment getIntersecting(GuiCAD parent, double gridX, double gridY) {
        Collection<CircuitProperties.Comment> comments = parent.getCircuitData().getProperties().getComments();
        for (CircuitProperties.Comment comment : Lists.reverse(new ArrayList<CircuitProperties.Comment>(comments))) {
            Vec2 size = this.getSize(comment);
            double x = comment.xPos;
            double y = comment.yPos;
            double width = (double)size.x / 32.0;
            double height = (double)size.y / 32.0;
            if (!(gridX >= x) || !(gridY >= y) || !(gridX < x + width) || !(gridY < y + height)) continue;
            return comment;
        }
        return null;
    }

    @Override
    public void onMouseDown(GuiCAD parent, int mx, int my, int button) {
        if (parent.func_146272_n()) {
            return;
        }
        double gridX = parent.boardAbs2RelX(mx);
        double gridY = parent.boardAbs2RelY(my);
        CircuitProperties.Comment unselectedComment = this.selectedComment;
        this.selectedComment = this.getIntersecting(parent, gridX, gridY);
        if (this.selectedComment != null) {
            parent.getCircuitData().getProperties().removeComment(this.selectedComment);
            parent.getCircuitData().getProperties().addComment(this.selectedComment);
        }
        if (this.selectedComment != null) {
            if (this.mode == Mode.MOVE) {
                this.dragRelX = gridX - this.selectedComment.xPos;
                this.dragRelY = gridY - this.selectedComment.yPos;
            } else if (this.mode == Mode.DELETE) {
                parent.getCircuitData().getProperties().removeComment(this.selectedComment);
                CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBDeleteComment(parent.tileentity.field_145851_c, parent.tileentity.field_145848_d, parent.tileentity.field_145849_e, this.selectedComment));
                this.selectedComment = null;
            } else if (this.mode == Mode.EDIT && this.selectedComment != unselectedComment) {
                this.textArea.setText(this.selectedComment.text);
            }
        } else if (this.mode == Mode.EDIT) {
            if (unselectedComment == null) {
                this.selectedComment = new CircuitProperties.Comment(gridX, gridY).setText("<Comment>");
                this.textArea.setText(this.selectedComment.text);
                this.textArea.selectAll();
                this.textArea.setActive(true);
                parent.getCircuitData().getProperties().addComment(this.selectedComment);
                return;
            }
            this.saveText(unselectedComment, parent);
        }
        if (this.mode == Mode.EDIT && this.selectedComment != null) {
            this.textArea.onMouseDown((int)((gridX - this.selectedComment.xPos) * 32.0), (int)((gridY - this.selectedComment.yPos) * 32.0), button);
        }
    }

    private void saveText(CircuitProperties.Comment comment, GuiCAD parent) {
        if (comment == null) {
            return;
        }
        comment.setText(this.textArea.getText());
        this.sizeCache.remove(comment);
        CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBComment(parent.tileentity.field_145851_c, parent.tileentity.field_145848_d, parent.tileentity.field_145849_e, comment));
    }

    @Override
    public void onMouseUp(GuiCAD parent, int mx, int my, int button) {
        if (this.mode == Mode.MOVE) {
            if (this.selectedComment != null) {
                CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBComment(parent.tileentity.field_145851_c, parent.tileentity.field_145848_d, parent.tileentity.field_145849_e, this.selectedComment));
            }
            this.selectedComment = null;
        }
    }

    @Override
    public void onMouseDragged(GuiCAD parent, int mx, int my) {
        double gridX = parent.boardAbs2RelX(mx);
        double gridY = parent.boardAbs2RelY(my);
        if (this.mode == Mode.MOVE && this.selectedComment != null) {
            this.selectedComment.xPos = gridX - this.dragRelX;
            this.selectedComment.yPos = gridY - this.dragRelY;
            double gridOffsetX = this.selectedComment.xPos - Math.floor(this.selectedComment.xPos);
            double gridOffsetY = this.selectedComment.yPos - Math.floor(this.selectedComment.yPos);
            if (this.selectedComment.xPos >= -1.0 && this.selectedComment.xPos <= (double)parent.getBoardSize() && this.selectedComment.yPos >= -1.0 && this.selectedComment.yPos <= (double)parent.getBoardSize()) {
                if (gridOffsetX < 0.1875) {
                    this.selectedComment.xPos = Math.floor(this.selectedComment.xPos);
                } else if (gridOffsetX > 0.8125) {
                    this.selectedComment.xPos = Math.ceil(this.selectedComment.xPos);
                }
                if (gridOffsetY < 0.1875) {
                    this.selectedComment.yPos = Math.floor(this.selectedComment.yPos);
                } else if (gridOffsetY > 0.8125) {
                    this.selectedComment.yPos = Math.ceil(this.selectedComment.yPos);
                }
            }
        } else if (this.mode == Mode.EDIT && this.selectedComment != null && this.textArea.isActive()) {
            this.textArea.onMouseDragged((int)((gridX - this.selectedComment.xPos) * 32.0), (int)((gridY - this.selectedComment.yPos) * 32.0));
        }
    }

    @Override
    public boolean onKeyTyped(GuiCAD parent, int keycode, char ch) {
        if (this.mode == Mode.EDIT && this.selectedComment != null) {
            this.textArea.onKeyTyped(keycode, ch);
            if (!this.textArea.isActive()) {
                this.saveText(this.selectedComment, parent);
                this.selectedComment = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public void apply(GuiCAD parent) {
        super.apply(parent);
        this.refreshCache(parent);
        this.saveText(this.selectedComment, parent);
        this.selectedComment = null;
    }

    @Override
    public void remove(GuiCAD parent) {
        super.remove(parent);
        this.saveText(this.selectedComment, parent);
    }

    public void renderComment(CircuitProperties.Comment comment, boolean hovered) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int x = (int)(comment.xPos * 32.0);
        int y = (int)(comment.yPos * 32.0);
        Vec2 size = this.getSize(comment);
        Gui.func_73734_a((int)x, (int)y, (int)(x + size.x), (int)(y + size.y), (int)(hovered || !this.isActive() || comment == this.selectedComment ? -1 : -1426063361));
        fr.func_78279_b(MiscUtils.stringNormalizeLinefeed(comment.text), x + 5, y + 5, Integer.MAX_VALUE, -16777216);
        RenderUtils.drawBorder(x, y, size.x, size.y);
    }

    public void renderEditComment(CircuitProperties.Comment comment, int mx, int my) {
        int x = (int)(comment.xPos * 32.0);
        int y = (int)(comment.yPos * 32.0);
        this.textArea.setVisible(true);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        this.textArea.render(mx, my);
        GL11.glPopMatrix();
        Vec2 size = this.textArea.getSize();
        RenderUtils.drawBorder(x, y, size.x, size.y);
    }

    public static enum Mode {
        EDIT,
        MOVE,
        DELETE;

    }
}

