/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.client.gui.cad;

import codechicken.lib.math.MathHelper;
import com.google.common.collect.Lists;
import cpw.mods.fml.client.config.GuiButtonExt;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import moe.nightfall.vic.integratedcircuits.Config;
import moe.nightfall.vic.integratedcircuits.ContainerCAD;
import moe.nightfall.vic.integratedcircuits.client.Resources;
import moe.nightfall.vic.integratedcircuits.client.gui.GuiInterfaces;
import moe.nightfall.vic.integratedcircuits.client.gui.cad.CADHandler;
import moe.nightfall.vic.integratedcircuits.client.gui.cad.CommentHandler;
import moe.nightfall.vic.integratedcircuits.client.gui.cad.EditHandler;
import moe.nightfall.vic.integratedcircuits.client.gui.cad.PlaceHandler;
import moe.nightfall.vic.integratedcircuits.client.gui.cad.SelectionHandler;
import moe.nightfall.vic.integratedcircuits.client.gui.component.GuiCallback;
import moe.nightfall.vic.integratedcircuits.client.gui.component.GuiCheckBoxExt;
import moe.nightfall.vic.integratedcircuits.client.gui.component.GuiIO;
import moe.nightfall.vic.integratedcircuits.client.gui.component.GuiIOMode;
import moe.nightfall.vic.integratedcircuits.client.gui.component.GuiIconButton;
import moe.nightfall.vic.integratedcircuits.client.gui.component.GuiLabel;
import moe.nightfall.vic.integratedcircuits.client.gui.component.GuiPartChooser;
import moe.nightfall.vic.integratedcircuits.client.gui.component.GuiRollover;
import moe.nightfall.vic.integratedcircuits.client.gui.component.GuiStateLabel;
import moe.nightfall.vic.integratedcircuits.compat.NEIAddon;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPart;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPartRenderer;
import moe.nightfall.vic.integratedcircuits.cp.part.PartNull;
import moe.nightfall.vic.integratedcircuits.cp.part.PartTunnel;
import moe.nightfall.vic.integratedcircuits.cp.part.PartWire;
import moe.nightfall.vic.integratedcircuits.cp.part.cell.PartNullCell;
import moe.nightfall.vic.integratedcircuits.cp.part.timed.IConfigurableDelay;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.misc.RenderUtils;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBCache;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBChangeName;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBChangePart;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBClear;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBPrint;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBSaveLoad;
import moe.nightfall.vic.integratedcircuits.proxy.CommonProxy;
import moe.nightfall.vic.integratedcircuits.tile.TileEntityCAD;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiCAD
extends GuiContainer
implements GuiInterfaces.IGuiCallback,
GuiInterfaces.IHoverableHandler {
    public TileEntityCAD tileentity;
    public EditHandler editHandler = new EditHandler();
    public PlaceHandler placeHandler = new PlaceHandler();
    public CommentHandler commentHandler = new CommentHandler();
    public SelectionHandler selectionHandler = new SelectionHandler();
    private CADHandler currentHandler;
    private List<CADHandler> handlers = new ArrayList<CADHandler>();
    public GuiPartChooser selectedChooser;
    public boolean blockMouseInput = false;
    private GuiInterfaces.IHoverable hoveredElement;
    protected int guiRight;
    protected int guiBottom;
    protected int xSizeEditor;
    protected int ySizeEditor;
    protected int editorTop;
    protected int editorBottom;
    protected int editorLeft;
    protected int editorRight;
    protected int lastX;
    protected int lastY;
    private GuiTextField nameField;
    private GuiButtonExt buttonPlus;
    private GuiButtonExt buttonMinus;
    private GuiButtonExt buttonSize;
    private GuiIOMode checkN;
    private GuiIOMode checkE;
    private GuiIOMode checkS;
    private GuiIOMode checkW;
    public GuiRollover rollover;
    public GuiIconButton buttonEditComment;
    public GuiIconButton buttonMoveComment;
    public GuiIconButton buttonRemoveComment;
    private GuiPartChooser chooserEdit;
    private GuiIconButton buttonSimulation;
    private GuiIconButton buttonSimulationStep;
    protected int startX;
    protected int startY;
    protected int endX;
    protected int endY;
    protected boolean drag;
    private static final float SCALE = 16.0f;
    protected GuiCallback<GuiCAD> callbackDelete;
    protected GuiCheckBoxExt checkboxDelete;
    protected GuiCallback<GuiCAD> callbackTimed;
    protected GuiLabel labelTimed;
    protected CircuitPartRenderer.CircuitRenderWrapper timedPart;
    private GuiStateLabel labelPlayState;
    private int callback;
    private static final List<Float> scales = Arrays.asList(Float.valueOf(0.17f), Float.valueOf(0.2f), Float.valueOf(0.25f), Float.valueOf(0.33f), Float.valueOf(0.5f), Float.valueOf(0.67f), Float.valueOf(1.0f), Float.valueOf(1.5f), Float.valueOf(2.0f));

    public GuiCAD(ContainerCAD container) {
        super((Container)container);
        this.handlers.add(this.editHandler);
        this.handlers.add(this.placeHandler);
        this.handlers.add(this.commentHandler);
        this.handlers.add(this.selectionHandler);
        this.setHandler(this.editHandler);
        this.tileentity = container.tileentity;
        this.callbackDelete = new GuiCallback<GuiCAD>(this, 150, 100, GuiCallback.Action.OK, GuiCallback.Action.CANCEL);
        this.checkboxDelete = new GuiCheckBoxExt(1, 7, 78, null, Config.showConfirmMessage.getBoolean(), I18n.func_135052_a((String)"gui.integratedcircuits.cad.callback.show", (Object[])new Object[0]), this.callbackDelete);
        this.callbackDelete.addControl(new GuiLabel(75, 7, I18n.func_135052_a((String)"gui.integratedcircuits.cad.callback.confirm", (Object[])new Object[0]), 0x333333, true)).addControl(new GuiLabel(75, 25, I18n.func_135052_a((String)"gui.integratedcircuits.cad.callback.message", (Object[])new Object[0]), 0, true)).addControl(new GuiLabel(75, 63, I18n.func_135052_a((String)"gui.integratedcircuits.cad.callback.continue", (Object[])new Object[0]), 0x333333, true)).addControl(this.checkboxDelete);
        this.labelTimed = new GuiLabel(80, 9, "", 0, true);
        this.callbackTimed = new GuiCallback<GuiCAD>(this, 160, 50, new GuiCallback.Action[0]).addControl(new GuiButtonExt(1, 5, 25, 36, 20, "-1s")).addControl(new GuiButtonExt(2, 43, 25, 36, 20, "-50ms")).addControl(new GuiButtonExt(3, 81, 25, 36, 20, "+50ms")).addControl(new GuiButtonExt(4, 119, 25, 36, 20, "+1s")).addControl(this.labelTimed);
    }

    public void func_73866_w_() {
        int i;
        Keyboard.enableRepeatEvents((boolean)true);
        NEIAddon.hideGUI(true);
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.calculateSizes();
        this.buttonPlus = new GuiButtonExt(8, this.guiRight - 85, this.guiBottom - 16, 10, 10, "+");
        this.field_146292_n.add(this.buttonPlus);
        this.buttonMinus = new GuiButtonExt(9, this.guiRight - 74, this.guiBottom - 16, 10, 10, "-");
        this.field_146292_n.add(this.buttonMinus);
        this.field_146292_n.add(new GuiButtonExt(10, this.guiRight - 155, this.field_147009_r + 10, 12, 12, "+"));
        this.buttonSize = new GuiButtonExt(11, this.guiRight - 138, this.field_147009_r + 10, 38, 12, "");
        this.field_146292_n.add(this.buttonSize);
        this.nameField = new GuiTextField(this.field_146289_q, this.guiRight - 95, this.field_147009_r + 11, 50, 10);
        this.nameField.func_146180_a(this.getCircuitData().getProperties().getName());
        this.nameField.func_146203_f(7);
        this.nameField.func_146205_d(true);
        this.nameField.func_146195_b(false);
        this.field_146292_n.add(new GuiButtonExt(12, this.guiRight - 38, this.field_147009_r + 6, 10, 10, "I"));
        this.field_146292_n.add(new GuiButtonExt(13, this.guiRight - 38, this.field_147009_r + 17, 10, 10, "O"));
        this.field_147002_h.func_75139_a((int)0).field_75223_e = this.field_146999_f - 25;
        this.field_147002_h.func_75139_a((int)0).field_75221_f = 8;
        this.field_146292_n.add(new GuiButtonExt(84, this.guiRight - 28, this.field_147009_r + 28, 10, 10, "\u21b6"));
        this.field_146292_n.add(new GuiButtonExt(85, this.guiRight - 17, this.field_147009_r + 28, 10, 10, "\u21b7"));
        int yOffsetCentre = GuiCAD.getOffsetCentre(this.editorTop - this.field_147009_r, this.guiBottom - this.editorBottom, this.guiBottom - (this.field_147000_g - this.guiBottom), 170) + 1;
        int xOffsetCentre = GuiCAD.getOffsetCentre(this.editorLeft - this.field_147003_i, this.guiRight - this.editorRight, this.guiRight - (this.field_146999_f - this.guiRight), 170) + 1;
        int topEditorOffset = this.editorTop - 11;
        int leftEditorOffset = this.editorLeft - 11;
        int rightEditorOffset = this.editorRight + 1;
        int bottomEditorOffset = this.editorBottom + 1;
        this.checkN = new GuiIOMode(65, xOffsetCentre, topEditorOffset - 1, this, 0);
        this.checkE = new GuiIOMode(66, rightEditorOffset, yOffsetCentre, this, 1);
        this.checkS = new GuiIOMode(67, xOffsetCentre, bottomEditorOffset, this, 2);
        this.checkW = new GuiIOMode(68, leftEditorOffset - 1, yOffsetCentre, this, 3);
        this.field_146292_n.add(this.checkN);
        this.field_146292_n.add(this.checkE);
        this.field_146292_n.add(this.checkS);
        this.field_146292_n.add(this.checkW);
        xOffsetCentre += 13;
        yOffsetCentre += 13;
        for (i = 0; i < 16; ++i) {
            this.field_146292_n.add(new GuiIO(i + 13, xOffsetCentre + i * 9, topEditorOffset, 15 - i, 0, this, this.tileentity));
        }
        for (i = 0; i < 16; ++i) {
            this.field_146292_n.add(new GuiIO(i + 13 + 16, rightEditorOffset + 2, yOffsetCentre + i * 9, 15 - i, 1, this, this.tileentity));
        }
        for (i = 0; i < 16; ++i) {
            this.field_146292_n.add(new GuiIO(i + 13 + 32, leftEditorOffset, yOffsetCentre + i * 9, i, 3, this, this.tileentity));
        }
        for (i = 0; i < 16; ++i) {
            this.field_146292_n.add(new GuiIO(i + 13 + 48, xOffsetCentre + i * 9, bottomEditorOffset + 2, i, 2, this, this.tileentity));
        }
        int toolsXPosition = this.guiRight - 27;
        int currentPosition = this.field_147009_r + 43;
        for (CircuitPart.Category category : CircuitPart.Category.values()) {
            List<CircuitPart> parts = CircuitPart.getParts(category);
            if (category == CircuitPart.Category.NONE || parts.size() == 0) continue;
            this.field_146292_n.add(new GuiPartChooser(7, toolsXPosition, currentPosition, GuiPartChooser.getRenderWrapperParts(parts), this));
            currentPosition += 21;
        }
        currentPosition = this.guiBottom - 47;
        this.chooserEdit = new GuiPartChooser(7, toolsXPosition, currentPosition, 1, this).setActive(true);
        this.field_146292_n.add(this.chooserEdit);
        this.field_146292_n.add(new GuiPartChooser(7, toolsXPosition, currentPosition += 21, 2, this));
        GuiButton[] guiButtonArray = new GuiButton[3];
        this.buttonEditComment = new GuiIconButton(91, 0, 0, 18, 18, Resources.RESOURCE_GUI_CAD_BACKGROUND).setIcon(16, 0).setToggleable(true, true).setToggled(true).setTooltip(I18n.func_135052_a((String)"gui.integratedcircuits.cad.comment.edit", (Object[])new Object[0]));
        guiButtonArray[0] = this.buttonEditComment;
        this.buttonMoveComment = new GuiIconButton(92, 0, 0, 18, 18, Resources.RESOURCE_GUI_CAD_BACKGROUND).setIcon(32, 0).setToggleable(true, true).setTooltip(I18n.func_135052_a((String)"gui.integratedcircuits.cad.comment.move", (Object[])new Object[0]));
        guiButtonArray[1] = this.buttonMoveComment;
        this.buttonRemoveComment = new GuiIconButton(93, 0, 0, 18, 18, Resources.RESOURCE_GUI_CAD_BACKGROUND).setIcon(48, 0).setToggleable(true, true).setTooltip(I18n.func_135052_a((String)"gui.integratedcircuits.cad.comment.remove", (Object[])new Object[0]));
        guiButtonArray[2] = this.buttonRemoveComment;
        GuiButton[] guiButtonArray2 = new GuiButton[2];
        this.buttonSimulation = new GuiIconButton(98, 0, 0, 18, 18, Resources.RESOURCE_GUI_CAD_BACKGROUND);
        guiButtonArray2[0] = this.buttonSimulation;
        this.buttonSimulationStep = new GuiIconButton(99, 0, 0, 18, 18, Resources.RESOURCE_GUI_CAD_BACKGROUND).setIcon(48, 32).setTooltip(I18n.func_135052_a((String)"gui.integratedcircuits.cad.simulation.step", (Object[])new Object[0]));
        guiButtonArray2[1] = this.buttonSimulationStep;
        this.rollover = new GuiRollover(90, this.field_147003_i + 5, this.field_147009_r + 5, this.field_146295_m - 10, Resources.RESOURCE_GUI_CAD_BACKGROUND).addCategory(100, I18n.func_135052_a((String)"gui.integratedcircuits.cad.comment", (Object[])new Object[0]), 0, 0, guiButtonArray).addCategory(101, I18n.func_135052_a((String)"gui.integratedcircuits.cad.selection", (Object[])new Object[0]), 0, 16, new GuiButton[]{new GuiIconButton(94, 0, 0, 18, 18, Resources.RESOURCE_GUI_CAD_BACKGROUND).setIcon(16, 16).setTooltip(I18n.func_135052_a((String)"gui.integratedcircuits.cad.selection.cut", (Object[])new Object[0])), new GuiIconButton(95, 0, 0, 18, 18, Resources.RESOURCE_GUI_CAD_BACKGROUND).setIcon(32, 16).setTooltip(I18n.func_135052_a((String)"gui.integratedcircuits.cad.selection.copy", (Object[])new Object[0])), new GuiIconButton(96, 0, 0, 18, 18, Resources.RESOURCE_GUI_CAD_BACKGROUND).setIcon(48, 16).setTooltip(I18n.func_135052_a((String)"gui.integratedcircuits.cad.selection.paste", (Object[])new Object[0])), new GuiIconButton(97, 0, 0, 18, 18, Resources.RESOURCE_GUI_CAD_BACKGROUND).setIcon(64, 16).setTooltip(I18n.func_135052_a((String)"gui.integratedcircuits.cad.selection.fill", (Object[])new Object[0]))}).addCategory(102, I18n.func_135052_a((String)"gui.integratedcircuits.cad.simulation", (Object[])new Object[0]), 0, 32, guiButtonArray2).addCategory(103, I18n.func_135052_a((String)"gui.integratedcircuits.cad.print", (Object[])new Object[0]), 0, 48, new GuiButton[0]);
        this.refreshPrinter();
        this.field_146292_n.add(this.rollover);
        this.refreshUI();
    }

    public void refreshPrinter() {
        this.rollover.getCategory((int)103).enabled = this.tileentity.isPrinterConnected();
    }

    protected void func_146284_a(GuiButton button) {
        this.currentHandler.onActionPerformed(this, button);
        if (button.field_146127_k == 8) {
            this.scale(this.tileentity.offX, this.tileentity.offY, 1);
        } else if (button.field_146127_k == 9) {
            this.scale(this.tileentity.offX, this.tileentity.offY, -1);
        } else if (button.field_146127_k == 10) {
            this.callback = 1;
            if (this.checkboxDelete.isChecked()) {
                this.callbackDelete.display();
            } else {
                this.onCallback(this.callbackDelete, GuiCallback.Action.OK, 0);
            }
        } else if (button.field_146127_k == 11) {
            this.callback = 2;
            if (this.checkboxDelete.isChecked()) {
                this.callbackDelete.display();
            } else {
                this.onCallback(this.callbackDelete, GuiCallback.Action.OK, 0);
            }
        } else if (button.field_146127_k == 13) {
            CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBSaveLoad(true, this.tileentity.field_145851_c, this.tileentity.field_145848_d, this.tileentity.field_145849_e));
        } else if (button.field_146127_k == 12) {
            CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBSaveLoad(false, this.tileentity.field_145851_c, this.tileentity.field_145848_d, this.tileentity.field_145849_e));
        } else if (button.field_146127_k == 84) {
            CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBCache(1, this.tileentity.field_145851_c, this.tileentity.field_145848_d, this.tileentity.field_145849_e));
        } else if (button.field_146127_k == 85) {
            CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBCache(2, this.tileentity.field_145851_c, this.tileentity.field_145848_d, this.tileentity.field_145849_e));
        } else if (button.field_146127_k == 90) {
            switch (this.rollover.getSelected()) {
                case 0: {
                    this.setHandler(this.commentHandler);
                    break;
                }
                case 1: {
                    this.setHandler(this.selectionHandler);
                    break;
                }
                default: {
                    if (this.chooserEdit.isActive()) {
                        this.setHandler(this.editHandler);
                        break;
                    }
                    this.setHandler(this.placeHandler);
                    break;
                }
            }
        } else if (button.field_146127_k >= 91 && button.field_146127_k <= 93) {
            switch (button.field_146127_k) {
                case 91: {
                    this.commentHandler.mode = CommentHandler.Mode.EDIT;
                    this.buttonMoveComment.setToggled(false);
                    this.buttonRemoveComment.setToggled(false);
                    break;
                }
                case 92: {
                    this.commentHandler.mode = CommentHandler.Mode.MOVE;
                    this.buttonEditComment.setToggled(false);
                    this.buttonRemoveComment.setToggled(false);
                    break;
                }
                case 93: {
                    this.commentHandler.mode = CommentHandler.Mode.DELETE;
                    this.buttonEditComment.setToggled(false);
                    this.buttonMoveComment.setToggled(false);
                }
            }
        } else if (button.field_146127_k == 98) {
            this.tileentity.setPausing(!this.tileentity.isPausing());
            this.tileentity.sendSimulationState();
        } else if (button.field_146127_k == 99) {
            this.tileentity.step();
            this.tileentity.sendSimulationState();
        } else if (button.field_146127_k == 103) {
            this.tryPrint();
        }
    }

    private void tryPrint() {
        CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBPrint(this.tileentity.field_145851_c, this.tileentity.field_145848_d, this.tileentity.field_145849_e));
    }

    protected double boardAbs2RelX(double absX) {
        return (absX - this.getAbsBoardOffsetX()) / (double)this.getScaleFactor() + (double)this.getBoardSize() / 2.0;
    }

    protected double boardAbs2RelY(double absY) {
        return (absY - this.getAbsBoardOffsetY()) / (double)this.getScaleFactor() + (double)this.getBoardSize() / 2.0;
    }

    protected double boardRel2AbsX(double relX) {
        return (relX - (double)this.getBoardSize() / 2.0) * (double)this.getScaleFactor() + this.getAbsBoardOffsetX();
    }

    protected double boardRel2AbsY(double relY) {
        return (relY - (double)this.getBoardSize() / 2.0) * (double)this.getScaleFactor() + this.getAbsBoardOffsetY();
    }

    protected float getScaleFactor() {
        return 16.0f * this.tileentity.scale;
    }

    public int getBoardSize() {
        return this.tileentity.getCircuitData().getSize();
    }

    private double getAbsBoardSize() {
        return this.getScaleFactor() * (float)this.getBoardSize();
    }

    private double getAbsBoardOffsetX() {
        return (double)this.editorLeft + (double)this.xSizeEditor / 2.0 + this.tileentity.offX;
    }

    private double getAbsBoardOffsetY() {
        return (double)this.editorTop + (double)this.ySizeEditor / 2.0 + this.tileentity.offY;
    }

    private double getBoardLeft() {
        return this.boardRel2AbsX(0.0);
    }

    private double getBoardRight() {
        return this.boardRel2AbsX(this.getBoardSize());
    }

    private double getBoardTop() {
        return this.boardRel2AbsY(0.0);
    }

    private double getBoardBottom() {
        return this.boardRel2AbsY(this.getBoardSize());
    }

    public CircuitData getCircuitData() {
        return this.tileentity.getCircuitData();
    }

    private void calculateSizes() {
        this.field_147009_r = 0;
        this.field_147003_i = 0;
        this.guiRight = this.field_146294_l;
        this.guiBottom = this.field_146295_m;
        this.field_146999_f = this.guiRight - this.field_147003_i;
        this.field_147000_g = this.guiBottom - this.field_147009_r;
        this.editorTop = this.field_147009_r + 44;
        this.editorLeft = this.field_147003_i + 44;
        this.editorBottom = this.guiBottom - 18;
        this.editorRight = this.guiRight - 44;
        this.xSizeEditor = this.editorRight - this.editorLeft;
        this.ySizeEditor = this.editorBottom - this.editorTop;
    }

    private static int getOffsetCentre(int topOffset, int bottomOffset, int fullLength, int thingLength) {
        return (topOffset + fullLength - bottomOffset - thingLength) / 2;
    }

    public void refreshIO() {
        this.checkN.refresh();
        this.checkE.refresh();
        this.checkS.refresh();
        this.checkW.refresh();
    }

    public void refreshUI() {
        int w = this.getBoardSize();
        this.buttonSize.field_146126_j = w + "x" + w;
        this.refreshIO();
        this.nameField.func_146180_a(this.tileentity.getCircuitData().getProperties().getName());
        if (this.tileentity.isPausing()) {
            this.buttonSimulation.setIcon(16, 32);
            this.buttonSimulation.setTooltip(I18n.func_135052_a((String)"gui.integratedcircuits.cad.simulation.play", (Object[])new Object[0]));
            this.buttonSimulationStep.field_146124_l = true;
        } else {
            this.buttonSimulation.setIcon(32, 32);
            this.buttonSimulation.setTooltip(I18n.func_135052_a((String)"gui.integratedcircuits.cad.simulation.pause", (Object[])new Object[0]));
            this.buttonSimulationStep.field_146124_l = false;
        }
    }

    public void setHandler(CADHandler handler) {
        if (this.currentHandler != null && this.currentHandler != handler) {
            this.currentHandler.remove(this);
        }
        this.currentHandler = handler;
        if (this.currentHandler != null) {
            this.currentHandler.apply(this);
        }
    }

    public CADHandler getHandler() {
        return this.currentHandler;
    }

    protected void func_146976_a(float partialTick, int x, int y) {
        this.hoveredElement = null;
        double relX = this.boardAbs2RelX(x);
        double relY = this.boardAbs2RelY(y);
        this.endX = (int)relX;
        this.endY = (int)relY;
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        int guiScale = scaledresolution.func_78325_e();
        GuiCAD.drawHollowRect(this.field_147003_i, this.field_147009_r, this.guiRight, this.guiBottom, this.editorLeft, this.editorTop, this.editorRight, this.editorBottom, -1439023030);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.integratedcircuits.cad.name", (Object[])new Object[0]), this.field_147003_i + 45, this.field_147009_r + 12, 0xFFFFFF);
        this.renderCircuitBoard(x, y, relX, relY, guiScale);
        this.drawGradients(this.editorLeft, this.editorTop, this.editorRight, this.editorBottom, 4);
        this.nameField.func_146194_f();
        this.field_146297_k.field_71446_o.func_110577_a(Resources.RESOURCE_GUI_FLOPPY);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
        GuiCAD.func_146110_a((int)(this.field_146294_l - 25), (int)8, (float)16.0f, (float)16.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        GL11.glDisable((int)3042);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        Vec2 pos;
        CircuitPart part;
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        CircuitData data = this.getCircuitData();
        int gridX = (int)this.boardAbs2RelX(mouseX);
        int gridY = (int)this.boardAbs2RelY(mouseY);
        int w = data.getSize();
        if (!(gridX < 0 || gridY < 0 || gridX >= w || gridY >= w || this.blockMouseInput || GuiCAD.func_146272_n() || mouseX < this.editorLeft || mouseX >= this.editorRight || mouseY < this.editorTop || mouseY >= this.editorBottom || (part = data.getPart(pos = new Vec2(gridX, gridY))) instanceof PartNull || part instanceof PartWire || part instanceof PartNullCell)) {
            ArrayList text = Lists.newArrayList();
            text.add(part.getLocalizedName(pos, this.tileentity));
            text.addAll(part.getInformation(pos, this.tileentity, this.currentHandler == this.editHandler, GuiCAD.func_146271_m()));
            this.drawHoveringText(text, mouseX - this.field_147003_i, mouseY - this.field_147009_r, this.field_146289_q);
        }
        if (this.hoveredElement != null) {
            this.drawHoveringText(this.hoveredElement.getHoverInformation(), mouseX - this.field_147003_i, mouseY - this.field_147009_r, this.field_146289_q);
        }
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        this.field_146289_q.func_78276_b((int)(this.tileentity.scale * 100.0f) + "%", this.field_146999_f - 62, this.field_147000_g - 15, 0xFFFFFF);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawHollowRect(int outerLeft, int outerTop, int outerRight, int outerBottom, int innerLeft, int innerTop, int innerRight, int innerBottom, int colour) {
        GuiCAD.func_73734_a((int)outerLeft, (int)outerTop, (int)innerRight, (int)innerTop, (int)colour);
        GuiCAD.func_73734_a((int)outerLeft, (int)innerTop, (int)innerLeft, (int)outerBottom, (int)colour);
        GuiCAD.func_73734_a((int)innerLeft, (int)innerBottom, (int)outerRight, (int)outerBottom, (int)colour);
        GuiCAD.func_73734_a((int)innerRight, (int)outerTop, (int)outerRight, (int)innerBottom, (int)colour);
    }

    private void drawGradients(int gradientLeft, int gradientTop, int gradientRight, int gradientBottom, int gradientSize) {
        Tessellator tes = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        tes.func_78382_b();
        tes.func_78369_a(0.0f, 0.0f, 0.0f, 0.0f);
        tes.func_78377_a((double)gradientLeft, (double)(gradientTop + gradientSize), 0.0);
        tes.func_78377_a((double)gradientRight, (double)(gradientTop + gradientSize), 0.0);
        tes.func_78369_a(0.0f, 0.0f, 0.0f, 0.8f);
        tes.func_78377_a((double)gradientRight, (double)gradientTop, 0.0);
        tes.func_78377_a((double)gradientLeft, (double)gradientTop, 0.0);
        tes.func_78369_a(0.0f, 0.0f, 0.0f, 0.8f);
        tes.func_78377_a((double)gradientLeft, (double)gradientBottom, 0.0);
        tes.func_78377_a((double)gradientRight, (double)gradientBottom, 0.0);
        tes.func_78369_a(0.0f, 0.0f, 0.0f, 0.0f);
        tes.func_78377_a((double)gradientRight, (double)(gradientBottom - gradientSize), 0.0);
        tes.func_78377_a((double)gradientLeft, (double)(gradientBottom - gradientSize), 0.0);
        tes.func_78369_a(0.0f, 0.0f, 0.0f, 0.8f);
        tes.func_78377_a((double)gradientLeft, (double)gradientTop, 0.0);
        tes.func_78377_a((double)gradientLeft, (double)gradientBottom, 0.0);
        tes.func_78369_a(0.0f, 0.0f, 0.0f, 0.0f);
        tes.func_78377_a((double)(gradientLeft + gradientSize), (double)gradientBottom, 0.0);
        tes.func_78377_a((double)(gradientLeft + gradientSize), (double)gradientTop, 0.0);
        tes.func_78369_a(0.0f, 0.0f, 0.0f, 0.0f);
        tes.func_78377_a((double)(gradientRight - gradientSize), (double)gradientTop, 0.0);
        tes.func_78377_a((double)(gradientRight - gradientSize), (double)gradientBottom, 0.0);
        tes.func_78369_a(0.0f, 0.0f, 0.0f, 0.8f);
        tes.func_78377_a((double)gradientRight, (double)gradientBottom, 0.0);
        tes.func_78377_a((double)gradientRight, (double)gradientTop, 0.0);
        tes.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    private void renderCircuitBoard(int mouseX, int mouseY, double relX, double relY, int guiScale) {
        CircuitData data = this.getCircuitData();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(this.editorLeft * guiScale), (int)(this.field_146297_k.field_71440_d - this.editorBottom * guiScale), (int)(this.xSizeEditor * guiScale), (int)(this.ySizeEditor * guiScale));
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.getAbsBoardOffsetX(), (double)this.getAbsBoardOffsetY(), (double)0.0);
        GL11.glScalef((float)this.getScaleFactor(), (float)this.getScaleFactor(), (float)1.0f);
        GL11.glTranslated((double)((double)(-this.getBoardSize()) / 2.0), (double)((double)(-this.getBoardSize()) / 2.0), (double)0.0);
        CircuitPartRenderer.renderPerfboard(data);
        CircuitPartRenderer.renderParts(this.tileentity);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        if (!GuiCAD.func_146272_n()) {
            this.renderTunnelConnections(data, GuiCAD.func_146271_m());
        }
        this.renderCadCursor(relX, relY, data, data.getSize());
        GL11.glDisable((int)3042);
        for (CADHandler handler : this.handlers) {
            handler.render(this, mouseX, mouseY);
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)3089);
    }

    private void renderTunnelConnections(CircuitData data, boolean ctrl) {
        Tessellator tes = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        tes.func_78382_b();
        for (int x = 0; x < data.getSize(); ++x) {
            for (int y = 0; y < data.getSize(); ++y) {
                if (ctrl || x == this.endX && y == this.endY && data.getPart(new Vec2(x, y)) instanceof PartTunnel && this.currentHandler == this.editHandler) {
                    this.drawTunnelConnection(x, y);
                }
                if (!this.drag || this.currentHandler != this.editHandler) continue;
                tes.func_78369_a(0.0f, 0.0f, 1.0f, 1.0f);
                CircuitPartRenderer.addQuad(this.startX, this.startY, 0.0, 0.0, 1.0, 1.0);
            }
        }
        tes.func_78381_a();
        GL11.glEnable((int)3553);
    }

    private void drawTunnelConnection(int firstX, int firstY) {
        Vec2 pos = new Vec2(firstX, firstY);
        CircuitPart part = this.getCircuitData().getPart(pos);
        if (!(part instanceof PartTunnel)) {
            return;
        }
        PartTunnel pt = (PartTunnel)part;
        Vec2 pos2 = pt.getConnectedPos(pos, this.tileentity);
        if (pt.getInput(pos, this.tileentity) || pt.getProperty(pos, this.tileentity, pt.PROP_IN).booleanValue()) {
            Tessellator.field_78398_a.func_78369_a(1.0f, 0.0f, 0.0f, 1.0f);
        } else {
            Tessellator.field_78398_a.func_78369_a(0.0f, 0.0f, 1.0f, 1.0f);
        }
        if (pt.isConnected(pos2)) {
            double secondX = pos2.x;
            double secondY = pos2.y;
            RenderUtils.addLine((double)firstX + 0.5, (double)firstY + 0.5, secondX + 0.5, secondY + 0.5, 0.25);
            CircuitPartRenderer.addQuad(secondX, secondY, 0.0, 0.0, 1.0, 1.0);
        }
        CircuitPartRenderer.addQuad(firstX, firstY, 0.0, 0.0, 1.0, 1.0);
    }

    private void renderCadCursor(double mouseX, double mouseY, CircuitData cdata, int size) {
        int gridX = (int)mouseX;
        int gridY = (int)mouseY;
        if (gridX > 0 && gridY > 0 && gridX < size - 1 && gridY < size - 1 && !GuiCAD.func_146272_n() && !this.blockMouseInput) {
            this.currentHandler.renderCADCursor(this, mouseX, mouseY, gridX, gridY, cdata);
        }
    }

    public void func_146274_d() {
        int wheelD = Mouse.getEventDWheel();
        if (wheelD != 0 && !this.currentHandler.onMouseWheel(wheelD)) {
            int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int mouseY = this.field_146295_m - 1 - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d;
            if ((double)mouseX >= this.getBoardLeft() && mouseX >= this.editorLeft && (double)mouseX < this.getBoardRight() && mouseX < this.editorRight && (double)mouseY >= this.getBoardTop() && mouseY >= this.editorTop && (double)mouseY < this.getBoardBottom() && mouseY < this.editorBottom) {
                this.scale((double)mouseX - ((double)this.editorLeft + (double)this.xSizeEditor / 2.0), (double)mouseY - ((double)this.editorTop + (double)this.ySizeEditor / 2.0), wheelD);
            } else {
                this.scale(this.tileentity.offX, this.tileentity.offY, wheelD);
            }
        }
        super.func_146274_d();
    }

    protected void func_73864_a(int mouseX, int mouseY, int flag) {
        this.nameField.func_146192_a(mouseX, mouseY, flag);
        if (this.blockMouseInput) {
            super.func_73864_a(mouseX, mouseY, flag);
            return;
        }
        if (mouseX < this.editorLeft || mouseY < this.editorTop || mouseX > this.editorRight || mouseY > this.editorBottom) {
            super.func_73864_a(mouseX, mouseY, flag);
            return;
        }
        this.drag = false;
        this.currentHandler.onMouseDown(this, mouseX, mouseY, flag);
        this.lastX = mouseX;
        this.lastY = mouseY;
        super.func_73864_a(mouseX, mouseY, flag);
    }

    protected void func_146273_a(int mouseX, int mouseY, int button, long timeSinceClick) {
        super.func_146273_a(mouseX, mouseY, button, timeSinceClick);
        if ((mouseX - this.lastX != 0 || mouseY - this.lastY != 0) && mouseX >= this.editorLeft && mouseY >= this.editorTop && mouseX <= this.editorRight && mouseY <= this.editorBottom) {
            if (GuiCAD.func_146272_n()) {
                this.tileentity.offX += (double)(mouseX - this.lastX);
                this.tileentity.offY += (double)(mouseY - this.lastY);
                this.clipOffsets();
            } else {
                this.currentHandler.onMouseDragged(this, mouseX, mouseY);
            }
        }
        this.lastX = mouseX;
        this.lastY = mouseY;
    }

    protected void func_146286_b(int mx, int my, int button) {
        super.func_146286_b(mx, my, button);
        if (this.selectedChooser != null && button == 0) {
            this.selectedChooser.func_146118_a(mx, my);
            this.selectedChooser = null;
        }
        if (button != -1 && !this.blockMouseInput) {
            this.currentHandler.onMouseUp(this, mx, my, button);
        }
        this.drag = false;
    }

    private void scale(double centerX, double centerY, int i) {
        int index = scales.indexOf(Float.valueOf(this.tileentity.scale));
        if (i > 0 && index + 1 < scales.size()) {
            this.scaleAround(centerX, centerY, this.tileentity.scale, scales.get(index + 1).floatValue());
        }
        if (i < 0 && index - 1 >= 0) {
            this.scaleAround(centerX, centerY, this.tileentity.scale, scales.get(index - 1).floatValue());
        }
        this.buttonMinus.field_146124_l = true;
        this.buttonPlus.field_146124_l = true;
        if (this.tileentity.scale == scales.get(0).floatValue()) {
            this.buttonMinus.field_146124_l = false;
        }
        if (this.tileentity.scale == scales.get(scales.size() - 1).floatValue()) {
            this.buttonPlus.field_146124_l = false;
        }
    }

    private void scaleAround(double centerX, double centerY, float from, float to) {
        this.tileentity.scale = to;
        double factor = to / from;
        if (centerX != this.tileentity.offX) {
            this.tileentity.offX = centerX + factor * (this.tileentity.offX - centerX);
        }
        if (centerY != this.tileentity.offY) {
            this.tileentity.offY = centerY + factor * (this.tileentity.offY - centerY);
        }
        this.clipOffsets();
    }

    private void clipOffsets() {
        double innerSize = this.getScaleFactor() * (float)(this.getBoardSize() - 2);
        double limitX = ((double)this.xSizeEditor + innerSize) / 2.0;
        double limitY = ((double)this.ySizeEditor + innerSize) / 2.0;
        this.tileentity.offX = MathHelper.clip((double)this.tileentity.offX, (double)(-limitX), (double)limitX);
        this.tileentity.offY = MathHelper.clip((double)this.tileentity.offY, (double)(-limitY), (double)limitY);
    }

    @Override
    public void onCallback(GuiCallback gui, GuiCallback.Action result, int id) {
        int w = this.getBoardSize();
        if (result == GuiCallback.Action.OK && gui == this.callbackDelete) {
            if (this.callback == 1) {
                CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBClear((byte)w, this.tileentity.field_145851_c, this.tileentity.field_145848_d, this.tileentity.field_145849_e));
            } else {
                w = w == 16 ? 32 : (w == 32 ? 64 : 16);
                CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBClear((byte)w, this.tileentity.field_145851_c, this.tileentity.field_145848_d, this.tileentity.field_145849_e));
            }
        } else if (gui == this.callbackTimed && result == GuiCallback.Action.CUSTOM) {
            IConfigurableDelay conf = (IConfigurableDelay)((Object)this.timedPart.getPart());
            int delay = conf.getConfigurableDelay(this.timedPart.getPos(), this.timedPart);
            switch (id) {
                case 1: {
                    delay -= 20;
                    break;
                }
                case 2: {
                    --delay;
                    break;
                }
                case 3: {
                    ++delay;
                    break;
                }
                case 4: {
                    delay += 20;
                }
            }
            delay = delay < 2 ? 2 : (delay > 255 ? 255 : delay);
            conf.setConfigurableDelay(this.timedPart.getPos(), this.timedPart, delay);
            this.labelTimed.setText(I18n.func_135052_a((String)"gui.integratedcitcuits.cad.callback.delay", (Object[])new Object[]{conf.getConfigurableDelay(this.timedPart.getPos(), this.timedPart)}));
            CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBChangePart(false, this.tileentity.field_145851_c, this.tileentity.field_145848_d, this.tileentity.field_145849_e).add(this.timedPart.getPos(), CircuitPart.getId(this.timedPart.getPart()), this.timedPart.getState()));
        }
    }

    protected void func_73869_a(char par1, int par2) {
        String oname = this.nameField.func_146179_b();
        if (this.nameField.func_146206_l()) {
            this.nameField.func_146201_a(par1, par2);
        } else if (par2 == 44 && GuiCAD.func_146271_m()) {
            CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBCache(1, this.tileentity.field_145851_c, this.tileentity.field_145848_d, this.tileentity.field_145849_e));
        } else if (par2 == 21 && GuiCAD.func_146271_m()) {
            CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBCache(2, this.tileentity.field_145851_c, this.tileentity.field_145848_d, this.tileentity.field_145849_e));
        } else if (!this.currentHandler.onKeyTyped(this, par2, par1)) {
            super.func_73869_a(par1, par2);
        }
        if (!oname.equals(this.nameField.func_146179_b())) {
            CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBChangeName(MiscUtils.thePlayer(), this.nameField.func_146179_b(), this.tileentity.field_145851_c, this.tileentity.field_145848_d, this.tileentity.field_145849_e));
        }
    }

    public List getButtonList() {
        return this.field_146292_n;
    }

    public void func_73876_c() {
        this.nameField.func_146178_a();
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
        Config.showConfirmMessage.set(this.checkboxDelete.isChecked());
        Config.save();
        NEIAddon.hideGUI(false);
    }

    @Override
    public void setCurrentItem(GuiInterfaces.IHoverable hoverable) {
        this.hoveredElement = hoverable;
    }
}

