/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.client.gui.cad;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import moe.nightfall.vic.integratedcircuits.Config;
import moe.nightfall.vic.integratedcircuits.client.gui.cad.CADHandler;
import moe.nightfall.vic.integratedcircuits.client.gui.cad.GuiCAD;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPart;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPartRenderer;
import moe.nightfall.vic.integratedcircuits.cp.part.PartCPGate;
import moe.nightfall.vic.integratedcircuits.cp.part.PartNull;
import moe.nightfall.vic.integratedcircuits.cp.part.PartWire;
import moe.nightfall.vic.integratedcircuits.misc.RenderUtils;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBCache;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBChangePart;
import moe.nightfall.vic.integratedcircuits.proxy.CommonProxy;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class PlaceHandler
extends CADHandler {
    public CircuitPartRenderer.CircuitRenderWrapper selectedPart;
    public int currentRotation = 0;
    private boolean mouseDown = false;

    @Override
    public void renderCADCursor(GuiCAD parent, double mouseX, double mouseY, int gridX, int gridY, CircuitData cdata) {
        if (!parent.drag) {
            if (this.selectedPart.getPart() instanceof PartNull) {
                RenderUtils.applyColorIRGB(Config.colorGreen, 0.4f);
                GL11.glDisable((int)3553);
                Tessellator.field_78398_a.func_78382_b();
                CircuitPartRenderer.addQuad(gridX, gridY, 0.0, 0.0, 1.0, 1.0);
                Tessellator.field_78398_a.func_78381_a();
                GL11.glEnable((int)3553);
            } else if (this.mouseDown) {
                gridX = parent.startX;
                gridY = parent.startY;
            }
            int PART_SIZE = 16;
            GL11.glPushMatrix();
            GL11.glScaled((double)0.0625, (double)0.0625, (double)1.0);
            CircuitPartRenderer.renderPart(this.selectedPart, gridX * 16, gridY * 16);
            GL11.glPopMatrix();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        } else if (this.selectedPart.getPart() instanceof PartWire) {
            PartWire wire = (PartWire)this.selectedPart.getPart();
            switch (wire.getColor(this.selectedPart.getPos(), this.selectedPart)) {
                case 1: {
                    RenderUtils.applyColorIRGBA(Config.colorRed);
                    break;
                }
                case 2: {
                    RenderUtils.applyColorIRGBA(Config.colorOrange);
                    break;
                }
                default: {
                    RenderUtils.applyColorIRGBA(Config.colorGreen);
                }
            }
            this.renderDraggedWire(parent);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public boolean onMouseWheel(int amount) {
        if (this.mouseDown && this.selectedPart.getPart() instanceof PartCPGate) {
            ++this.currentRotation;
            if (this.currentRotation > 3) {
                this.currentRotation = 0;
            }
            ((PartCPGate)this.selectedPart.getPart()).setRotation(this.selectedPart.getPos(), this.selectedPart, this.currentRotation);
            return true;
        }
        return false;
    }

    private void renderDraggedWire(GuiCAD parent) {
        int x = parent.startX;
        int y = parent.startY;
        Tessellator.field_78398_a.func_78382_b();
        CircuitPartRenderer.addQuad(x, y, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 16.0, 16.0, 0.0);
        if (parent.endY > parent.startY) {
            CircuitPartRenderer.addQuad(x, y, 4.0, 0.0, 1.0, 1.0, 1.0, 1.0, 16.0, 16.0, 0.0);
        } else if (parent.endY < parent.startY) {
            CircuitPartRenderer.addQuad(x, y, 2.0, 0.0, 1.0, 1.0, 1.0, 1.0, 16.0, 16.0, 0.0);
        } else if (parent.endX > parent.startX) {
            CircuitPartRenderer.addQuad(x, y, 3.0, 0.0, 1.0, 1.0, 1.0, 1.0, 16.0, 16.0, 0.0);
        } else if (parent.endX < parent.startX) {
            CircuitPartRenderer.addQuad(x, y, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 16.0, 16.0, 0.0);
        }
        while (x != parent.endX || y != parent.endY) {
            if (y < parent.endY) {
                ++y;
            } else if (y > parent.endY) {
                --y;
            } else if (x < parent.endX) {
                ++x;
            } else if (x > parent.endX) {
                --x;
            }
            if (y != parent.endY) {
                CircuitPartRenderer.addQuad(x, y, 6.0, 0.0, 1.0, 1.0, 1.0, 1.0, 16.0, 16.0, 0.0);
                continue;
            }
            if (y == parent.endY && x == parent.startX) {
                CircuitPartRenderer.addQuad(x, y, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 16.0, 16.0, 0.0);
                if (parent.endY > parent.startY) {
                    CircuitPartRenderer.addQuad(x, y, 2.0, 0.0, 1.0, 1.0, 1.0, 1.0, 16.0, 16.0, 0.0);
                } else if (parent.endY < parent.startY) {
                    CircuitPartRenderer.addQuad(x, y, 4.0, 0.0, 1.0, 1.0, 1.0, 1.0, 16.0, 16.0, 0.0);
                }
                if (parent.endX > parent.startX) {
                    CircuitPartRenderer.addQuad(x, y, 3.0, 0.0, 1.0, 1.0, 1.0, 1.0, 16.0, 16.0, 0.0);
                    continue;
                }
                if (parent.endX >= parent.startX) continue;
                CircuitPartRenderer.addQuad(x, y, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 16.0, 16.0, 0.0);
                continue;
            }
            if (x != parent.endX) {
                CircuitPartRenderer.addQuad(x, y, 5.0, 0.0, 1.0, 1.0, 1.0, 1.0, 16.0, 16.0, 0.0);
                continue;
            }
            if (x != parent.endX) continue;
            CircuitPartRenderer.addQuad(x, y, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 16.0, 16.0, 0.0);
            if (parent.endX > parent.startX) {
                CircuitPartRenderer.addQuad(x, y, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 16.0, 16.0, 0.0);
                continue;
            }
            if (parent.endX >= parent.startX) continue;
            CircuitPartRenderer.addQuad(x, y, 3.0, 0.0, 1.0, 1.0, 1.0, 1.0, 16.0, 16.0, 0.0);
        }
        Tessellator.field_78398_a.func_78381_a();
    }

    @Override
    public void onMouseDown(GuiCAD parent, int mx, int my, int button) {
        this.mouseDown = true;
        int gridX = (int)parent.boardAbs2RelX(mx);
        int gridY = (int)parent.boardAbs2RelY(my);
        int w = parent.getBoardSize();
        if (gridX > 0 && gridY > 0 && gridX < w - 1 && gridY < w - 1 && !GuiScreen.func_146272_n()) {
            parent.startX = gridX;
            parent.startY = gridY;
            if (this.selectedPart.getPart() instanceof PartWire) {
                parent.drag = true;
            }
        }
    }

    @Override
    public void onMouseUp(GuiCAD parent, int mx, int my, int button) {
        this.mouseDown = false;
        if (this.selectedPart.getPart() instanceof PartNull) {
            CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBCache(0, parent.tileentity.field_145851_c, parent.tileentity.field_145848_d, parent.tileentity.field_145849_e));
        }
        if (parent.drag) {
            if (this.selectedPart.getPart() instanceof PartWire) {
                int id = CircuitPart.getId(this.selectedPart.getPart());
                int state = this.selectedPart.getState();
                PacketPCBChangePart packet = new PacketPCBChangePart(true, parent.tileentity.field_145851_c, parent.tileentity.field_145848_d, parent.tileentity.field_145849_e);
                packet.add(new Vec2(parent.startX, parent.startY), id, state);
                while (parent.startX != parent.endX || parent.startY != parent.endY) {
                    if (parent.startY < parent.endY) {
                        ++parent.startY;
                    } else if (parent.startY > parent.endY) {
                        --parent.startY;
                    } else if (parent.startX < parent.endX) {
                        ++parent.startX;
                    } else if (parent.startX > parent.endX) {
                        --parent.startX;
                    }
                    packet.add(new Vec2(parent.startX, parent.startY), id, state);
                }
                CommonProxy.networkWrapper.sendToServer((IMessage)packet);
            }
        } else {
            int gridX = (int)parent.boardAbs2RelX(mx);
            int gridY = (int)parent.boardAbs2RelY(my);
            int w = parent.getCircuitData().getSize();
            if (parent.startX == gridX && parent.startY == gridY && parent.startX > 0 && parent.startY > 0 && parent.startX < w - 1 && parent.startY < w - 1 && !GuiScreen.func_146272_n()) {
                int newID = CircuitPart.getId(this.selectedPart.getPart());
                Vec2 pos = new Vec2(parent.startX, parent.startY);
                if (newID != parent.getCircuitData().getID(pos)) {
                    CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBChangePart(!(this.selectedPart.getPart() instanceof PartNull), parent.tileentity.field_145851_c, parent.tileentity.field_145848_d, parent.tileentity.field_145849_e).add(pos, newID, this.selectedPart.getState()));
                }
            }
        }
    }

    @Override
    public void onMouseDragged(GuiCAD parent, int mx, int my) {
        if (this.selectedPart.getPart() instanceof PartNull) {
            int boardX = (int)parent.boardAbs2RelX(mx);
            int boardY = (int)parent.boardAbs2RelY(my);
            int w = parent.getBoardSize();
            boolean shiftDown = Keyboard.isKeyDown((int)42);
            if (boardX > 0 && boardY > 0 && boardX < w - 1 && boardY < w - 1 && !shiftDown) {
                Vec2 pos = new Vec2(boardX, boardY);
                if (!(parent.tileentity.getCircuitData().getPart(pos) instanceof PartNull)) {
                    CommonProxy.networkWrapper.sendToServer((IMessage)new PacketPCBChangePart(false, parent.tileentity.field_145851_c, parent.tileentity.field_145848_d, parent.tileentity.field_145849_e).add(pos, 0, 0));
                }
            }
        }
    }

    @Override
    public void apply(GuiCAD parent) {
        super.apply(parent);
        this.currentRotation = 0;
    }
}

