/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.client.gui.cad;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import moe.nightfall.vic.integratedcircuits.client.gui.cad.CADHandler;
import moe.nightfall.vic.integratedcircuits.client.gui.cad.GuiCAD;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPart;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPartRenderer;
import moe.nightfall.vic.integratedcircuits.misc.RenderUtils;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import moe.nightfall.vic.integratedcircuits.net.pcb.PacketPCBChangePart;
import moe.nightfall.vic.integratedcircuits.proxy.CommonProxy;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;

public class SelectionHandler
extends CADHandler {
    private Vec2 selectionStart = Vec2.zero;
    private Vec2 selectionEnd = Vec2.zero;
    private boolean mouseDown = false;
    private int[][][] data = new int[2][0][0];

    private boolean hasSelection() {
        return this.selectionStart != this.selectionEnd;
    }

    @Override
    public void onActionPerformed(GuiCAD parent, GuiButton button) {
        if (!this.hasSelection()) {
            return;
        }
        switch (button.field_146127_k) {
            case 94: {
                this.cut(parent);
                break;
            }
            case 95: {
                this.copy(parent);
                break;
            }
            case 96: {
                this.paste(parent);
                break;
            }
            case 97: {
                this.fill(parent);
            }
        }
    }

    @Override
    public boolean onKeyTyped(GuiCAD parent, int keycode, char ch) {
        switch (ch) {
            case '\u0003': {
                this.copy(parent);
                break;
            }
            case '\u0018': {
                this.cut(parent);
                break;
            }
            case '\u0016': {
                this.paste(parent);
                break;
            }
            case '\u0006': {
                this.fill(parent);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void copy(GuiCAD parent) {
        Vec2 slStart = this.selectionStart();
        Vec2 slEnd = this.selectionEnd();
        CircuitData cdata = parent.getCircuitData();
        this.data = new int[2][slEnd.x - slStart.x][slEnd.y - slStart.y];
        for (int x = slStart.x; x < slEnd.x; ++x) {
            for (int y = slStart.y; y < slEnd.y; ++y) {
                Vec2 pos = new Vec2(x, y);
                this.data[0][x - slStart.x][y - slStart.y] = cdata.getID(pos);
                this.data[1][x - slStart.x][y - slStart.y] = cdata.getMeta(pos);
            }
        }
    }

    private void cut(GuiCAD parent) {
        this.copy(parent);
        this.fill(parent, 0, 0);
    }

    private void paste(GuiCAD parent) {
        this.fill(parent, 0, 0);
        Vec2 slStart = this.selectionStart();
        CircuitData cdata = parent.getCircuitData();
        PacketPCBChangePart packet = new PacketPCBChangePart(true, parent.tileentity.field_145851_c, parent.tileentity.field_145848_d, parent.tileentity.field_145849_e);
        for (int x = 0; x < this.data[0].length; ++x) {
            for (int y = 0; y < this.data[0][x].length; ++y) {
                Vec2 pos = new Vec2(x + slStart.x, y + slStart.y);
                if (pos.x < 1 || pos.x >= cdata.getSize() - 1 || pos.y < 1 || pos.y >= cdata.getSize() - 1) continue;
                packet.add(pos, this.data[0][x][y], this.data[1][x][y]);
            }
        }
        CommonProxy.networkWrapper.sendToServer((IMessage)packet);
    }

    private void fill(GuiCAD parent) {
        if (parent.placeHandler.selectedPart == null) {
            return;
        }
        CircuitPartRenderer.CircuitRenderWrapper crw = parent.placeHandler.selectedPart;
        this.fill(parent, CircuitPart.getId(crw.getPart()), crw.getState());
    }

    private void fill(GuiCAD parent, int id, int meta) {
        Vec2 slStart = this.selectionStart();
        Vec2 slEnd = this.selectionEnd();
        CircuitData cdata = parent.getCircuitData();
        PacketPCBChangePart packet = new PacketPCBChangePart(true, parent.tileentity.field_145851_c, parent.tileentity.field_145848_d, parent.tileentity.field_145849_e);
        for (int x = slStart.x; x < slEnd.x; ++x) {
            for (int y = slStart.y; y < slEnd.y; ++y) {
                Vec2 pos = new Vec2(x, y);
                packet.add(pos, id, meta);
            }
        }
        CommonProxy.networkWrapper.sendToServer((IMessage)packet);
    }

    private Vec2 selectionStart() {
        return new Vec2(Math.min(this.selectionStart.x, this.selectionEnd.x), Math.min(this.selectionStart.y, this.selectionEnd.y));
    }

    private Vec2 selectionEnd() {
        return new Vec2(Math.max(this.selectionStart.x + 1, this.selectionEnd.x + 1), Math.max(this.selectionStart.y + 1, this.selectionEnd.y + 1));
    }

    @Override
    public void render(GuiCAD parent, int mx, int my) {
        if (!this.isActive()) {
            return;
        }
        if (this.mouseDown) {
            int gridX = (int)Math.floor(parent.boardAbs2RelX(mx));
            int gridY = (int)Math.floor(parent.boardAbs2RelY(my));
            int w = parent.getCircuitData().getSize() - 2;
            if (gridX < 1) {
                gridX = 1;
            } else if (gridX > w) {
                gridX = w;
            }
            if (gridY < 1) {
                gridY = 1;
            } else if (gridY > w) {
                gridY = w;
            }
            this.selectionEnd = new Vec2(gridX, gridY);
        }
        Vec2 slStart = this.selectionStart();
        Vec2 slEnd = this.selectionEnd();
        if (this.hasSelection()) {
            Gui.func_73734_a((int)slStart.x, (int)slStart.y, (int)slEnd.x, (int)slEnd.y, (int)0x550000FF);
            RenderUtils.drawBorder(slStart.x, slStart.y, slEnd.x - slStart.x, slEnd.y - slStart.y);
        }
    }

    @Override
    public void onMouseUp(GuiCAD parent, int mx, int my, int bucutton) {
        this.mouseDown = false;
    }

    @Override
    public void onMouseDown(GuiCAD parent, int mx, int my, int button) {
        if (parent.func_146272_n()) {
            return;
        }
        int gridX = (int)Math.floor(parent.boardAbs2RelX(mx));
        int gridY = (int)Math.floor(parent.boardAbs2RelY(my));
        this.selectionStart = this.selectionEnd = Vec2.zero;
        int w = parent.getCircuitData().getSize() - 1;
        if (gridX > 0 && gridX < w && gridY > 0 && gridY < w) {
            this.selectionStart = new Vec2(gridX, gridY);
            this.mouseDown = true;
        }
    }

    @Override
    public void remove(GuiCAD parent) {
        super.remove(parent);
        this.selectionStart = this.selectionEnd = Vec2.zero;
    }
}

