/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.client.gui.component;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import cpw.mods.fml.client.config.GuiUtils;
import java.util.Arrays;
import java.util.List;
import moe.nightfall.vic.integratedcircuits.client.Resources;
import moe.nightfall.vic.integratedcircuits.client.gui.GuiInterfaces;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.misc.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;

public class GuiDropdown
extends GuiButton
implements GuiInterfaces.IHoverable {
    private ImmutableList<String> elements;
    private ImmutableList<String> tooltips;
    private int selected;
    private int hovered;
    private String hover;
    private boolean toggle;
    private GuiInterfaces.IHoverableHandler parent;
    private static final String TRIANGLE_DOWN = "\u25bc";
    private static final String TRIANGLE_UP = "\u25b2";

    public GuiDropdown(int id, int x, int y, int width, int height, List<String> elements, GuiInterfaces.IHoverableHandler parent) {
        super(id, x, y, width, height, "");
        this.elements = ImmutableList.copyOf(elements);
        this.parent = parent;
    }

    public GuiDropdown setTooltips(List<String> tooltips) {
        this.tooltips = ImmutableList.copyOf(tooltips);
        return this;
    }

    public GuiDropdown setSelected(int selected) {
        this.selected = selected;
        return this;
    }

    public GuiDropdown setEnabled(boolean enabled) {
        this.field_146124_l = enabled;
        this.toggle = false;
        return this;
    }

    public GuiDropdown setHoverInformation(String hover) {
        this.hover = hover;
        return this;
    }

    public boolean isOpen() {
        return this.toggle;
    }

    public int getSelectedElement() {
        return this.selected;
    }

    public ImmutableList<String> getElements() {
        return this.elements;
    }

    public void func_146112_a(Minecraft mc, int x, int y) {
        if (!this.field_146125_m) {
            return;
        }
        FontRenderer fr = mc.field_71466_p;
        if (x >= this.field_146128_h && x < this.field_146128_h + this.field_146120_f && y >= this.field_146129_i && y < this.field_146129_i + this.field_146121_g && this.tooltips != null && !this.toggle && this.field_146124_l) {
            this.parent.setCurrentItem(this);
        }
        GuiDropdown.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)-16777216);
        GuiDropdown.func_73734_a((int)(this.field_146128_h + 1), (int)(this.field_146129_i + 1), (int)(this.field_146128_h + this.field_146120_f - 1), (int)(this.field_146129_i + this.field_146121_g - 1), (int)-11382190);
        int k = this.field_146124_l ? (this.toggle ? 2 : 1) : 0;
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_146122_a, (int)(this.field_146128_h + this.field_146120_f - this.field_146121_g + 1), (int)this.field_146129_i, (int)0, (int)(46 + k * 20), (int)(this.field_146121_g - 1), (int)this.field_146121_g, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
        mc.field_71446_o.func_110577_a(Resources.RESOURCE_GUI_CONTROLS);
        Gui.func_146110_a((int)(this.field_146128_h + this.field_146120_f - this.field_146121_g / 2 - 4), (int)(this.field_146129_i + this.field_146121_g / 2 - 3), (float)(16 - (this.toggle ? 8 : 0)), (float)0.0f, (int)8, (int)7, (float)32.0f, (float)32.0f);
        String current = (String)this.elements.get(this.selected);
        int textWidth = this.field_146120_f - this.field_146121_g - 5;
        current = RenderUtils.cutStringToSize(fr, current, textWidth);
        fr.func_78276_b(current, this.field_146128_h + 3, this.field_146129_i + this.field_146121_g / 2 - fr.field_78288_b / 2 + 1, this.field_146124_l ? 0xFFFFFF : 0x919191);
        if (this.isOpen()) {
            GuiDropdown.func_73734_a((int)(this.field_146128_h + 1), (int)(this.field_146129_i + this.field_146121_g + 1), (int)(this.field_146128_h + this.field_146120_f + 1), (int)(this.field_146129_i + this.field_146121_g + this.elements.size() * this.field_146121_g + 1), (int)-1442840576);
            GuiDropdown.func_73734_a((int)this.field_146128_h, (int)(this.field_146129_i + this.field_146121_g), (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g + this.elements.size() * this.field_146121_g), (int)-16777216);
            GuiDropdown.func_73734_a((int)(this.field_146128_h + 1), (int)(this.field_146129_i + this.field_146121_g), (int)(this.field_146128_h + this.field_146120_f - 1), (int)(this.field_146129_i + this.field_146121_g - 1 + this.elements.size() * this.field_146121_g), (int)-7237231);
            if (x >= this.field_146128_h && y >= this.field_146129_i + this.field_146121_g && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g + this.elements.size() * this.field_146121_g) {
                this.hovered = (y - this.field_146129_i - this.field_146121_g) / this.field_146121_g;
                if (this.hovered != this.selected) {
                    GuiDropdown.func_73734_a((int)(this.field_146128_h + 1), (int)(this.field_146129_i + this.field_146121_g * (this.hovered + 1)), (int)(this.field_146128_h + this.field_146120_f - 1), (int)(this.field_146129_i + this.field_146121_g * (this.hovered + 2) - 1), (int)-10722162);
                }
                this.parent.setCurrentItem(this);
            } else {
                this.hovered = -1;
            }
            for (int i = 0; i < this.elements.size(); ++i) {
                if (i == this.selected) {
                    GuiDropdown.func_73734_a((int)(this.field_146128_h + 1), (int)(this.field_146129_i + this.field_146121_g * (i + 1)), (int)(this.field_146128_h + this.field_146120_f - 1), (int)(this.field_146129_i + this.field_146121_g * (i + 2) - 1), (int)-10722162);
                }
                String element = (String)this.elements.get(i);
                element = RenderUtils.cutStringToSize(fr, element, this.field_146120_f - 5);
                fr.func_78261_a(element, this.field_146128_h + 3, this.field_146129_i + this.field_146121_g + this.field_146121_g * i + this.field_146121_g / 2 - fr.field_78288_b / 2, i == this.selected ? 0xFFFFA0 : 0xFFFFFF);
            }
        }
    }

    public boolean func_146116_c(Minecraft mc, int x, int y) {
        boolean pressed;
        if (!this.field_146125_m) {
            return false;
        }
        if (x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g + this.elements.size() * this.field_146121_g) {
            if (this.toggle && y >= this.field_146129_i + this.field_146121_g) {
                int y2 = (y - this.field_146129_i - this.field_146121_g) / this.field_146121_g;
                if (y2 != this.selected) {
                    this.selected = y2;
                    this.toggle = false;
                    return true;
                }
                this.toggle = false;
            }
        } else {
            this.toggle = false;
        }
        boolean bl = pressed = this.field_146124_l && this.field_146125_m && x >= this.field_146128_h + this.field_146120_f - this.field_146121_g + 1 && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
        if (pressed && this.field_146124_l) {
            this.toggle = !this.toggle;
            this.func_146113_a(Minecraft.func_71410_x().func_147118_V());
        }
        return false;
    }

    @Override
    public List<String> getHoverInformation() {
        String tooltip;
        int active = this.isOpen() ? this.hovered : this.selected;
        List<Object> list = active >= 0 && (tooltip = (String)this.tooltips.get(active)) != null ? Arrays.asList(MiscUtils.stringNewlineSplit(tooltip)) : Lists.newArrayList();
        return list;
    }
}

