/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.client.gui.component;

import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import org.lwjgl.opengl.GL11;

public class GuiLabel
extends Gui {
    private String text;
    private int xCoord;
    private int yCoord;
    private int size = 6;
    private boolean shadow;
    private int color;
    private boolean centered;

    public GuiLabel(int x, int y, String text) {
        this(x, y, text, 0xFFFFFF);
    }

    public GuiLabel(int x, int y, String text, int color) {
        this(x, y, text, color, false);
    }

    public GuiLabel(int x, int y, String text, int color, boolean centered) {
        this.text = text;
        this.color = color;
        this.xCoord = x;
        this.yCoord = y;
        this.centered = centered;
    }

    public void drawLabel(Minecraft mc, int x, int y) {
        float scale = (float)this.size / 6.0f;
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        String[] list = MiscUtils.stringNewlineSplit(this.text);
        for (int i = 0; i < list.length; ++i) {
            int xOff;
            int width = mc.field_71466_p.func_78256_a(list[i]);
            int n = xOff = this.centered ? width / 2 : 0;
            if (this.shadow) {
                mc.field_71466_p.func_78261_a(list[i], this.xCoord - xOff, this.yCoord + i * (this.size + 3), this.color);
                continue;
            }
            mc.field_71466_p.func_78276_b(list[i], this.xCoord - xOff, this.yCoord + i * (this.size + 3), this.color);
        }
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)1.0f);
    }

    public GuiLabel setTextSize(int size) {
        this.size = size;
        return this;
    }

    public GuiLabel setTextShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public GuiLabel setTextColor(int color) {
        this.color = color;
        return this;
    }

    public GuiLabel setCentered(boolean centered) {
        this.centered = centered;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public GuiLabel setText(String text) {
        this.text = text;
        return this;
    }
}

