/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.client.gui.component;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.client.config.GuiUtils;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import moe.nightfall.vic.integratedcircuits.client.gui.GuiInterfaces;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public final class GuiRollover
extends GuiButton
implements GuiInterfaces.IHoverable {
    private static final double timeToOpen = 250.0;
    private static final int boxHeight = 19;
    private ResourceLocation resource;
    private Map<Integer, Category> categoryMap = Maps.newLinkedHashMap();
    private List<Integer> categoryList = Lists.newArrayList();
    private int currentHeight;
    private int nextHeight;
    private int selected = -1;
    private int next = -1;
    private long startTime;
    private int moving = 0;
    private Category hoveredCategory = null;
    private int pSelected = -1;
    private static final Method m_actionPerformed = ReflectionHelper.findMethod(GuiScreen.class, null, (String[])new String[]{"actionPerformed", "func_146284_a"}, (Class[])new Class[]{GuiButton.class});

    public GuiRollover(int id, int x, int y, int height, ResourceLocation resource) {
        super(id, x, y, "");
        this.field_146120_f = 16;
        this.field_146121_g = height;
        this.resource = resource;
    }

    public GuiRollover addCategory(int id, int u, int v, GuiButton ... buttons) {
        return this.addCategory(id, null, u, v, buttons);
    }

    public GuiRollover addCategory(int id, String tooltip, int u, int v, GuiButton ... buttons) {
        Category category = new Category();
        category.id = id;
        category.icon = new Vec2(u, v);
        category.buttonList = new ArrayList<GuiButton>(Arrays.asList(buttons));
        category.tooltip = tooltip;
        this.categoryMap.put(id, category);
        this.categoryList.add(id);
        return this;
    }

    public GuiRollover add(GuiButton button, int category) {
        if (!this.categoryMap.containsKey(category)) {
            throw new RuntimeException();
        }
        List<GuiButton> list = this.getButtons(category);
        list.add(button);
        return this;
    }

    private int calcHeight(int index) {
        List<GuiButton> buttons = this.getButtons(this.categoryList.get(index));
        int height = buttons.size() > 0 ? 10 : 0;
        for (GuiButton button : buttons) {
            height += button.field_146121_g + 1;
        }
        return height;
    }

    private void moveDown(int y) {
        this.moving = 1;
        this.startTime = System.currentTimeMillis();
        this.selected = y;
        this.currentHeight = 0;
        this.nextHeight = this.calcHeight(this.selected);
    }

    private void moveUp() {
        this.moving = -1;
        this.startTime = System.currentTimeMillis();
        this.currentHeight = this.nextHeight;
        this.nextHeight = 0;
    }

    public int getSelected() {
        return this.pSelected;
    }

    public List<GuiButton> getButtons(int category) {
        return this.categoryMap.get((Object)Integer.valueOf((int)category)).buttonList;
    }

    public List<Integer> getCategories() {
        return this.categoryList;
    }

    public Category getCategory(int category) {
        return this.categoryMap.get(category);
    }

    public void func_146112_a(Minecraft mc, int mx, int my) {
        int ypos;
        if (!this.field_146125_m) {
            return;
        }
        GL11.glEnable((int)2929);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)10.0f);
        this.field_146123_n = mx >= this.field_146128_h && my >= this.field_146129_i && mx < this.field_146128_h + this.field_146120_f && my < this.field_146129_i + this.field_146121_g;
        double interpolate = MathHelper.func_151237_a((double)((double)(System.currentTimeMillis() - this.startTime) / 250.0), (double)0.0, (double)1.0);
        int height = (int)(interpolate * (double)(this.nextHeight - this.currentHeight)) + this.currentHeight;
        mc.field_71446_o.func_110577_a(field_146122_a);
        int i = 0;
        for (Category category : this.categoryMap.values()) {
            boolean hovered;
            ypos = this.field_146129_i + i * 19;
            if (i >= this.selected) {
                ypos += height;
            }
            int iconOffset = 66;
            boolean bl = hovered = this.field_146123_n && my > ypos && my < ypos + 19;
            if (hovered && mc.field_71462_r instanceof GuiInterfaces.IHoverableHandler && category.tooltip != null) {
                ((GuiInterfaces.IHoverableHandler)mc.field_71462_r).setCurrentItem(this);
                this.hoveredCategory = category;
            }
            if (!category.enabled) {
                iconOffset = 46;
            } else if (i == this.selected || hovered) {
                iconOffset = 86;
            }
            GuiUtils.drawContinuousTexturedBox((int)this.field_146128_h, (int)ypos, (int)0, (int)iconOffset, (int)18, (int)18, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
            ++i;
        }
        mc.field_71446_o.func_110577_a(this.resource);
        Iterator<Category> iterator = this.categoryMap.values().iterator();
        for (i = 0; i < this.categoryMap.size(); ++i) {
            Category category;
            category = iterator.next();
            ypos = this.field_146129_i + i * 19;
            if (i >= this.selected) {
                ypos += height;
            }
            this.func_73729_b(this.field_146128_h, ypos, category.icon.x, category.icon.y, 16, 16);
        }
        if (this.selected != -1) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-5.0f);
            List<GuiButton> buttons = this.getButtons(this.categoryList.get(this.selected));
            double interpolate2 = interpolate;
            int height2 = (this.moving == -1 ? this.currentHeight : this.nextHeight) - (buttons.size() - this.selected) * 19;
            if (this.moving == -1) {
                interpolate2 = 1.0 - interpolate;
            }
            int buttonOffset = (int)((double)height2 - Math.floor(19.0 * interpolate2));
            for (GuiButton button : buttons) {
                buttonOffset = (int)((double)buttonOffset + (double)(button.field_146121_g + 1) * interpolate2);
                button.field_146129_i = this.field_146129_i + buttonOffset - 5;
                button.field_146128_h = this.field_146128_h + 5;
                button.func_146112_a(Minecraft.func_71410_x(), mx, my);
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-5.0f);
            if (buttons.size() > 0) {
                GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_146122_a, (int)(this.field_146128_h + this.field_146120_f / 2 - 5), (int)(this.field_146129_i + height2 - 8), (int)0, (int)66, (int)12, (int)height, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)10.0f);
        }
        if (interpolate == 1.0) {
            if (this.moving == -1) {
                this.selected = -1;
            }
            if (this.next != -1) {
                this.moveDown(this.next);
                this.next = -1;
            } else {
                this.moving = 0;
            }
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-10.0f);
        GL11.glDisable((int)2929);
    }

    public void func_146118_a(int mx, int my) {
        if (this.selected != -1) {
            for (GuiButton button : this.getButtons(this.categoryList.get(this.selected))) {
                button.func_146118_a(mx, my);
            }
        }
    }

    public void close() {
        this.pSelected = -1;
        this.moveUp();
    }

    public boolean func_146116_c(Minecraft mc, int mx, int my) {
        if (this.selected != -1) {
            for (GuiButton button : this.getButtons(this.categoryList.get(this.selected))) {
                if (!button.func_146116_c(mc, mx, my)) continue;
                try {
                    m_actionPerformed.invoke((Object)mc.field_71462_r, button);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return true;
            }
        }
        if (!this.field_146123_n) {
            return false;
        }
        float fy = (float)(my - this.field_146129_i) / 19.0f;
        if (this.selected != -1 && fy > (float)this.selected) {
            fy = (float)(my - this.field_146129_i - this.nextHeight - this.selected * 19) / 19.0f;
            if ((fy += (float)this.selected) < (float)this.selected) {
                return false;
            }
        }
        if ((double)fy - Math.floor(fy) > 0.8421052694320679) {
            return false;
        }
        int y = (int)fy;
        Category category = null;
        if (y != this.selected && y < this.categoryMap.size()) {
            category = this.getCategory(this.categoryList.get(y));
            if (category.buttonList.size() > 0) {
                this.pSelected = y;
                if (this.selected != -1) {
                    this.next = y;
                    this.moveUp();
                } else {
                    this.moveDown(y);
                }
            }
        } else if (y == this.selected) {
            this.moveUp();
            this.pSelected = -1;
            category = this.getCategory(this.categoryList.get(y));
        }
        if (category != null) {
            try {
                if (category.enabled) {
                    int id = this.field_146127_k;
                    this.field_146127_k = category.id;
                    m_actionPerformed.invoke((Object)mc.field_71462_r, this);
                    this.field_146127_k = id;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public List<String> getHoverInformation() {
        if (this.hoveredCategory != null) {
            return Arrays.asList(MiscUtils.stringNewlineSplit(this.hoveredCategory.tooltip));
        }
        return null;
    }

    public static class Category {
        public List<GuiButton> buttonList;
        public Vec2 icon;
        public String tooltip;
        public boolean enabled = true;
        public int id;
    }
}

