/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.client.gui.component;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.misc.RenderUtils;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import moe.nightfall.vic.integratedcircuits.proxy.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class GuiTextArea
extends Gui {
    private List<StringBuilder> textBuffer = new ArrayList<StringBuilder>();
    private List<Integer> cachedWidth = new ArrayList<Integer>();
    protected Vec2 cursorPosition = Vec2.zero;
    protected Vec2 selectionStart = Vec2.zero;
    protected int xCoord;
    protected int yCoord;
    protected int width;
    protected boolean active = true;
    protected boolean visible = true;
    protected int backgroundColor;
    protected int textColor = -1;
    protected int cursorColor = -1;
    protected int border = 5;
    protected FontRenderer fontRenderer;
    private int clickCount;
    private long lastClickTime;
    private static final int CLICK_TIME = 200;
    private static final Pattern patternWord = Pattern.compile("\\b");
    private static final Pattern patternBlankSpace = Pattern.compile("^\\s*$");
    private static final Pattern patternFirstNonWhitespace = Pattern.compile("[^\\s]|\\s$");

    public GuiTextArea(int xCoord, int yCoord) {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.clickCount = 0;
        this.lastClickTime = Long.MAX_VALUE;
        this.textBuffer.add(new StringBuilder());
        this.cachedWidth.add(0);
        this.xCoord = xCoord;
        this.yCoord = yCoord;
    }

    public Vec2 getSize() {
        return new Vec2(this.width + this.border * 2, this.textBuffer.size() * this.fontRenderer.field_78288_b + this.border * 2);
    }

    public void render(int mx, int my) {
        if (!this.isVisible()) {
            return;
        }
        if (this.backgroundColor != 0) {
            Vec2 size = this.getSize();
            GuiTextArea.func_73734_a((int)this.xCoord, (int)this.yCoord, (int)(this.xCoord + size.x), (int)(this.yCoord + size.y), (int)this.backgroundColor);
        }
        if (this.isActive() && this.hasSelection()) {
            this.renderSelection(-2116232);
        }
        RenderUtils.resetColors(this.fontRenderer, this.isActive() ? this.textColor : -7829368);
        for (int i = 0; i < this.textBuffer.size(); ++i) {
            RenderUtils.drawStringNoReset(this.fontRenderer, this.textBuffer.get(i).toString(), this.xCoord + this.border, this.yCoord + i * this.fontRenderer.field_78288_b + this.border, false);
        }
        if (this.isActive() && this.hasSelection()) {
            GL11.glBlendFunc((int)775, (int)0);
            this.renderSelection(-1);
            GL11.glBlendFunc((int)770, (int)771);
        }
        if (this.isActive() && ClientProxy.clientTicks / 6 % 2 == 0) {
            int cursorX = this.xCoord + this.fontRenderer.func_78256_a(this.getCurrentLine().substring(0, this.cursorPosition.x));
            int cursorY = this.yCoord + this.cursorPosition.y * this.fontRenderer.field_78288_b;
            this.func_73728_b(cursorX + this.border, cursorY - 2 + this.border, cursorY + 10 + this.border, this.cursorColor);
        }
    }

    private void renderSelection(int color) {
        Pair<Vec2, Vec2> selection = this.selection();
        Vec2 first = (Vec2)selection.getLeft();
        Vec2 last = (Vec2)selection.getRight();
        int xCoord = this.xCoord + this.border;
        int yCoord = this.yCoord + this.border;
        if (first.y == last.y) {
            int x1 = this.fontRenderer.func_78256_a(this.getLine(first.y).substring(0, first.x));
            int x2 = this.fontRenderer.func_78256_a(this.getLine(first.y).substring(0, last.x));
            RenderUtils.drawRect(xCoord + x1, yCoord + first.y * this.fontRenderer.field_78288_b, xCoord + x2, yCoord + (first.y + 1) * this.fontRenderer.field_78288_b, color);
        } else {
            int x1 = this.fontRenderer.func_78256_a(this.getLine(first.y).substring(0, first.x));
            int x2 = this.cachedWidth.get(first.y);
            RenderUtils.drawRect(xCoord + x1, yCoord + first.y * this.fontRenderer.field_78288_b, xCoord + x2, yCoord + (first.y + 1) * this.fontRenderer.field_78288_b, color);
            for (int i = 0; i < last.y - first.y - 1; ++i) {
                x2 = this.cachedWidth.get(first.y + i + 1);
                RenderUtils.drawRect(xCoord, yCoord + (first.y + i + 1) * this.fontRenderer.field_78288_b, xCoord + x2, yCoord + (first.y + i + 2) * this.fontRenderer.field_78288_b, color);
            }
            x2 = this.fontRenderer.func_78256_a(this.getLine(last.y).substring(0, last.x));
            RenderUtils.drawRect(xCoord, yCoord + last.y * this.fontRenderer.field_78288_b, xCoord + x2, yCoord + (last.y + 1) * this.fontRenderer.field_78288_b, color);
        }
    }

    public void onMouseDown(int mx, int my, int button) {
        if (!this.isVisible() || button != 0) {
            return;
        }
        Vec2 intersection = this.intersect(mx, my);
        if (intersection == null) {
            this.setActive(false);
            return;
        }
        long time = System.currentTimeMillis();
        if (time - this.lastClickTime > 200L) {
            this.clickCount = 0;
        }
        this.lastClickTime = time;
        this.setActive(true);
        if (this.clickCount == 0) {
            this.setCursorPositionInternal(intersection);
        } else if (this.clickCount == 1) {
            this.selectWord(intersection);
        } else if (this.clickCount == 2) {
            this.selectLine(intersection);
            this.clickCount = 0;
        }
        ++this.clickCount;
    }

    private void selectWord(Vec2 intersection) {
        StringBuilder line = this.getLine(intersection.y);
        Matcher forward = patternWord.matcher(line);
        Matcher backward = patternWord.matcher(new StringBuilder(line).reverse());
        int next = forward.find(intersection.x) ? forward.start() : this.getLineLength(intersection.y);
        int prev = backward.find(line.length() - intersection.x) ? line.length() - backward.start() : 0;
        this.selectionStart = new Vec2(prev, intersection.y);
        this.cursorPosition = new Vec2(next, intersection.y);
    }

    private void selectLine(Vec2 intersection) {
        this.selectionStart = new Vec2(0, intersection.y);
        this.cursorPosition = intersection.y + 1 >= this.textBuffer.size() ? new Vec2(this.getLineLength(intersection.y), intersection.y) : new Vec2(0, intersection.y + 1);
    }

    public void onMouseDragged(int mx, int my) {
        if (!this.isVisible() || !this.isActive()) {
            return;
        }
        Vec2 intersection = this.intersect(mx, my);
        if (intersection != null) {
            this.cursorPosition = intersection;
        }
    }

    public void onKeyTyped(int key, char ch) {
        if (!this.isVisible() || !this.isActive()) {
            return;
        }
        switch (key) {
            case 211: {
                this.delete();
                return;
            }
            case 200: {
                this.up();
                return;
            }
            case 208: {
                this.down();
                return;
            }
            case 203: {
                this.left();
                return;
            }
            case 205: {
                this.right();
                return;
            }
        }
        switch (ch) {
            case '\u0001': {
                this.selectAll();
                return;
            }
            case '\u0003': {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                return;
            }
            case '\u0016': {
                this.replace(GuiScreen.func_146277_j());
                return;
            }
            case '\u0018': {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                this.deleteSelected();
                return;
            }
            case '\b': {
                this.backspace();
                return;
            }
            case '\u001b': {
                this.setActive(false);
                return;
            }
            case '\r': {
                this.carriageReturn();
                return;
            }
            case '\t': {
                this.tab();
                return;
            }
        }
        if (!Character.isISOControl(ch)) {
            this.replace(String.valueOf(ch));
        }
    }

    public void selectAll() {
        this.selectionStart = Vec2.zero;
        this.cursorPosition = this.getLastPosition();
    }

    private void backspace() {
        if (this.hasSelection()) {
            this.deleteSelected();
            return;
        }
        if (this.cursorPosition.equals(Vec2.zero)) {
            return;
        }
        if (this.cursorPosition.x == 0) {
            StringBuilder line = this.getCurrentLine();
            this.removeFromCache(this.cursorPosition.y);
            Vec2 newCursorPosition = new Vec2(this.getLineLength(this.cursorPosition.y - 1), this.cursorPosition.y - 1);
            this.getLine(this.cursorPosition.y - 1).append((CharSequence)line);
            this.refreshLine(this.cursorPosition.y - 1);
            this.setCursorPositionInternal(newCursorPosition);
            this.refreshWidth();
        } else {
            this.getCurrentLine().deleteCharAt(this.cursorPosition.x - 1);
            this.refreshLine(this.cursorPosition.y);
            this.setCursorPositionInternal(new Vec2(this.cursorPosition.x - 1, this.cursorPosition.y));
            this.refreshWidth();
        }
    }

    private void delete() {
        if (this.hasSelection()) {
            this.deleteSelected();
            return;
        }
        if (this.cursorPosition.equals(this.getLastPosition())) {
            return;
        }
        if (this.cursorPosition.x >= this.getLineLength(this.cursorPosition.y)) {
            StringBuilder line = this.getLine(this.cursorPosition.y + 1);
            this.removeFromCache(this.cursorPosition.y + 1);
            this.getLine(this.cursorPosition.y).append((CharSequence)line);
            this.refreshLine(this.cursorPosition.y);
        } else {
            this.getCurrentLine().deleteCharAt(this.cursorPosition.x);
            this.refreshLine(this.cursorPosition.y);
            this.refreshWidth();
        }
    }

    private void carriageReturn() {
        this.deleteSelected();
        StringBuilder sb = new StringBuilder();
        String currentLine = this.getCurrentLine().toString();
        if (currentLine.length() > 0) {
            int size = currentLine.length();
            for (int i = 0; i < size && currentLine.charAt(i) == ' '; ++i) {
                sb.insert(0, ' ');
            }
        }
        this.addToCache(this.cursorPosition.y + 1, sb);
        Vec2 newCursorPosition = new Vec2(this.getLineLength(this.cursorPosition.y + 1), this.cursorPosition.y + 1);
        sb.append(currentLine.substring(this.cursorPosition.x, currentLine.length()));
        this.getCurrentLine().delete(this.cursorPosition.x, currentLine.length());
        this.refreshLine(this.cursorPosition.y);
        this.refreshLine(this.cursorPosition.y + 1);
        this.refreshWidth();
        this.setCursorPositionInternal(newCursorPosition);
    }

    private void tab() {
        if (GuiScreen.func_146272_n()) {
            if (this.cursorPosition.y == this.selectionStart.y) {
                this.clearSelection();
                if (patternBlankSpace.matcher(this.getCurrentLine().toString().substring(0, this.cursorPosition.x)).matches()) {
                    Matcher matcher = patternFirstNonWhitespace.matcher(this.getCurrentLine());
                    if (matcher.find()) {
                        this.setCursorPositionInternal(new Vec2(matcher.start(), this.cursorPosition.y));
                    }
                    if (this.cursorPosition.x == 1) {
                        this.getCurrentLine().deleteCharAt(this.cursorPosition.x - 1);
                        this.setCursorPositionInternal(new Vec2(this.cursorPosition.x - 1, this.cursorPosition.y));
                    } else if (this.cursorPosition.x > 0) {
                        this.getCurrentLine().delete(this.cursorPosition.x - 2, this.cursorPosition.x);
                        this.setCursorPositionInternal(new Vec2(this.cursorPosition.x - 2, this.cursorPosition.y));
                    }
                    this.refreshLine(this.cursorPosition.y);
                } else {
                    this.setCursorPositionInternal(new Vec2(Math.max(this.cursorPosition.x - 2 + this.cursorPosition.x % 2, 0), this.cursorPosition.y));
                }
            } else {
                Pair<Vec2, Vec2> selection = this.selection();
                for (int i = ((Vec2)selection.getLeft()).y; i <= ((Vec2)this.selection().getRight()).y; ++i) {
                    String line = this.getLine(i).toString();
                    if (line.startsWith("  ")) {
                        this.getLine(i).delete(0, 2);
                        this.refreshLine(i);
                        continue;
                    }
                    if (!line.startsWith(" ")) continue;
                    this.getLine(i).deleteCharAt(0);
                    this.refreshLine(i);
                }
                this.tab_adjustSelection(selection);
            }
        } else if (this.cursorPosition.y == this.selectionStart.y) {
            Matcher matcher;
            if (this.cursorPosition.x % 2 == 0) {
                this.replace("  ");
            } else {
                this.replace(" ");
            }
            if (patternBlankSpace.matcher(this.getCurrentLine().toString().substring(0, this.cursorPosition.x)).matches() && (matcher = patternFirstNonWhitespace.matcher(this.getCurrentLine())).find()) {
                this.setCursorPositionInternal(new Vec2(matcher.start(), this.cursorPosition.y));
            }
        } else {
            Pair<Vec2, Vec2> selection = this.selection();
            for (int i = ((Vec2)selection.getLeft()).y; i <= ((Vec2)this.selection().getRight()).y; ++i) {
                this.getLine(i).insert(0, "  ");
                this.refreshLine(i);
            }
            this.tab_adjustSelection(selection);
        }
        this.refreshWidth();
    }

    private void tab_adjustSelection(Pair<Vec2, Vec2> selection) {
        boolean flip = this.cursorPosition == selection.getLeft();
        this.selectionStart = new Vec2(0, ((Vec2)selection.getLeft()).y);
        this.cursorPosition = new Vec2(this.getLineLength(((Vec2)selection.getRight()).y), ((Vec2)selection.getRight()).y);
        if (flip) {
            Vec2 temp = this.selectionStart;
            this.selectionStart = this.cursorPosition;
            this.cursorPosition = temp;
        }
    }

    private void up() {
        if (this.cursorPosition.y == 0) {
            return;
        }
        int x = this.fontRenderer.func_78256_a(this.getCurrentLine().substring(0, this.cursorPosition.x));
        x = this.fontRenderer.func_78269_a(this.getLine(this.cursorPosition.y - 1).toString(), x).length();
        this.setCursorPositionInternal(new Vec2(x, this.cursorPosition.y - 1));
    }

    private void down() {
        if (this.cursorPosition.y >= this.textBuffer.size() - 1) {
            return;
        }
        int x = this.fontRenderer.func_78256_a(this.getCurrentLine().substring(0, this.cursorPosition.x));
        x = this.fontRenderer.func_78269_a(this.getLine(this.cursorPosition.y + 1).toString(), x).length();
        this.setCursorPositionInternal(new Vec2(x, this.cursorPosition.y + 1));
    }

    private void left() {
        if (this.cursorPosition.equals(Vec2.zero)) {
            return;
        }
        if (this.cursorPosition.x == 0) {
            this.setCursorPositionInternal(new Vec2(this.getLineLength(this.cursorPosition.y - 1), this.cursorPosition.y - 1));
        } else {
            this.setCursorPositionInternal(new Vec2(this.cursorPosition.x - 1, this.cursorPosition.y));
        }
    }

    private void right() {
        if (this.cursorPosition.equals(this.getLastPosition())) {
            return;
        }
        if (this.cursorPosition.x >= this.getLineLength(this.cursorPosition.y)) {
            this.setCursorPositionInternal(new Vec2(0, this.cursorPosition.y + 1));
        } else {
            this.setCursorPositionInternal(new Vec2(this.cursorPosition.x + 1, this.cursorPosition.y));
        }
    }

    private Vec2 intersect(int mx, int my) {
        mx -= this.border;
        int y = ((my -= this.border) - this.xCoord) / this.fontRenderer.field_78288_b;
        if (y < 0 || y >= this.textBuffer.size()) {
            return null;
        }
        int x = mx - this.xCoord;
        if (x < -this.border) {
            return null;
        }
        if (x > this.width + this.border * 2) {
            return null;
        }
        String s = this.fontRenderer.func_78269_a(this.textBuffer.get(y).toString(), mx - this.xCoord);
        x = s.length();
        return new Vec2(x, y);
    }

    protected StringBuilder getLine(int line) {
        return this.textBuffer.get(line);
    }

    protected StringBuilder getCurrentLine() {
        return this.getLine(this.cursorPosition.y);
    }

    protected void refreshLine(int line) {
        this.cachedWidth.set(line, this.fontRenderer.func_78256_a(this.textBuffer.get(line).toString()));
    }

    protected void refreshWidth() {
        this.width = 0;
        for (int w : this.cachedWidth) {
            if (w <= this.width) continue;
            this.width = w;
        }
    }

    protected void addToCache(int line, StringBuilder sb) {
        this.textBuffer.add(line, sb);
        this.cachedWidth.add(line, 0);
        this.refreshLine(line);
        this.refreshWidth();
    }

    protected void addToCache(StringBuilder sb) {
        this.textBuffer.add(sb);
        this.cachedWidth.add(0);
        this.refreshLine(this.textBuffer.size() - 1);
        this.refreshWidth();
    }

    protected void removeFromCache(int line) {
        this.textBuffer.remove(line);
        this.cachedWidth.remove(line);
        this.refreshWidth();
    }

    public int getLineLength(int line) {
        return this.textBuffer.get(line).length();
    }

    public Vec2 getLastPosition() {
        return new Vec2(this.textBuffer.get(this.textBuffer.size() - 1).length(), this.textBuffer.size() - 1);
    }

    public Vec2 getSelectionStart() {
        return this.selectionStart;
    }

    public Vec2 getCursorPosition() {
        return this.cursorPosition;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public GuiTextArea setActive(boolean active) {
        this.active = active;
        return this;
    }

    public GuiTextArea setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public GuiTextArea setPosition(int x, int y) {
        this.xCoord = x;
        this.yCoord = y;
        return this;
    }

    public GuiTextArea setBackgroundColor(int color) {
        this.backgroundColor = color;
        return this;
    }

    public GuiTextArea setTextColor(int color) {
        this.textColor = color;
        return this;
    }

    public GuiTextArea setCursorColor(int color) {
        this.cursorColor = color;
        return this;
    }

    protected Pair<Vec2, Vec2> selection() {
        Vec2 last;
        Vec2 first;
        if (this.selectionStart.y < this.cursorPosition.y || this.selectionStart.y == this.cursorPosition.y && this.selectionStart.x < this.cursorPosition.x) {
            first = this.selectionStart;
            last = this.cursorPosition;
        } else {
            first = this.cursorPosition;
            last = this.selectionStart;
        }
        return new ImmutablePair((Object)first, (Object)last);
    }

    public String getSelectedText() {
        if (!this.hasSelection()) {
            return "";
        }
        Pair<Vec2, Vec2> selection = this.selection();
        Vec2 first = (Vec2)selection.getLeft();
        Vec2 last = (Vec2)selection.getRight();
        List<StringBuilder> selectedLines = this.textBuffer.subList(first.y, last.y + 1);
        if (selectedLines.size() == 1) {
            return selectedLines.get(0).substring(first.x, last.x);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(selectedLines.get(0).substring(first.x)).append("\r\n");
        for (int i = 1; i < selectedLines.size() - 1; ++i) {
            sb.append((CharSequence)selectedLines.get(i)).append("\r\n");
        }
        sb.append(selectedLines.get(selectedLines.size() - 1).substring(0, last.x));
        return sb.toString();
    }

    public boolean hasSelection() {
        return !this.selectionStart.equals(this.cursorPosition);
    }

    public void clearSelection() {
        this.selectionStart = (Vec2)this.selection().getLeft();
    }

    public void deleteSelected() {
        if (!this.hasSelection()) {
            return;
        }
        Pair<Vec2, Vec2> selection = this.selection();
        Vec2 first = (Vec2)selection.getLeft();
        Vec2 last = (Vec2)selection.getRight();
        StringBuilder firstLine = this.textBuffer.get(first.y);
        if (first.y == last.y) {
            firstLine.delete(first.x, last.x);
        } else {
            firstLine.delete(first.x, this.getLineLength(first.y));
        }
        this.refreshLine(first.y);
        this.setCursorPositionInternal(first);
        if (first.y == last.y) {
            this.refreshWidth();
            return;
        }
        int numLines = last.y - first.y;
        StringBuilder lastLine = this.getLine(first.y + numLines);
        if (last.x < lastLine.length() - 1) {
            firstLine.append(lastLine.substring(last.x, lastLine.length()));
            this.refreshLine(first.y);
        }
        for (int i = 0; i < numLines; ++i) {
            this.removeFromCache(first.y + 1);
        }
    }

    public void append(String text) {
        this.insert(text, this.getLastPosition());
    }

    public void insert(String text) {
        this.insert(text, this.cursorPosition, true);
    }

    public void insert(String text, Vec2 pos) {
        this.insert(text, this.cursorPosition, false);
    }

    protected void insert(String text, Vec2 pos, boolean advanceCursor) {
        this.clearSelection();
        if (text == null) {
            throw new NullPointerException();
        }
        this.checkInside(pos);
        String[] toInsert = MiscUtils.stringNewlineSplit(text.replaceAll("\t", "  "));
        StringBuilder insertLine = this.getLine(pos.y);
        String endOfLine = insertLine.substring(pos.x, insertLine.length());
        insertLine.delete(pos.x, insertLine.length());
        insertLine.append(toInsert[0]);
        if (toInsert.length > 1) {
            if (toInsert.length > 2) {
                for (int i = 1; i < toInsert.length - 1; ++i) {
                    this.addToCache(new StringBuilder(toInsert[i]));
                }
            }
            this.addToCache(new StringBuilder(toInsert[toInsert.length - 1]).append(endOfLine));
            if (advanceCursor) {
                int newCursorY = this.cursorPosition.y + toInsert.length - 1;
                this.setCursorPositionInternal(new Vec2(Math.min(toInsert[toInsert.length - 1].length(), this.getLineLength(newCursorY)), newCursorY));
            }
        } else {
            if (advanceCursor) {
                this.setCursorPositionInternal(new Vec2(Math.min(this.cursorPosition.x + toInsert[0].length(), this.getLineLength(this.cursorPosition.y)), this.cursorPosition.y));
            }
            insertLine.append(endOfLine);
        }
        this.refreshLine(pos.y);
        this.refreshWidth();
    }

    public void replace(String text) {
        this.deleteSelected();
        this.insert(text);
    }

    public void setCursorPosition(Vec2 position) {
        if (position.x < 0 || position.y < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (position.y > this.textBuffer.size()) {
            position = this.getLastPosition();
        } else if (position.x > this.getLineLength(position.y)) {
            position = new Vec2(this.getLineLength(position.y), position.y);
        }
        this.setCursorPositionInternal(position);
    }

    protected void setCursorPositionInternal(Vec2 position) {
        this.cursorPosition = position;
        this.selectionStart = position;
    }

    public GuiTextArea setText(String text) {
        this.setCursorPositionInternal(Vec2.zero);
        this.textBuffer.clear();
        this.cachedWidth.clear();
        this.addToCache(new StringBuilder());
        this.append(text);
        this.setCursorPositionInternal(this.getLastPosition());
        return this;
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.textBuffer.size(); ++i) {
            sb.append((CharSequence)this.textBuffer.get(i));
            if (i == this.textBuffer.size() - 1) continue;
            sb.append("\r\n");
        }
        return sb.toString();
    }

    protected void checkInside(Vec2 pos) {
        if (pos.x < 0 || pos.y < 0 || pos.y >= this.textBuffer.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (pos.x > this.getLineLength(pos.y)) {
            throw new IndexOutOfBoundsException();
        }
    }
}

