/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.compat;

import com.bluepowermod.api.BPApi;
import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.connect.IConnectionCache;
import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocket;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BPDevice
implements IBundledDevice,
IRedstoneDevice {
    private final ISocket socket;
    private final IConnectionCache<IBundledDevice> cacheBundled;
    private final IConnectionCache<IRedstoneDevice> cacheSimple;

    public BPDevice(ISocket socket) {
        this.socket = socket;
        this.cacheBundled = BPApi.getInstance().getRedstoneApi().createBundledConnectionCache((IBundledDevice)this);
        this.cacheSimple = BPApi.getInstance().getRedstoneApi().createRedstoneConnectionCache((IRedstoneDevice)this);
    }

    public int getX() {
        return this.socket.getPos().x;
    }

    public int getY() {
        return this.socket.getPos().y;
    }

    public int getZ() {
        return this.socket.getPos().z;
    }

    public World getWorld() {
        return this.socket.getWorld();
    }

    public boolean canConnect(ForgeDirection side, IBundledDevice dev, ConnectionType type) {
        return this.socket.getConnectionTypeAtSide(this.socket.getSideRel(side.ordinal())).isBundled();
    }

    public IConnectionCache<? extends IBundledDevice> getBundledConnectionCache() {
        return this.cacheBundled;
    }

    public byte[] getBundledOutput(ForgeDirection side) {
        return this.socket.getOutput()[this.socket.getSideRel(side.ordinal())];
    }

    public void setBundledPower(ForgeDirection side, byte[] power) {
        this.socket.updateInputPre();
        this.socket.getInput()[this.socket.getSideRel((int)side.ordinal())] = power;
    }

    public byte[] getBundledPower(ForgeDirection side) {
        return this.socket.getInput()[this.socket.getSideRel(side.ordinal())];
    }

    public void onBundledUpdate() {
        this.socket.updateInputPost();
    }

    public MinecraftColor getBundledColor(ForgeDirection side) {
        return MinecraftColor.ANY;
    }

    public boolean isNormalFace(ForgeDirection side) {
        return true;
    }

    public boolean canConnect(ForgeDirection side, IRedstoneDevice dev, ConnectionType type) {
        return this.socket.getConnectionTypeAtSide(this.socket.getSideRel(side.ordinal())).isRedstone();
    }

    public IConnectionCache<? extends IRedstoneDevice> getRedstoneConnectionCache() {
        return this.cacheSimple;
    }

    public byte getRedstonePower(ForgeDirection side) {
        byte out = this.socket.getRedstoneOutput(this.socket.getSideRel(side.ordinal()));
        return (byte)(17 * out);
    }

    public void setRedstonePower(ForgeDirection side, byte power) {
        this.socket.updateInputPre();
        power = (byte)((power & 0xFF) / 17);
        this.socket.setInput(this.socket.getSideRel(side.ordinal()), 0, power);
    }

    public void onRedstoneUpdate() {
        this.socket.updateInputPost();
    }
}

