/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.compat;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaFMPAccessor;
import mcp.mobius.waila.api.IWailaFMPProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocket;
import moe.nightfall.vic.integratedcircuits.cp.CircuitProperties;
import moe.nightfall.vic.integratedcircuits.gate.GateCircuit;
import moe.nightfall.vic.integratedcircuits.tile.BlockSocket;
import moe.nightfall.vic.integratedcircuits.tile.TileEntitySocket;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class WailaAddon
implements IWailaDataProvider,
IWailaFMPProvider {
    public static void registerAddon(IWailaRegistrar register) {
        WailaAddon instance = new WailaAddon();
        register.registerStackProvider((IWailaDataProvider)instance, BlockSocket.class);
        register.registerBodyProvider((IWailaDataProvider)instance, BlockSocket.class);
        register.registerBodyProvider((IWailaFMPProvider)instance, "integratedcircuits.socket_fmp");
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        MovingObjectPosition pos = accessor.getPosition();
        ItemStack stack = accessor.getBlock().getPickBlock(pos, accessor.getWorld(), pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, accessor.getPlayer());
        return stack != null ? stack : accessor.getStack();
    }

    private List<String> getCircuitInformation(ItemStack circuit, List<String> currenttip) {
        NBTTagCompound circuitTag = circuit.func_77978_p().func_74775_l("circuit");
        NBTTagCompound properties = circuitTag.func_74775_l("properties");
        currenttip.add(EnumChatFormatting.GOLD + "Name: " + EnumChatFormatting.RESET + properties.func_74779_i("name"));
        currenttip.add(EnumChatFormatting.GOLD + "Author: " + EnumChatFormatting.RESET + properties.func_74779_i("author"));
        int size = circuitTag.func_74762_e("size");
        currenttip.add(EnumChatFormatting.GOLD + "Size: " + EnumChatFormatting.RESET + size + "x" + size);
        int con = properties.func_74762_e("con");
        String io = "";
        for (int side = 0; side < 4; ++side) {
            ISocket.EnumConnectionType mode = CircuitProperties.getModeAtSide(con, side);
            io = io + mode.singleCharID() + (side < 3 ? "-" : "");
        }
        currenttip.add(EnumChatFormatting.GOLD + "IO: " + EnumChatFormatting.RESET + io);
        return currenttip;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntitySocket te = (TileEntitySocket)accessor.getTileEntity();
        if (te.getSocket().getGate() instanceof GateCircuit) {
            return this.getCircuitInformation(itemStack, currenttip);
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return tag;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaFMPAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaFMPAccessor accessor, IWailaConfigHandler config) {
        if (itemStack.func_77978_p() != null) {
            return this.getCircuitInformation(itemStack, currenttip);
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaFMPAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }
}

