/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.compat.buildcraft;

import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeWire;
import buildcraft.api.transport.pluggable.IPipePluggableDynamicRenderer;
import buildcraft.api.transport.pluggable.IPipePluggableRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import moe.nightfall.vic.integratedcircuits.api.IntegratedCircuitsAPI;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocket;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocketWrapper;
import moe.nightfall.vic.integratedcircuits.compat.buildcraft.BCGateRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GatePipePluggable
extends PipePluggable
implements ISocketWrapper {
    private ISocket socket = IntegratedCircuitsAPI.getGateRegistry().createSocketInstance(this);
    private IPipeTile pipe;
    private BlockCoord pos;
    private World world;
    private int scheduledTick = -1;
    private AxisAlignedBB boundingBox;

    public GatePipePluggable() {
        System.out.println("Creating new instance");
    }

    public GatePipePluggable(ItemStack stack, BlockCoord pos, World world, ForgeDirection dir) {
        this.pos = pos;
        this.world = world;
        this.socket.setGate(stack, null);
        this.socket.setSide(dir.ordinal());
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.socket.readFromNBT(tag);
    }

    public void writeToNBT(NBTTagCompound tag) {
        this.socket.writeToNBT(tag);
    }

    public void readData(ByteBuf data) {
        this.socket.readDesc(ByteBufUtils.readTag((ByteBuf)data));
    }

    public void writeData(ByteBuf data) {
        NBTTagCompound compound = new NBTTagCompound();
        this.socket.writeDesc(compound);
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)compound);
    }

    public void update(IPipeTile pipe, ForgeDirection direction) {
        if (this.pipe == null) {
            this.pipe = pipe;
            this.world = pipe.getWorld();
            this.pos = new BlockCoord(pipe.x(), pipe.y(), pipe.z());
            this.socket.setSide(direction.ordinal());
        }
        this.socket.update();
        if (this.scheduledTick > -1) {
            --this.scheduledTick;
            if (this.scheduledTick <= -1) {
                this.socket.scheduledTick();
                this.scheduledTick = -1;
            }
        }
        this.updateInput();
    }

    public ItemStack[] getDropItems(IPipeTile pipe) {
        ArrayList list = Lists.newArrayList();
        this.socket.addDrops(list);
        return list.toArray(new ItemStack[list.size()]);
    }

    public boolean isBlocking(IPipeTile pipe, ForgeDirection direction) {
        return true;
    }

    public AxisAlignedBB getBoundingBox(ForgeDirection side) {
        if (this.boundingBox == null) {
            this.boundingBox = this.socket.getGate().getDimension().copy().apply((Transformation)new Scale(0.0625).with((Transformation)new Translation(0.0, 0.85, 0.0)).with(new Scale(0.75).at(Vector3.center)).with(Rotation.sideOrientation((int)side.getOpposite().ordinal(), (int)this.socket.getRotation()).at(Vector3.center))).toAABB();
        }
        return this.boundingBox;
    }

    public IPipePluggableRenderer getRenderer() {
        return BCGateRenderer.instance;
    }

    public IPipePluggableDynamicRenderer getDynamicRenderer() {
        return BCGateRenderer.instance;
    }

    @Override
    public void markRender() {
        if (this.pipe == null) {
            return;
        }
        this.pipe.scheduleRenderUpdate();
    }

    @Override
    public MCDataOutput getWriteStream(int disc) {
        return IntegratedCircuitsAPI.getWriteStream(this.getWorld(), this.getPos(), this.socket.getSide());
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public void notifyBlocksAndChanges() {
    }

    @Override
    public void notifyPartChange() {
        byte[][] output = this.socket.getOutput();
    }

    @Override
    public BlockCoord getPos() {
        return this.pos;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void updateInput() {
        this.socket.updateInput();
    }

    @Override
    public int updateRedstoneInput(int side) {
        return this.getInput(side, PipeWire.RED);
    }

    private int getInput(int side, PipeWire wire) {
        if (this.pipe == null) {
            return 0;
        }
        return this.pipe.getPipe().isWireActive(wire) ? 15 : 0;
    }

    @Override
    public byte[] updateBundledInput(int side) {
        return new byte[16];
    }

    @Override
    public void scheduleTick(int delay) {
        this.scheduledTick = delay;
    }

    @Override
    public void sendDescription() {
        BlockCoord pos = this.getPos();
        this.getWorld().func_147471_g(pos.x, pos.y, pos.z);
    }

    @Override
    public ISocket getSocket() {
        return this.socket;
    }
}

