/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.compat.gateio;

import moe.nightfall.vic.integratedcircuits.api.IntegratedCircuitsAPI;
import moe.nightfall.vic.integratedcircuits.api.gate.IGateRegistry;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocket;
import moe.nightfall.vic.integratedcircuits.compat.gateio.GPBluePower;
import moe.nightfall.vic.integratedcircuits.compat.gateio.GPComputerCraft;
import moe.nightfall.vic.integratedcircuits.compat.gateio.GPMinefactoryReloaded;
import moe.nightfall.vic.integratedcircuits.compat.gateio.GPOpenComputers;
import moe.nightfall.vic.integratedcircuits.compat.gateio.GPProjectRedFMP;
import moe.nightfall.vic.integratedcircuits.compat.gateio.GPProjectRedTile;
import moe.nightfall.vic.integratedcircuits.compat.gateio.GPRedLogic;

public final class GateIO {
    public static final int[] vanillaSideMap = new int[]{1, 2, 5, 3, 4};

    private GateIO() {
    }

    public static void initialize() {
        IGateRegistry registry = IntegratedCircuitsAPI.getGateRegistry();
        registry.registerGateIOProvider(new GPProjectRedTile(), IntegratedCircuitsAPI.Type.TILE);
        registry.registerGateIOProvider(new GPProjectRedFMP(), IntegratedCircuitsAPI.Type.TILE_FMP);
        registry.registerGateIOProvider(new GPBluePower(), IntegratedCircuitsAPI.Type.TILE, IntegratedCircuitsAPI.Type.TILE_FMP);
        registry.registerGateIOProvider(new GPRedLogic(), IntegratedCircuitsAPI.Type.TILE);
        registry.registerGateIOProvider(new GPOpenComputers(), IntegratedCircuitsAPI.Type.TILE);
        registry.registerGateIOProvider(new GPMinefactoryReloaded(), IntegratedCircuitsAPI.Type.BLOCK);
        registry.registerGateIOProvider(new GPComputerCraft(), IntegratedCircuitsAPI.Type.BLOCK);
    }

    public static byte[] getBundledSignal(ISocket socket, int dir) {
        if ((dir & 6) == (socket.getSide() & 6)) {
            return null;
        }
        int rot = socket.getSideRel(dir);
        if (!socket.getConnectionTypeAtSide(rot).isBundled()) {
            return null;
        }
        return socket.getOutput()[rot];
    }

    public static int vanillaToSide(int vside) {
        return vanillaSideMap[vside + 1];
    }
}

