/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import moe.nightfall.vic.integratedcircuits.Config;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.ICircuitDataProvider;

public class CircuitCache {
    private HashMap<UUID, CircuitCacheEntry> cache = Maps.newHashMap();
    private ICircuitDataProvider provider;

    public CircuitCache(ICircuitDataProvider provider) {
        this.provider = provider;
    }

    public void capture(UUID user) {
        this.create(user);
        this.cache.get(user).capture(this.provider.getCircuitData());
    }

    public void undo(UUID user) throws ArrayIndexOutOfBoundsException {
        this.create(user);
        CircuitCacheEntry entry = this.cache.get(user);
        entry.undo();
        this.provider.setCircuitData(entry.current());
    }

    public void redo(UUID user) throws ArrayIndexOutOfBoundsException {
        this.create(user);
        CircuitCacheEntry entry = this.cache.get(user);
        entry.redo();
        this.provider.setCircuitData(entry.current());
    }

    public CircuitData getCurrent(UUID user) {
        if (!this.cache.containsKey(user)) {
            return null;
        }
        return this.cache.get(user).current();
    }

    public void create(UUID user) {
        if (!this.cache.containsKey(user)) {
            CircuitCacheEntry entry = new CircuitCacheEntry();
            entry.capture(this.provider.getCircuitData());
            this.cache.put(user, entry);
        }
    }

    public static class CircuitCacheEntry {
        private int position = 0;
        private ArrayList<CircuitData> cache = Lists.newArrayList();

        public void capture(CircuitData data) {
            if (this.position > 0 && this.cache.size() > 0) {
                this.cache.subList(this.cache.size() - this.position, this.cache.size()).clear();
                this.position = 0;
            }
            if (this.cache.size() >= Config.circuitCacheSize) {
                this.cache.remove(0);
            }
            this.cache.add(data.clone());
        }

        public void undo() throws ArrayIndexOutOfBoundsException {
            if (this.position == this.cache.size() - 1) {
                throw new ArrayIndexOutOfBoundsException();
            }
            ++this.position;
        }

        public void redo() throws ArrayIndexOutOfBoundsException {
            if (this.position == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            --this.position;
        }

        public CircuitData current() {
            return this.cache.get(this.cache.size() - this.position - 1).clone();
        }
    }
}

