/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp;

import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import moe.nightfall.vic.integratedcircuits.Config;
import moe.nightfall.vic.integratedcircuits.IntegratedCircuits;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocket;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPart;
import moe.nightfall.vic.integratedcircuits.cp.CircuitProperties;
import moe.nightfall.vic.integratedcircuits.cp.ICircuit;
import moe.nightfall.vic.integratedcircuits.cp.legacy.LegacyLoader;
import moe.nightfall.vic.integratedcircuits.cp.part.PartIOBit;
import moe.nightfall.vic.integratedcircuits.cp.part.PartNull;
import moe.nightfall.vic.integratedcircuits.misc.CraftingAmount;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;

public class CircuitData
implements Cloneable {
    public static final int version = 1;
    private int size;
    private int[][] meta;
    private int[][] id;
    private HashSet<Vec2> tickSchedule = new LinkedHashSet<Vec2>();
    private HashSet<Vec2> updateQueue = new LinkedHashSet<Vec2>();
    private HashSet<Vec2> inputQueue = new LinkedHashSet<Vec2>();
    private boolean hasChanged;
    private CraftingAmount cost;
    private int amount = -1;
    private ICircuit parent;
    private boolean queueEnabled = true;
    private CircuitProperties prop = new CircuitProperties();

    private CircuitData() {
    }

    public CircuitData(int size, ICircuit parent) {
        this.parent = parent;
        this.size = size;
    }

    private CircuitData(int size, ICircuit parent, int[][] id, int[][] meta, LinkedHashSet<Vec2> tickSchedule, CircuitProperties prop) {
        this(size, parent, id, meta, tickSchedule, new LinkedHashSet<Vec2>(), prop);
    }

    private CircuitData(int size, ICircuit parent, int[][] id, int[][] meta, LinkedHashSet<Vec2> tickSchedule, LinkedHashSet<Vec2> inputQueue, CircuitProperties prop) {
        this.parent = parent;
        this.prop = prop;
        this.size = size;
        this.id = id;
        this.meta = meta;
        this.tickSchedule = tickSchedule;
        this.inputQueue = inputQueue;
        this.hasChanged = !this.isEmpty();
    }

    protected CircuitData clone() {
        int i;
        CircuitData clone = new CircuitData();
        clone.size = this.size;
        clone.id = new int[this.size][this.size];
        clone.meta = new int[this.size][this.size];
        clone.amount = this.amount;
        clone.queueEnabled = this.queueEnabled;
        clone.cost = this.cost;
        clone.parent = this.parent;
        clone.prop = this.prop;
        clone.hasChanged = this.hasChanged;
        for (i = 0; i < this.size; ++i) {
            clone.id[i] = (int[])this.id[i].clone();
        }
        for (i = 0; i < this.size; ++i) {
            clone.meta[i] = (int[])this.meta[i].clone();
        }
        for (Vec2 vec : this.tickSchedule) {
            clone.tickSchedule.add(vec);
        }
        for (Vec2 vec : this.updateQueue) {
            clone.tickSchedule.add(vec);
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CircuitData)) {
            return false;
        }
        CircuitData cdata = (CircuitData)obj;
        if (cdata.size != this.size) {
            return false;
        }
        if (cdata.parent != this.parent) {
            return false;
        }
        for (int x = 0; x < this.size; ++x) {
            for (int y = 0; y < this.size; ++y) {
                if (cdata.meta[x][y] != this.meta[x][y]) {
                    return false;
                }
                if (cdata.id[x][y] == this.id[x][y]) continue;
                return false;
            }
        }
        return true;
    }

    private ISocket.EnumConnectionType[] getAndFixModePerSide() {
        ISocket.EnumConnectionType[] modes = new ISocket.EnumConnectionType[4];
        int maxIOSize = this.maximumIOSize();
        for (int side = 0; side < 4; ++side) {
            ISocket.EnumConnectionType mode = this.prop.getModeAtSide(side);
            if (mode.size > maxIOSize) {
                mode = ISocket.EnumConnectionType.getSupportedList(maxIOSize).get(0);
            }
            this.prop.setCon(this.prop.setModeAtSide(side, mode));
            modes[side] = mode;
        }
        return modes;
    }

    public void clearAllAndSetup(int size) {
        this.clearAll(size);
        this.setupIO();
    }

    public void clearIOAndSetupIO() {
        this.clearIO();
        this.setupIO();
    }

    public void setupIO() {
        this.getAndFixModePerSide();
        int o = this.supportsBundled() ? this.size / 2 - 8 : 1;
        int cid = CircuitPart.getId(PartIOBit.class);
        for (int i = 0; i < (this.supportsBundled() ? 16 : 1); ++i) {
            Vec2 pos1 = new Vec2(this.size - 1 - (i + o), 0);
            Vec2 pos2 = new Vec2(this.size - 1, this.size - 1 - (i + o));
            Vec2 pos3 = new Vec2(i + o, this.size - 1);
            Vec2 pos4 = new Vec2(0, i + o);
            if (this.prop.getModeAtSide(0) != ISocket.EnumConnectionType.NONE && (this.prop.getModeAtSide(0) != ISocket.EnumConnectionType.SIMPLE || i < 1)) {
                this.setID(pos1, cid);
                PartIOBit io1 = (PartIOBit)this.getPart(pos1);
                io1.setFrequency(pos1, this.parent, i);
                io1.setRotation(pos1, this.parent, 0);
            }
            if (this.prop.getModeAtSide(1) != ISocket.EnumConnectionType.NONE && (this.prop.getModeAtSide(1) != ISocket.EnumConnectionType.SIMPLE || i < 1)) {
                this.setID(pos2, cid);
                PartIOBit io2 = (PartIOBit)this.getPart(pos2);
                io2.setFrequency(pos2, this.parent, i);
                io2.setRotation(pos2, this.parent, 1);
            }
            if (this.prop.getModeAtSide(2) != ISocket.EnumConnectionType.NONE && (this.prop.getModeAtSide(2) != ISocket.EnumConnectionType.SIMPLE || i < 1)) {
                this.setID(pos3, cid);
                PartIOBit io3 = (PartIOBit)this.getPart(pos3);
                io3.setFrequency(pos3, this.parent, i);
                io3.setRotation(pos3, this.parent, 2);
            }
            if (this.prop.getModeAtSide(3) == ISocket.EnumConnectionType.NONE || this.prop.getModeAtSide(3) == ISocket.EnumConnectionType.SIMPLE && i >= 1) continue;
            this.setID(pos4, cid);
            PartIOBit io4 = (PartIOBit)this.getPart(pos4);
            io4.setFrequency(pos4, this.parent, i);
            io4.setRotation(pos4, this.parent, 3);
        }
    }

    public void clearAll(int size) {
        this.clearContents(size);
        this.getProperties().clearComments();
    }

    public void clearCell(int x, int y) {
        this.id[x][y] = 0;
        this.meta[x][y] = 0;
    }

    public void clearRow(int y) {
        for (int x = 0; x < this.size; ++x) {
            this.clearCell(x, y);
        }
    }

    public void clearColumn(int x) {
        for (int y = 0; y < this.size; ++y) {
            this.clearCell(x, y);
        }
    }

    public void clearIO() {
        this.clearRow(0);
        this.clearRow(this.size - 1);
        this.clearColumn(0);
        this.clearColumn(this.size - 1);
    }

    public void clearContents(int size) {
        this.id = new int[size][size];
        this.meta = new int[size][size];
        this.tickSchedule.clear();
        this.updateQueue.clear();
        this.size = size;
        this.setChanged(false);
    }

    public void updateInput() {
        int o = this.supportsBundled() ? this.size / 2 - 8 : 1;
        for (int i = 0; i < (this.supportsBundled() ? 16 : 1); ++i) {
            Vec2 pos1 = new Vec2(this.size - 1 - (i + o), 0);
            Vec2 pos2 = new Vec2(this.size - 1, this.size - 1 - (i + o));
            Vec2 pos3 = new Vec2(i + o, this.size - 1);
            Vec2 pos4 = new Vec2(0, i + o);
            CircuitPart part1 = this.getPart(pos1);
            CircuitPart part2 = this.getPart(pos2);
            CircuitPart part3 = this.getPart(pos3);
            CircuitPart part4 = this.getPart(pos4);
            if (part1 instanceof PartIOBit) {
                part1.notifyNeighbours(pos1, this.parent);
            }
            if (part2 instanceof PartIOBit) {
                part2.notifyNeighbours(pos2, this.parent);
            }
            if (part3 instanceof PartIOBit) {
                part3.notifyNeighbours(pos3, this.parent);
            }
            if (!(part4 instanceof PartIOBit)) continue;
            part4.notifyNeighbours(pos4, this.parent);
        }
        this.propagateSignals();
    }

    public void updateOutput() {
        int o = this.supportsBundled() ? this.size / 2 - 8 : 1;
        for (int i = 0; i < (this.supportsBundled() ? 16 : 1); ++i) {
            Vec2 pos1 = new Vec2(this.size - 1 - (i + o), 0);
            Vec2 pos2 = new Vec2(this.size - 1, this.size - 1 - (i + o));
            Vec2 pos3 = new Vec2(i + o, this.size - 1);
            Vec2 pos4 = new Vec2(0, i + o);
            CircuitPart part1 = this.getPart(pos1);
            CircuitPart part2 = this.getPart(pos2);
            CircuitPart part3 = this.getPart(pos3);
            CircuitPart part4 = this.getPart(pos4);
            if (part1 instanceof PartIOBit) {
                ((PartIOBit)part1).updateExternalOutput(pos1, this.parent);
            }
            if (part2 instanceof PartIOBit) {
                ((PartIOBit)part2).updateExternalOutput(pos2, this.parent);
            }
            if (part3 instanceof PartIOBit) {
                ((PartIOBit)part3).updateExternalOutput(pos3, this.parent);
            }
            if (!(part4 instanceof PartIOBit)) continue;
            ((PartIOBit)part4).updateExternalOutput(pos4, this.parent);
        }
    }

    public CircuitProperties getProperties() {
        return this.prop;
    }

    public boolean supportsBundled() {
        return this.maximumIOSize() == 16;
    }

    public int maximumIOSize() {
        if (this.size - 2 >= 16) {
            return 16;
        }
        if (this.size - 2 >= 1) {
            return 1;
        }
        return 0;
    }

    public int getMeta(Vec2 pos) {
        if (pos.x < 0 || pos.y < 0 || pos.x >= this.size || pos.y >= this.size) {
            return 0;
        }
        return this.meta[pos.x][pos.y];
    }

    public void setMeta(Vec2 pos, int m) {
        if (pos.x < 0 || pos.y < 0 || pos.x >= this.size || pos.y >= this.size) {
            return;
        }
        if (m != this.meta[pos.x][pos.y]) {
            this.setChanged(true);
        }
        this.meta[pos.x][pos.y] = m;
    }

    public int getID(Vec2 pos) {
        if (pos.x < 0 || pos.y < 0 || pos.x >= this.size || pos.y >= this.size) {
            return 0;
        }
        return this.id[pos.x][pos.y];
    }

    public void setID(Vec2 pos, int id) {
        if (pos.x < 0 || pos.y < 0 || pos.x >= this.size || pos.y >= this.size) {
            return;
        }
        if (id != this.id[pos.x][pos.y]) {
            this.setChanged(true);
        }
        this.id[pos.x][pos.y] = id;
    }

    public ICircuit getCircuit() {
        return this.parent;
    }

    public void setParent(ICircuit parent) {
        this.parent = parent;
    }

    public int getSize() {
        return this.size;
    }

    public CircuitPart getPart(Vec2 pos) {
        if (pos.x < 0 || pos.y < 0 || pos.x >= this.size || pos.y >= this.size) {
            return CircuitPart.getPart(PartNull.class);
        }
        CircuitPart part = CircuitPart.getPart(this.id[pos.x][pos.y]);
        if (part == null) {
            IntegratedCircuits.logger.warn("Removed circuit part! " + pos);
            this.setID(pos, 0);
            this.setMeta(pos, 0);
            part = this.getPart(pos);
        }
        return part;
    }

    public void scheduleTick(Vec2 pos) {
        this.tickSchedule.add(pos);
    }

    public void scheduleInputChange(Vec2 pos) {
        this.inputQueue.add(pos);
    }

    public void markForUpdate(Vec2 pos) {
        if (!this.queueEnabled) {
            return;
        }
        this.updateQueue.add(pos);
    }

    public synchronized void propagateSignals() {
        while (this.inputQueue.size() > 0) {
            HashSet tmp = (HashSet)this.inputQueue.clone();
            this.inputQueue.clear();
            for (Vec2 pos : tmp) {
                CircuitPart part = this.getPart(pos);
                part.updateInput(pos, this.parent);
                part.onInputChange(pos, this.parent);
            }
        }
    }

    public synchronized void updateMatrix() {
        if (!this.inputQueue.isEmpty()) {
            this.propagateSignals();
        }
        HashSet tmp = (HashSet)this.tickSchedule.clone();
        this.tickSchedule.clear();
        for (Vec2 pos : tmp) {
            this.getPart(pos).onScheduledTick(pos, this.parent);
        }
        this.propagateSignals();
    }

    public static CircuitData readFromNBT(NBTTagCompound compound) {
        return CircuitData.readFromNBT(compound, null);
    }

    public static CircuitData readFromNBT(NBTTagCompound compound, ICircuit parent) {
        boolean legacyLoad;
        int version = compound.func_74762_e("version");
        List<LegacyLoader> legacyLoaders = null;
        boolean bl = legacyLoad = version < 1 && Config.enableLegacyLoader;
        if (legacyLoad) {
            legacyLoaders = LegacyLoader.getLegacyLoaders(version);
            for (LegacyLoader loader : legacyLoaders) {
                loader.transformNBT(compound);
            }
        }
        NBTTagList idlist = compound.func_150295_c("id", 11);
        int[][] id = new int[idlist.func_74745_c()][];
        for (int i = 0; i < idlist.func_74745_c(); ++i) {
            id[i] = idlist.func_150306_c(i);
        }
        NBTTagList metalist = compound.func_150295_c("meta", 11);
        int[][] meta = new int[metalist.func_74745_c()][];
        for (int i = 0; i < metalist.func_74745_c(); ++i) {
            meta[i] = metalist.func_150306_c(i);
        }
        CircuitProperties prop = CircuitProperties.readFromNBT(compound.func_74775_l("properties"));
        int size = compound.func_74762_e("size");
        if (legacyLoad) {
            for (LegacyLoader loader : legacyLoaders) {
                loader.transform(size, id, meta);
            }
        }
        LinkedHashSet<Vec2> scheduledTicks = new LinkedHashSet<Vec2>();
        int[] scheduledList = compound.func_74759_k("scheduled");
        for (int i = 0; i < scheduledList.length; i += 2) {
            scheduledTicks.add(new Vec2(scheduledList[i], scheduledList[i + 1]));
        }
        LinkedHashSet<Vec2> inputQueue = new LinkedHashSet<Vec2>();
        if (compound.func_74764_b("inputQueue")) {
            int[] inputList = compound.func_74759_k("inputQueue");
            for (int i = 0; i < inputList.length; i += 2) {
                inputQueue.add(new Vec2(inputList[i], inputList[i + 1]));
            }
        }
        CircuitData cdata = new CircuitData(size, parent, id, meta, scheduledTicks, inputQueue, prop);
        if (legacyLoad) {
            for (LegacyLoader loader : legacyLoaders) {
                loader.postTransform(cdata);
            }
        }
        return cdata;
    }

    public NBTTagCompound writeToNBTRaw(NBTTagCompound compound) {
        return this.writeToNBT(compound, true);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        return this.writeToNBT(compound, false);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound, boolean pcb) {
        NBTTagList idlist = new NBTTagList();
        for (int i = 0; i < this.size; ++i) {
            int[] id = new int[this.size];
            for (int j = 0; j < this.size; ++j) {
                id[j] = this.id[i][j];
            }
            idlist.func_74742_a((NBTBase)new NBTTagIntArray(id));
        }
        NBTTagList metalist = new NBTTagList();
        for (int i = 0; i < this.size; ++i) {
            metalist.func_74742_a((NBTBase)new NBTTagIntArray((int[])this.meta[i].clone()));
        }
        compound.func_74768_a("size", this.size);
        compound.func_74782_a("id", (NBTBase)idlist);
        compound.func_74782_a("meta", (NBTBase)metalist);
        compound.func_74782_a("properties", (NBTBase)this.prop.writeToNBT(new NBTTagCompound(), pcb));
        LinkedList<Integer> tmp = new LinkedList<Integer>();
        for (Vec2 v : this.tickSchedule) {
            tmp.add(v.x);
            tmp.add(v.y);
        }
        compound.func_74783_a("scheduled", Ints.toArray(tmp));
        if (!this.inputQueue.isEmpty()) {
            tmp = new LinkedList();
            for (Vec2 v : this.inputQueue) {
                tmp.add(v.x);
                tmp.add(v.y);
            }
            compound.func_74783_a("inputQueue", Ints.toArray(tmp));
        }
        compound.func_74768_a("version", 1);
        return compound;
    }

    public void writeToStream(ByteBuf buf) {
        buf.writeInt(this.updateQueue.size());
        for (Vec2 v : this.updateQueue) {
            buf.writeByte(v.x);
            buf.writeByte(v.y);
            buf.writeByte(this.id[v.x][v.y]);
            buf.writeInt(this.meta[v.x][v.y]);
        }
        this.updateQueue.clear();
    }

    public void readFromStream(ByteBuf buf) {
        try {
            int length = buf.readInt();
            for (int i = 0; i < length; ++i) {
                byte x = buf.readByte();
                byte y = buf.readByte();
                byte cid = buf.readByte();
                int data = buf.readInt();
                this.setID(new Vec2(x, y), cid);
                this.meta[x][y] = data;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean checkUpdate() {
        return this.updateQueue.size() > 0;
    }

    public void setQueueEnabled(boolean enabled) {
        this.queueEnabled = enabled;
    }

    public static CircuitData createShallowInstance(int state, ICircuit parent) {
        CircuitData data = new CircuitData();
        data.size = 3;
        data.id = new int[3][3];
        data.id[1][0] = 1;
        data.id[0][1] = 1;
        data.id[2][1] = 1;
        data.id[1][2] = 1;
        data.meta = new int[][]{{0, 0, 0}, {0, state, 0}, {0, 0, 0}};
        data.parent = parent;
        return data;
    }

    public CraftingAmount getCost() {
        if (this.cost == null) {
            this.calculateCost();
        }
        return this.cost;
    }

    public int getPartAmount() {
        if (this.amount == -1) {
            this.calculateCost();
        }
        return this.amount;
    }

    public void calculateCost() {
        this.cost = new CraftingAmount();
        this.amount = 0;
        for (int x = 1; x < this.size - 1; ++x) {
            for (int y = 1; y < this.size - 1; ++y) {
                Vec2 pos = new Vec2(x, y);
                CircuitPart part = this.getPart(pos);
                if (part instanceof PartNull) continue;
                part.getCraftingCost(this.cost, this, pos);
                ++this.amount;
            }
        }
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
    }

    public boolean isEmpty() {
        for (int x = 1; x < this.size - 1; ++x) {
            for (int y = 1; y < this.size - 1; ++y) {
                if (this.id[x][y] == 0) continue;
                return false;
            }
        }
        return true;
    }
}

