/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import moe.nightfall.vic.integratedcircuits.Config;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPartRenderer;
import moe.nightfall.vic.integratedcircuits.cp.ICircuit;
import moe.nightfall.vic.integratedcircuits.cp.part.PartIOBit;
import moe.nightfall.vic.integratedcircuits.cp.part.PartMultiplexer;
import moe.nightfall.vic.integratedcircuits.cp.part.PartNull;
import moe.nightfall.vic.integratedcircuits.cp.part.PartTorch;
import moe.nightfall.vic.integratedcircuits.cp.part.PartTunnel;
import moe.nightfall.vic.integratedcircuits.cp.part.PartWire;
import moe.nightfall.vic.integratedcircuits.cp.part.cell.PartANDCell;
import moe.nightfall.vic.integratedcircuits.cp.part.cell.PartBufferCell;
import moe.nightfall.vic.integratedcircuits.cp.part.cell.PartInvertCell;
import moe.nightfall.vic.integratedcircuits.cp.part.cell.PartNullCell;
import moe.nightfall.vic.integratedcircuits.cp.part.latch.PartRSLatch;
import moe.nightfall.vic.integratedcircuits.cp.part.latch.PartToggleLatch;
import moe.nightfall.vic.integratedcircuits.cp.part.latch.PartTransparentLatch;
import moe.nightfall.vic.integratedcircuits.cp.part.logic.PartANDGate;
import moe.nightfall.vic.integratedcircuits.cp.part.logic.PartBufferGate;
import moe.nightfall.vic.integratedcircuits.cp.part.logic.PartNANDGate;
import moe.nightfall.vic.integratedcircuits.cp.part.logic.PartNORGate;
import moe.nightfall.vic.integratedcircuits.cp.part.logic.PartNOTGate;
import moe.nightfall.vic.integratedcircuits.cp.part.logic.PartORGate;
import moe.nightfall.vic.integratedcircuits.cp.part.logic.PartXNORGate;
import moe.nightfall.vic.integratedcircuits.cp.part.logic.PartXORGate;
import moe.nightfall.vic.integratedcircuits.cp.part.timed.PartPulseFormer;
import moe.nightfall.vic.integratedcircuits.cp.part.timed.PartRandomizer;
import moe.nightfall.vic.integratedcircuits.cp.part.timed.PartRepeater;
import moe.nightfall.vic.integratedcircuits.cp.part.timed.PartSequencer;
import moe.nightfall.vic.integratedcircuits.cp.part.timed.PartStateCell;
import moe.nightfall.vic.integratedcircuits.cp.part.timed.PartSynchronizer;
import moe.nightfall.vic.integratedcircuits.cp.part.timed.PartTimer;
import moe.nightfall.vic.integratedcircuits.misc.CraftingAmount;
import moe.nightfall.vic.integratedcircuits.misc.PropertyStitcher;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class CircuitPart {
    private static HashMap<Integer, CircuitPart> partRegistry = new HashMap();
    private static HashMap<Class<? extends CircuitPart>, Integer> idRegistry = new HashMap();
    private int id;
    public final PropertyStitcher stitcher = new PropertyStitcher();
    public final PropertyStitcher.IntProperty PROP_INPUT = new PropertyStitcher.IntProperty("INPUT", this.stitcher, 15);

    public Category getCategory() {
        return Category.NONE;
    }

    public static void registerParts() {
        CircuitPart.registerPart(0, new PartNull());
        CircuitPart.registerPartConfig(1, new PartWire());
        CircuitPart.registerPartConfig(2, new PartTorch());
        CircuitPart.registerPartConfig(3, new PartANDGate());
        CircuitPart.registerPartConfig(4, new PartORGate());
        CircuitPart.registerPartConfig(5, new PartNANDGate());
        CircuitPart.registerPartConfig(6, new PartNORGate());
        CircuitPart.registerPartConfig(7, new PartBufferGate());
        CircuitPart.registerPartConfig(8, new PartNOTGate());
        CircuitPart.registerPartConfig(9, new PartMultiplexer());
        CircuitPart.registerPartConfig(10, new PartRepeater());
        CircuitPart.registerPartConfig(11, new PartTimer());
        CircuitPart.registerPartConfig(12, new PartSequencer());
        CircuitPart.registerPartConfig(13, new PartStateCell());
        CircuitPart.registerPartConfig(14, new PartRandomizer());
        CircuitPart.registerPartConfig(15, new PartPulseFormer());
        CircuitPart.registerPartConfig(16, new PartRSLatch());
        CircuitPart.registerPartConfig(17, new PartToggleLatch());
        CircuitPart.registerPartConfig(18, new PartTransparentLatch());
        CircuitPart.registerPartConfig(19, new PartXORGate());
        CircuitPart.registerPartConfig(20, new PartXNORGate());
        CircuitPart.registerPartConfig(21, new PartSynchronizer());
        CircuitPart.registerPartConfig(22, new PartNullCell());
        CircuitPart.registerPart(23, new PartIOBit());
        CircuitPart.registerPartConfig(24, new PartInvertCell());
        CircuitPart.registerPartConfig(25, new PartBufferCell());
        CircuitPart.registerPartConfig(26, new PartANDCell());
        CircuitPart.registerPartConfig(27, new PartTunnel());
    }

    public static void registerPartConfig(int id, CircuitPart part) {
        if (Config.config.getBoolean(part.getClass().getSimpleName().replaceFirst("Part", ""), "PARTS", true, "")) {
            CircuitPart.registerPart(id, part);
        }
    }

    public static void registerPart(int id, CircuitPart part) {
        part.id = id;
        partRegistry.put(id, part);
        idRegistry.put(part.getClass(), id);
        partRegistry.values();
    }

    public static Integer getId(CircuitPart part) {
        return part.id;
    }

    public static Integer getId(Class<? extends CircuitPart> clazz) {
        return idRegistry.get(clazz);
    }

    public static <T extends CircuitPart> T getPart(Class<T> clazz) {
        return (T)partRegistry.get(CircuitPart.getId(clazz));
    }

    public static CircuitPart getPart(int id) {
        return partRegistry.get(id);
    }

    public static Collection<CircuitPart> getParts() {
        return Collections.unmodifiableCollection(partRegistry.values());
    }

    public static List<CircuitPart> getParts(Category category) {
        ArrayList<CircuitPart> parts = new ArrayList<CircuitPart>();
        for (CircuitPart part : CircuitPart.getParts()) {
            if (part.getCategory() != category) continue;
            parts.add(part);
        }
        return parts;
    }

    public final <T extends Comparable> void setProperty(Vec2 pos, ICircuit parent, PropertyStitcher.IProperty<T> property, T value) {
        this.setState(pos, parent, property.set(value, this.getState(pos, parent)));
    }

    public final <T extends Comparable> T getProperty(Vec2 pos, ICircuit parent, PropertyStitcher.IProperty<T> property) {
        return property.get(this.getState(pos, parent));
    }

    public final <T extends Comparable> T invertProperty(Vec2 pos, ICircuit parent, PropertyStitcher.IProperty<T> property) {
        int state = this.getState(pos, parent);
        state = property.invert(state);
        this.setState(pos, parent, state);
        return property.get(state);
    }

    public final void cycleProperty(Vec2 pos, ICircuit parent, PropertyStitcher.ValueProperty property, int offset) {
        int value = (Integer)property.get(this.getState(pos, parent));
        value = (value + offset) % (property.getLimit() + 1);
        this.setProperty(pos, parent, property, value);
    }

    public final void cycleProperty(Vec2 pos, ICircuit parent, PropertyStitcher.ValueProperty property) {
        this.cycleProperty(pos, parent, property, 1);
    }

    public void onPlaced(Vec2 pos, ICircuit parent) {
        this.scheduleInputChange(pos, parent);
        this.notifyNeighbours(pos, parent);
    }

    public void onScheduledTick(Vec2 pos, ICircuit parent) {
    }

    public final void scheduleTick(Vec2 pos, ICircuit parent) {
        parent.getCircuitData().scheduleTick(pos);
    }

    public final void markForUpdate(Vec2 pos, ICircuit parent) {
        parent.getCircuitData().markForUpdate(pos);
    }

    public void onClick(Vec2 pos, ICircuit parent, int button, boolean ctrl) {
    }

    public String getName(Vec2 pos, ICircuit parent) {
        return this.getClass().getSimpleName().substring(4).toLowerCase();
    }

    public String getLocalizedName(Vec2 pos, ICircuit parent) {
        return I18n.func_135052_a((String)("part.integratedcircuits." + this.getName(pos, parent) + ".name"), (Object[])new Object[0]);
    }

    public ArrayList<String> getInformation(Vec2 pos, ICircuit parent, boolean edit, boolean ctrlDown) {
        return Lists.newArrayList();
    }

    public void getCraftingCost(CraftingAmount amount, CircuitData parent, Vec2 pos) {
    }

    public final int getState(Vec2 pos, ICircuit parent) {
        return parent.getCircuitData().getMeta(pos);
    }

    public final void setState(Vec2 pos, ICircuit parent, int state) {
        parent.getCircuitData().setMeta(pos, state);
    }

    public boolean canConnectToSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        return true;
    }

    public final boolean hasConnectionOnSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        if (side == ForgeDirection.UNKNOWN) {
            return false;
        }
        CircuitPart neighbour = this.getNeighbourOnSide(pos, parent, side);
        if (neighbour == null) {
            return false;
        }
        return this.canConnectToSide(pos, parent, side) && neighbour.canConnectToSide(pos.offset(side), parent, side.getOpposite());
    }

    public final boolean getInputFromSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        if (side == ForgeDirection.UNKNOWN) {
            return false;
        }
        boolean in = (this.getProperty(pos, parent, this.PROP_INPUT) << side.ordinal() - 2 & 8) != 0;
        return in;
    }

    public void onInputChange(Vec2 pos, ICircuit parent) {
    }

    public void scheduleInputChange(Vec2 pos, ICircuit parent) {
        parent.getCircuitData().scheduleInputChange(pos);
        this.markForUpdate(pos, parent);
    }

    public final void updateInput(Vec2 pos, ICircuit parent) {
        int input = 0;
        for (int i = 2; i < 6; ++i) {
            ForgeDirection fd = ForgeDirection.getOrientation((int)i);
            if (!this.hasConnectionOnSide(pos, parent, fd) || !this.getNeighbourOnSide(pos, parent, fd).getOutputToSide(pos.offset(fd), parent, fd.getOpposite())) continue;
            input |= 8 >> i - 2;
        }
        this.setProperty(pos, parent, this.PROP_INPUT, input);
    }

    public boolean getOutputToSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        return false;
    }

    public final void notifyNeighbours(Vec2 pos, ICircuit parent) {
        for (int i = 2; i < 6; ++i) {
            ForgeDirection fd = ForgeDirection.getOrientation((int)i);
            CircuitPart part = this.getNeighbourOnSide(pos, parent, fd);
            if (part == null) continue;
            ForgeDirection fd2 = fd.getOpposite();
            Vec2 pos2 = pos.offset(fd);
            if ((this.hasConnectionOnSide(pos, parent, fd) && this.getOutputToSide(pos, parent, fd)) == part.getInputFromSide(pos2, parent, fd2)) continue;
            part.scheduleInputChange(pos2, parent);
        }
        this.markForUpdate(pos, parent);
    }

    public final CircuitPart getNeighbourOnSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        return parent.getCircuitData().getPart(pos.offset(side));
    }

    public final boolean getInput(Vec2 pos, ICircuit parent) {
        return this.getInputFromSide(pos, parent, ForgeDirection.NORTH) || this.getInputFromSide(pos, parent, ForgeDirection.EAST) || this.getInputFromSide(pos, parent, ForgeDirection.SOUTH) || this.getInputFromSide(pos, parent, ForgeDirection.WEST);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderPart(Vec2 var1, ICircuit var2, double var3, double var5, CircuitPartRenderer.EnumRenderType var7);

    public void onChanged(Vec2 pos, ICircuit parent, int oldMeta) {
        this.scheduleInputChange(pos, parent);
        this.notifyNeighbours(pos, parent);
    }

    public void onRemoved(Vec2 pos, ICircuit parent) {
    }

    public Collection<Integer> getSubtypes() {
        return Collections.emptyList();
    }

    public static enum Category {
        NONE,
        MISC,
        LATCH,
        GATE,
        NGATE,
        CELL,
        WIRE,
        TORCH;

    }
}

