/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import moe.nightfall.vic.integratedcircuits.Config;
import moe.nightfall.vic.integratedcircuits.client.Resources;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPart;
import moe.nightfall.vic.integratedcircuits.cp.ICircuit;
import moe.nightfall.vic.integratedcircuits.cp.part.PartCPGate;
import moe.nightfall.vic.integratedcircuits.cp.part.PartIOBit;
import moe.nightfall.vic.integratedcircuits.cp.part.PartNull;
import moe.nightfall.vic.integratedcircuits.cp.part.PartWire;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.misc.RenderUtils;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class CircuitPartRenderer {
    public static final int PART_SIZE = 16;

    public static void renderPart(CircuitRenderWrapper crw, double x, double y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Resources.RESOURCE_PCB);
        Tessellator tes = Tessellator.field_78398_a;
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        tes.func_78382_b();
        CircuitPartRenderer.renderPartPayload(crw.getPos(), crw, crw.getPart(), 0.0, 0.0, EnumRenderType.GUI);
        tes.func_78381_a();
        GL11.glTranslated((double)(-x), (double)(-y), (double)0.0);
    }

    private static void renderPartPayload(Vec2 pos, ICircuit parent, CircuitPart part, double x, double y, EnumRenderType type) {
        if (!(type != EnumRenderType.WORLD_16x || part instanceof PartNull || part instanceof PartWire || part instanceof PartIOBit)) {
            Tessellator.field_78398_a.func_78369_a(0.0f, 0.0f, 0.0f, 1.0f);
            CircuitPartRenderer.addQuad(x, y, 0.0, 240.0, 16.0, 16.0);
        }
        part.renderPart(pos, parent, x, y, type);
    }

    @SideOnly(value=Side.CLIENT)
    public static int checkConnections(Vec2 pos, ICircuit parent, CircuitPart part) {
        boolean c1 = part.hasConnectionOnSide(pos, parent, ForgeDirection.NORTH);
        boolean c2 = part.hasConnectionOnSide(pos, parent, ForgeDirection.SOUTH);
        boolean c3 = part.hasConnectionOnSide(pos, parent, ForgeDirection.WEST);
        boolean c4 = part.hasConnectionOnSide(pos, parent, ForgeDirection.EAST);
        return (c1 ? 1 : 0) << 3 | (c2 ? 1 : 0) << 2 | (c3 ? 1 : 0) << 1 | (c4 ? 1 : 0);
    }

    public static void addQuad(double x, double y, double u, double v, double w, double h) {
        CircuitPartRenderer.addQuad(x, y, u, v, w, h, 0.0);
    }

    public static void addQuad(double x, double y, double u, double v, double w, double h, double rotation) {
        CircuitPartRenderer.addQuad(x, y, u, v, w, h, w, h, 256.0, 256.0, rotation);
    }

    public static void addQuad(double x, double y, double u, double v, double w, double h, double w2, double h2, double tw, double th, double rotation) {
        double scalew = 1.0 / tw;
        double scaleh = 1.0 / th;
        Tessellator tes = Tessellator.field_78398_a;
        double d1 = u + 0.0;
        double d2 = u + w2;
        if (rotation == 1.0) {
            double d3 = v + h2;
            double d4 = v + 0.0;
            tes.func_78374_a(x + w, y + h, 0.0, d2 * scalew, d4 * scaleh);
            tes.func_78374_a(x + w, y + 0.0, 0.0, d1 * scalew, d4 * scaleh);
            tes.func_78374_a(x + 0.0, y + 0.0, 0.0, d1 * scalew, d3 * scaleh);
            tes.func_78374_a(x + 0.0, y + h, 0.0, d2 * scalew, d3 * scaleh);
        } else if (rotation == 2.0) {
            double d3 = v + h2;
            double d4 = v + 0.0;
            tes.func_78374_a(x + 0.0, y + h, 0.0, d2 * scalew, d4 * scaleh);
            tes.func_78374_a(x + w, y + h, 0.0, d1 * scalew, d4 * scaleh);
            tes.func_78374_a(x + w, y + 0.0, 0.0, d1 * scalew, d3 * scaleh);
            tes.func_78374_a(x + 0.0, y + 0.0, 0.0, d2 * scalew, d3 * scaleh);
        } else if (rotation == 3.0) {
            double d3 = v + 0.0;
            double d4 = v + h2;
            tes.func_78374_a(x + w, y + h, 0.0, d1 * scalew, d4 * scaleh);
            tes.func_78374_a(x + w, y + 0.0, 0.0, d2 * scalew, d4 * scaleh);
            tes.func_78374_a(x + 0.0, y + 0.0, 0.0, d2 * scalew, d3 * scaleh);
            tes.func_78374_a(x + 0.0, y + h, 0.0, d1 * scalew, d3 * scaleh);
        } else {
            double d3 = v + 0.0;
            double d4 = v + h2;
            tes.func_78374_a(x + 0.0, y + h, 0.0, d1 * scalew, d4 * scaleh);
            tes.func_78374_a(x + w, y + h, 0.0, d2 * scalew, d4 * scaleh);
            tes.func_78374_a(x + w, y + 0.0, 0.0, d2 * scalew, d3 * scaleh);
            tes.func_78374_a(x + 0.0, y + 0.0, 0.0, d1 * scalew, d3 * scaleh);
        }
    }

    public static void renderParts(ICircuit circuit) {
        Tessellator tes = Tessellator.field_78398_a;
        int w = circuit.getCircuitData().getSize();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Resources.RESOURCE_PCB);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.0625f, (float)0.0625f, (float)1.0f);
        tes.func_78382_b();
        for (int x2 = 0; x2 < w; ++x2) {
            for (int y2 = 0; y2 < w; ++y2) {
                Vec2 pos = new Vec2(x2, y2);
                CircuitPartRenderer.renderPartPayload(pos, circuit, circuit.getCircuitData().getPart(pos), x2 * 16, y2 * 16, EnumRenderType.GUI);
            }
        }
        tes.func_78381_a();
        GL11.glPopMatrix();
    }

    public static void renderParts(ICircuit circuit, double offX, double offY, boolean[][] exc, EnumRenderType type) {
        Tessellator tes = Tessellator.field_78398_a;
        int w = circuit.getCircuitData().getSize();
        GL11.glPushMatrix();
        GL11.glTranslated((double)offX, (double)offY, (double)0.0);
        if (type == EnumRenderType.GUI) {
            GL11.glScalef((float)0.0625f, (float)0.0625f, (float)1.0f);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Resources.RESOURCE_PCB);
        tes.func_78382_b();
        for (int x2 = 0; x2 < w; ++x2) {
            for (int y2 = 0; y2 < w; ++y2) {
                Vec2 pos = new Vec2(x2, y2);
                if (!exc[x2][y2]) continue;
                CircuitPartRenderer.renderPartPayload(pos, circuit, circuit.getCircuitData().getPart(pos), x2 * 16, y2 * 16, type);
            }
        }
        tes.func_78381_a();
        GL11.glPopMatrix();
    }

    public static void renderPerfboard(CircuitData data) {
        Tessellator tes = Tessellator.field_78398_a;
        int size = data.getSize();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Resources.RESOURCE_PCB_PERF1);
        tes.func_78382_b();
        tes.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        CircuitPartRenderer.addQuad(0.0, 0.0, 0.0, 0.0, size, size, 16.0, 16.0, 16.0 / (double)size, 16.0 / (double)size, 0.0);
        tes.func_78381_a();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Resources.RESOURCE_PCB_PERF2);
        tes.func_78382_b();
        tes.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        CircuitPartRenderer.addQuad(0.0, 0.0, 0.0, 0.0, 1.0, size, 16.0, 16.0, 16.0, 16.0 / (double)size, 0.0);
        CircuitPartRenderer.addQuad(size - 1, 0.0, 0.0, 0.0, 1.0, size, 16.0, 16.0, 16.0, 16.0 / (double)size, 0.0);
        CircuitPartRenderer.addQuad(0.0, 0.0, 0.0, 0.0, size, 1.0, 16.0, 16.0, 16.0 / (double)size, 16.0, 0.0);
        CircuitPartRenderer.addQuad(0.0, size - 1, 0.0, 0.0, size, 1.0, 16.0, 16.0, 16.0 / (double)size, 16.0, 0.0);
        tes.func_78381_a();
    }

    public static void renderPartGate(Vec2 pos, ICircuit parent, PartCPGate gate, double x, double y, EnumRenderType type) {
        Tessellator tes = Tessellator.field_78398_a;
        if (gate.canConnectToSide(pos, parent, ForgeDirection.NORTH)) {
            if (type == EnumRenderType.GUI && (gate.getOutputToSide(pos, parent, ForgeDirection.NORTH) || gate.getInputFromSide(pos, parent, ForgeDirection.NORTH))) {
                RenderUtils.applyColorIRGBA(tes, Config.colorGreen);
            } else {
                RenderUtils.applyColorIRGBA(tes, Config.colorGreen, 0.4f);
            }
            CircuitPartRenderer.addQuad(x, y, 32.0, 0.0, 16.0, 16.0);
        }
        if (gate.canConnectToSide(pos, parent, ForgeDirection.SOUTH)) {
            if (type == EnumRenderType.GUI && (gate.getOutputToSide(pos, parent, ForgeDirection.SOUTH) || gate.getInputFromSide(pos, parent, ForgeDirection.SOUTH))) {
                RenderUtils.applyColorIRGBA(tes, Config.colorGreen);
            } else {
                RenderUtils.applyColorIRGBA(tes, Config.colorGreen, 0.4f);
            }
            CircuitPartRenderer.addQuad(x, y, 64.0, 0.0, 16.0, 16.0);
        }
        if (gate.canConnectToSide(pos, parent, ForgeDirection.WEST)) {
            if (type == EnumRenderType.GUI && (gate.getOutputToSide(pos, parent, ForgeDirection.WEST) || gate.getInputFromSide(pos, parent, ForgeDirection.WEST))) {
                RenderUtils.applyColorIRGBA(tes, Config.colorGreen);
            } else {
                RenderUtils.applyColorIRGBA(tes, Config.colorGreen, 0.4f);
            }
            CircuitPartRenderer.addQuad(x, y, 16.0, 0.0, 16.0, 16.0);
        }
        if (gate.canConnectToSide(pos, parent, ForgeDirection.EAST)) {
            if (type == EnumRenderType.GUI && (gate.getOutputToSide(pos, parent, ForgeDirection.EAST) || gate.getInputFromSide(pos, parent, ForgeDirection.EAST))) {
                RenderUtils.applyColorIRGBA(tes, Config.colorGreen);
            } else {
                RenderUtils.applyColorIRGBA(tes, Config.colorGreen, 0.4f);
            }
            CircuitPartRenderer.addQuad(x, y, 48.0, 0.0, 16.0, 16.0);
        }
        RenderUtils.applyColorIRGBA(tes, Config.colorGreen);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderPartCell(Vec2 pos, ICircuit parent, CircuitPart cell, double x, double y, EnumRenderType type) {
        Tessellator tes = Tessellator.field_78398_a;
        int rotation = 0;
        if (cell instanceof PartCPGate) {
            rotation = ((PartCPGate)cell).getRotation(pos, parent);
        }
        if (type == EnumRenderType.GUI && (cell.getOutputToSide(pos, parent, MiscUtils.rotn(ForgeDirection.NORTH, rotation)) || cell.getInputFromSide(pos, parent, MiscUtils.rotn(ForgeDirection.NORTH, rotation)) || cell.getOutputToSide(pos, parent, MiscUtils.rotn(ForgeDirection.SOUTH, rotation)) || cell.getInputFromSide(pos, parent, MiscUtils.rotn(ForgeDirection.SOUTH, rotation)))) {
            RenderUtils.applyColorIRGBA(tes, Config.colorGreen);
        } else {
            RenderUtils.applyColorIRGBA(tes, Config.colorGreen, 0.4f);
        }
        CircuitPartRenderer.addQuad(x, y, 0.0, 32.0, 16.0, 16.0, rotation);
        if (type == EnumRenderType.GUI && (cell.getOutputToSide(pos, parent, MiscUtils.rotn(ForgeDirection.EAST, rotation)) || cell.getInputFromSide(pos, parent, MiscUtils.rotn(ForgeDirection.EAST, rotation)) || cell.getOutputToSide(pos, parent, MiscUtils.rotn(ForgeDirection.WEST, rotation)) || cell.getInputFromSide(pos, parent, MiscUtils.rotn(ForgeDirection.WEST, rotation)))) {
            RenderUtils.applyColorIRGBA(tes, Config.colorGreen);
        } else {
            RenderUtils.applyColorIRGBA(tes, Config.colorGreen, 0.4f);
        }
    }

    public static class CircuitRenderWrapper
    implements ICircuit {
        private final CircuitData data;
        private final CircuitPart part;
        private final Vec2 pos;

        public CircuitRenderWrapper(Class<? extends CircuitPart> clazz) {
            this(clazz, 0);
        }

        public CircuitRenderWrapper(Class<? extends CircuitPart> clazz, int state) {
            this(state, CircuitPart.getPart(clazz));
        }

        public CircuitRenderWrapper(int state, CircuitPart part) {
            this.data = CircuitData.createShallowInstance(state, this);
            this.part = part;
            this.pos = new Vec2(1, 1);
        }

        public CircuitRenderWrapper(CircuitData data) {
            this(data, null, null);
        }

        public CircuitRenderWrapper(CircuitData data, CircuitPart part, Vec2 pos) {
            this.data = data;
            this.part = part;
            this.pos = pos;
        }

        public CircuitPart getPart() {
            return this.part;
        }

        @Override
        public CircuitData getCircuitData() {
            return this.data;
        }

        public Vec2 getPos() {
            return this.pos;
        }

        public int getState() {
            return this.getCircuitData().getMeta(this.getPos());
        }

        public void setState(int state) {
            this.getCircuitData().setMeta(this.getPos(), state);
        }

        @Override
        public void setCircuitData(CircuitData data) {
        }

        @Override
        public boolean getInputFromSide(ForgeDirection dir, int frequency) {
            return false;
        }

        @Override
        public void setOutputToSide(ForgeDirection dir, int frequency, boolean output) {
        }
    }

    public static enum EnumRenderType {
        GUI,
        WORLD,
        WORLD_16x;

    }
}

