/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import moe.nightfall.vic.integratedcircuits.api.gate.ISocket;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CircuitProperties
implements Cloneable {
    private String name = "NO_NAME";
    private String author = "unknown";
    private int con;
    private Map<UUID, Comment> comments = new LinkedHashMap<UUID, Comment>();

    public void setName(String name) {
        this.name = name;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setCon(int con) {
        this.con = con;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public int getCon() {
        return this.con;
    }

    public void clearComments() {
        this.comments.clear();
    }

    public void removeComment(Comment comment) {
        if (comment == null) {
            return;
        }
        this.comments.remove(comment.uuid);
    }

    public void removeComment(UUID uuid) {
        this.comments.remove(uuid);
    }

    public void addComment(Comment comment) {
        this.comments.put(comment.uuid, comment);
    }

    public Collection<Comment> getComments() {
        return this.comments.values();
    }

    public ISocket.EnumConnectionType getModeAtSide(int side) {
        return CircuitProperties.getModeAtSide(this.con, side);
    }

    public static ISocket.EnumConnectionType getModeAtSide(int con, int side) {
        return ISocket.EnumConnectionType.values()[con >> side * 2 & 3];
    }

    public int setModeAtSide(int side, ISocket.EnumConnectionType type) {
        int con = this.con;
        con &= ~(3 << side * 2);
        return con |= type.ordinal() << side * 2;
    }

    public static CircuitProperties readFromNBT(NBTTagCompound comp) {
        CircuitProperties properties = new CircuitProperties();
        if (comp.func_74764_b("name")) {
            properties.name = comp.func_74779_i("name");
        }
        if (comp.func_74764_b("author")) {
            properties.author = comp.func_74779_i("author");
        }
        properties.con = comp.func_74762_e("con");
        if (comp.func_74764_b("comments")) {
            NBTTagList commentList = comp.func_150295_c("comments", 10);
            for (int i = 0; i < commentList.func_74745_c(); ++i) {
                NBTTagCompound comment = commentList.func_150305_b(i);
                properties.addComment(Comment.readFromNBT(comment));
            }
        }
        return properties;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound comp, boolean pcb) {
        comp.func_74778_a("name", this.name);
        comp.func_74778_a("author", this.author);
        comp.func_74768_a("con", this.con);
        if (!pcb) {
            NBTTagList commentList = new NBTTagList();
            for (Comment comment : this.comments.values()) {
                commentList.func_74742_a((NBTBase)comment.writeToNBT(new NBTTagCompound()));
            }
            comp.func_74782_a("comments", (NBTBase)commentList);
        }
        return comp;
    }

    public static class Comment
    implements Cloneable {
        public String text = "";
        public double xPos;
        public double yPos;
        public int id;
        public UUID uuid;

        public Comment(double xPos, double yPos) {
            this(xPos, yPos, UUID.randomUUID());
        }

        public Comment(double xPos, double yPos, UUID uuid) {
            this.xPos = xPos;
            this.yPos = yPos;
            this.uuid = uuid;
        }

        public Comment setText(String text) {
            this.text = text;
            return this;
        }

        public static Comment readFromNBT(NBTTagCompound comp) {
            Comment comment = new Comment(comp.func_74769_h("xPos"), comp.func_74769_h("yPos"));
            comment.text = comp.func_74779_i("text");
            comment.uuid = UUID.fromString(comp.func_74779_i("uuid"));
            return comment;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound compound) {
            compound.func_74780_a("xPos", this.xPos);
            compound.func_74780_a("yPos", this.yPos);
            compound.func_74778_a("text", this.text);
            compound.func_74778_a("uuid", this.uuid.toString());
            return compound;
        }
    }
}

