/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp.legacy;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.legacy.LegacyLoader_0_8;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraft.nbt.NBTTagCompound;

public abstract class LegacyLoader
implements Comparable<LegacyLoader> {
    private static final List<LegacyLoader> legacyLoaders = new ArrayList<LegacyLoader>();
    private Map<Integer, PartTransformer> partTransformers = new HashMap<Integer, PartTransformer>();

    public abstract int getVersion();

    public static List<LegacyLoader> getLegacyLoaders(int version) {
        LegacyLoader loader;
        int i;
        for (i = 0; i < legacyLoaders.size() && (loader = legacyLoaders.get(i)).getVersion() < version; ++i) {
        }
        return new ArrayList<LegacyLoader>(legacyLoaders.subList(i, legacyLoaders.size()));
    }

    public final LegacyLoader addTransformer(PartTransformer transformer, int id) {
        this.partTransformers.put(id, transformer);
        return this;
    }

    public void transformNBT(NBTTagCompound data) {
    }

    public void transform(int size, int[][] id, int[][] meta) {
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                int pid = id[x][y];
                if (!this.partTransformers.containsKey(pid)) continue;
                PartTransformer transformer = this.partTransformers.get(pid);
                transformer.id = pid;
                transformer.meta = meta[x][y];
                transformer.transform();
                id[x][y] = transformer.id;
                meta[x][y] = transformer.meta;
            }
        }
    }

    public void postTransform(CircuitData cdata) {
        for (int x = 0; x < cdata.getSize(); ++x) {
            for (int y = 0; y < cdata.getSize(); ++y) {
                Vec2 pos = new Vec2(x, y);
                int pid = cdata.getID(pos);
                if (!this.partTransformers.containsKey(pid)) continue;
                PartTransformer transformer = this.partTransformers.get(pid);
                transformer.id = pid;
                transformer.meta = cdata.getMeta(pos);
                transformer.postTransform(pos, cdata);
            }
        }
    }

    @Override
    public int compareTo(LegacyLoader other) {
        return Integer.compare(this.getVersion(), other.getVersion());
    }

    static {
        legacyLoaders.add(new LegacyLoader_0_8());
        Collections.sort(legacyLoaders);
    }

    public static class AllocationMap {
        protected int index;
        protected int size;
        protected int id = 0;
        private Map<Integer, Allocation> allocationMap = new HashMap<Integer, Allocation>();

        public AllocationMap(int size) {
            this.size = size;
        }

        public void skip(int size) {
            this.index += size;
            if (this.index >= this.size) {
                throw new ArrayIndexOutOfBoundsException();
            }
        }

        public int allocate(int size) {
            this.allocationMap.put(this.id, new Allocation(this.index, size));
            this.skip(size);
            return this.id++;
        }

        public int allocate() {
            return this.allocate(1);
        }

        public void set(int id, BitSet value, BitSet data) {
            if (!this.allocationMap.containsKey(id)) {
                return;
            }
            Allocation allocation = this.allocationMap.get(id);
            for (int i = 0; i < allocation.size; ++i) {
                data.set(i + allocation.index, value.get(i));
            }
        }

        public BitSet get(int id, BitSet data) {
            if (!this.allocationMap.containsKey(id)) {
                throw new ArrayIndexOutOfBoundsException();
            }
            Allocation allocation = this.allocationMap.get(id);
            BitSet value = new BitSet(allocation.size);
            for (int i = 0; i < allocation.size; ++i) {
                value.set(i, data.get(i + allocation.index));
            }
            return value;
        }

        private static class Allocation {
            private final int index;
            private final int size;

            private Allocation(int index, int size) {
                this.index = index;
                this.size = size;
            }
        }
    }

    public static abstract class PartTransformer {
        protected int id;
        private int meta;
        protected AllocationMap old = new AllocationMap(32);
        protected AllocationMap transformed = new AllocationMap(32);
        private BitSet oldMeta;
        private BitSet transformedMeta;

        public final void transform() {
            this.oldMeta = BitSet.valueOf(new long[]{this.meta});
            this.transformedMeta = new BitSet(32);
            this.transformImpl();
            this.meta = this.transformedMeta.length() == 0 ? 0 : (int)this.transformedMeta.toLongArray()[0];
        }

        protected final int getInt(int id) {
            BitSet bs = this.old.get(id, this.oldMeta);
            return bs.length() == 0 ? 0 : (int)bs.toLongArray()[0];
        }

        protected final boolean getBit(int id) {
            return this.old.get(id, this.oldMeta).get(0);
        }

        protected final void setInt(int id, int value) {
            this.transformed.set(id, BitSet.valueOf(new long[]{value}), this.transformedMeta);
        }

        protected final void setBit(int id, boolean value) {
            BitSet data = new BitSet(1);
            data.set(0, value);
            this.transformed.set(id, data, this.transformedMeta);
        }

        protected void transformImpl() {
        }

        public void postTransform(Vec2 crd, CircuitData cdata) {
        }
    }
}

