/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp.legacy;

import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.legacy.LegacyLoader;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public final class LegacyLoader_0_8
extends LegacyLoader {
    public LegacyLoader_0_8() {
        this.addTransformer(new PartWireTransformer(), 1);
        this.addTransformer(new CircuitPartTransformer(), 2);
        this.addTransformer(new Part3I1OTransformer(), 3);
        this.addTransformer(new Part3I1OTransformer(), 4);
        this.addTransformer(new Part3I1OTransformer(), 5);
        this.addTransformer(new Part3I1OTransformer(), 6);
        this.addTransformer(new Part1I3OTransformer(), 7);
        this.addTransformer(new Part1I3OTransformer(), 8);
        this.addTransformer(new PartSimpleGateTransformer(), 9);
        this.addTransformer(new PartRepeaterTransformer(), 10);
        this.addTransformer(new PartTimerTransformer(), 11);
        this.addTransformer(new PartSequencerTransformer(), 12);
        this.addTransformer(new PartStateCellTransformer(), 13);
        this.addTransformer(new PartRandomizerTransformer(), 14);
        this.addTransformer(new PartPulseFormerTransformer(), 15);
        this.addTransformer(new PartRSLatchTransformer(), 16);
        this.addTransformer(new PartToggleLatchTransformer(), 17);
        this.addTransformer(new PartTransparentLatchTransformer(), 18);
        this.addTransformer(new PartXORGateTransformer(), 19);
        this.addTransformer(new PartXORGateTransformer(), 20);
        this.addTransformer(new PartSynchronizerTransformer(), 21);
        this.addTransformer(new CircuitPartTransformer(), 22);
        this.addTransformer(new PartIOBitTransformer(), 23);
        this.addTransformer(new PartSimpleGateTransformer(), 24);
        this.addTransformer(new PartSimpleGateTransformer(), 25);
        this.addTransformer(new PartSimpleGateTransformer(), 26);
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private int swapBundledAnalog(int con) {
        int mask = (con ^ con << 1) & 0xAA;
        mask |= mask >> 1;
        return con ^ mask;
    }

    @Override
    public void transformNBT(NBTTagCompound data) {
        NBTTagCompound props = data.func_74775_l("properties");
        props.func_74768_a("con", this.swapBundledAnalog(props.func_74762_e("con")));
    }

    private static class PartXORGateTransformer
    extends PartSimpleGateTransformer {
        protected final int newConnectors;

        private PartXORGateTransformer() {
            this.newConnectors = this.transformed.allocate(2);
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            this.setInt(this.newConnectors, 0);
        }
    }

    private static class Part3I1OTransformer
    extends PartSimpleGateTransformer {
        protected final int oldConnectors;
        protected final int newConnectors;

        private Part3I1OTransformer() {
            this.oldConnectors = this.old.allocate(2);
            this.newConnectors = this.transformed.allocate(2);
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            this.setInt(this.newConnectors, this.getInt(this.oldConnectors));
        }
    }

    private static class Part1I3OTransformer
    extends PartSimpleGateTransformer {
        protected final int oldConnectors;
        protected final int newConnectors;

        private Part1I3OTransformer() {
            this.oldConnectors = this.old.allocate(3);
            this.newConnectors = this.transformed.allocate(3);
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            this.setInt(this.newConnectors, this.getInt(this.oldConnectors));
        }
    }

    private static class PartTimerTransformer
    extends PartDelayedActionTransformer {
        protected final int oldOut;
        protected final int oldDelay;
        protected final int newOut;
        protected final int newDelay;

        private PartTimerTransformer() {
            this.oldOut = this.old.allocate();
            this.oldDelay = this.old.allocate(8);
            this.newOut = this.transformed.allocate();
            this.newDelay = this.transformed.allocate(8);
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            this.setBit(this.newOut, this.getBit(this.oldOut));
            this.setInt(this.newDelay, this.getInt(this.oldDelay));
        }

        @Override
        public int getDelay() {
            return this.getBit(this.oldOut) ? 2 : this.getInt(this.oldDelay);
        }
    }

    private static class PartStateCellTransformer
    extends PartDelayedActionTransformer {
        protected final int oldDelay;
        protected final int oldOutWest;
        protected final int oldOutNorth;
        protected final int newDelay;
        protected final int newOutWest;
        protected final int newOutNorth;

        private PartStateCellTransformer() {
            this.oldDelay = this.old.allocate(8);
            this.oldOutWest = this.old.allocate();
            this.oldOutNorth = this.old.allocate();
            this.newDelay = this.transformed.allocate(8);
            this.newOutWest = this.transformed.allocate();
            this.newOutNorth = this.transformed.allocate();
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            this.setInt(this.newDelay, this.getInt(this.oldDelay));
            if (this.getRotatedInput(ForgeDirection.SOUTH)) {
                this.setBit(this.newOutWest, true);
                this.setBit(this.newOutNorth, false);
                this.setBit(this.newActive, false);
                this.setInt(this.newCurrentDelay, 0);
            } else {
                this.setBit(this.newOutWest, this.getBit(this.oldOutWest));
                this.setBit(this.newOutNorth, this.getBit(this.oldOutNorth));
            }
        }

        @Override
        public int getDelay() {
            return this.getBit(this.oldOutNorth) ? 2 : this.getInt(this.oldDelay);
        }
    }

    private static class PartSequencerTransformer
    extends PartDelayedActionTransformer {
        protected final int oldOut;
        protected final int oldDelay;
        protected final int oldOutSide;
        protected final int newOutSide;
        protected final int newDelay;

        private PartSequencerTransformer() {
            this.oldOut = this.old.allocate();
            this.oldDelay = this.old.allocate(8);
            this.oldOutSide = this.old.allocate(2);
            this.newOutSide = this.transformed.allocate(2);
            this.newDelay = this.transformed.allocate(8);
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            this.setInt(this.newDelay, this.getInt(Math.min(this.oldDelay + 2, 255)));
            this.setInt(this.newOutSide, this.getInt(this.oldOutSide));
            if (!this.getBit(this.oldActive)) {
                this.setBit(this.newActive, true);
                this.setInt(this.newCurrentDelay, 0);
            }
        }

        @Override
        public int getDelay() {
            return this.getInt(this.oldDelay);
        }
    }

    private static class PartRepeaterTransformer
    extends PartDelayedActionTransformer {
        protected final int oldDelay;
        protected final int oldOut;
        protected final int newDelay;
        protected final int newOut;

        private PartRepeaterTransformer() {
            this.oldDelay = this.old.allocate(8);
            this.oldOut = this.old.allocate();
            this.newDelay = this.transformed.allocate(8);
            this.newOut = this.transformed.allocate();
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            int delay = this.getInt(this.oldDelay);
            if (delay != 255) {
                --delay;
            }
            this.setBit(this.newOut, this.getBit(this.oldOut));
            this.setInt(this.newDelay, delay);
        }

        @Override
        public int getDelay() {
            return this.getInt(this.oldDelay);
        }
    }

    private static class PartRandomizerTransformer
    extends PartDelayedActionTransformer {
        protected final int oldRandom;
        protected final int newRandom;

        private PartRandomizerTransformer() {
            this.oldRandom = this.old.allocate(3);
            this.newRandom = this.transformed.allocate(3);
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            this.setBit(this.newRandom, this.getBit(this.oldRandom));
        }

        @Override
        public int getDelay() {
            return 2;
        }
    }

    private static class PartPulseFormerTransformer
    extends PartDelayedActionTransformer {
        protected final int newOldIn;

        private PartPulseFormerTransformer() {
            this.newOldIn = this.transformed.allocate();
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            this.setBit(this.newOldIn, this.getRotatedInput(ForgeDirection.SOUTH));
        }

        @Override
        public int getDelay() {
            return 2;
        }
    }

    private static class PartTransparentLatchTransformer
    extends PartCPGateTransformer {
        protected final int oldOut;
        protected final int oldTmp;
        protected final int newOut;

        private PartTransparentLatchTransformer() {
            this.oldOut = this.old.allocate();
            this.oldTmp = this.old.allocate();
            this.newOut = this.transformed.allocate();
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            this.setBit(this.newOut, this.getBit(this.oldOut));
        }
    }

    private static class PartToggleLatchTransformer
    extends PartCPGateTransformer {
        protected final int oldOut;
        protected final int oldTmp;
        protected final int newOut;
        protected final int newOldNorth;
        protected final int newOldSouth;

        private PartToggleLatchTransformer() {
            this.oldOut = this.old.allocate();
            this.oldTmp = this.old.allocate();
            this.newOut = this.transformed.allocate();
            this.newOldNorth = this.transformed.allocate();
            this.newOldSouth = this.transformed.allocate();
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            this.setBit(this.newOut, this.getBit(this.oldOut));
            this.setBit(this.newOldNorth, this.getRotatedInput(ForgeDirection.NORTH));
            this.setBit(this.newOldSouth, this.getRotatedInput(ForgeDirection.SOUTH));
        }
    }

    private static class PartSynchronizerTransformer
    extends PartCPGateTransformer {
        protected final int oldEast;
        protected final int oldWest;
        protected final int oldOut;
        protected final int newActive;
        protected final int newCurrentDelay;
        protected final int newEast;
        protected final int newWest;
        protected final int newOldEast;
        protected final int newOldWest;

        private PartSynchronizerTransformer() {
            this.oldEast = this.old.allocate();
            this.oldWest = this.old.allocate();
            this.oldOut = this.old.allocate();
            this.newActive = this.transformed.allocate();
            this.newCurrentDelay = this.transformed.allocate(8);
            this.newEast = this.transformed.allocate();
            this.newWest = this.transformed.allocate();
            this.newOldEast = this.transformed.allocate();
            this.newOldWest = this.transformed.allocate();
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            this.setBit(this.newEast, this.getBit(this.oldEast));
            this.setBit(this.newWest, this.getBit(this.oldWest));
            this.setBit(this.newActive, this.getBit(this.oldOut));
            this.setInt(this.newCurrentDelay, 0);
            this.setBit(this.newOldEast, this.getRotatedInput(ForgeDirection.EAST));
            this.setBit(this.newOldWest, this.getRotatedInput(ForgeDirection.WEST));
        }
    }

    private static class PartSimpleGateTransformer
    extends PartCPGateTransformer {
        protected final int oldOut;
        protected final int oldTmp;
        protected final int newOut;

        private PartSimpleGateTransformer() {
            this.oldOut = this.old.allocate();
            this.oldTmp = this.old.allocate();
            this.newOut = this.transformed.allocate();
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            this.setInt(this.newOut, this.getInt(this.oldTmp));
        }
    }

    private static class PartRSLatchTransformer
    extends PartCPGateTransformer {
        protected final int oldOut;
        protected final int oldTmp;
        protected final int oldMode;
        protected final int newState;
        protected final int newCheck;
        protected final int newMode;

        private PartRSLatchTransformer() {
            this.oldOut = this.old.allocate();
            this.oldTmp = this.old.allocate();
            this.oldMode = this.old.allocate(2);
            this.newState = this.transformed.allocate(2);
            this.newCheck = this.transformed.allocate();
            this.newMode = this.transformed.allocate(2);
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            this.setInt(this.newMode, this.getInt(this.oldMode));
            this.setBit(this.newCheck, false);
            this.setInt(this.newState, this.getBit(this.oldOut) ? 1 : 2);
        }
    }

    private static abstract class PartDelayedActionTransformer
    extends PartCPGateTransformer {
        protected final int oldActive;
        protected final int oldCurrentDelay;
        protected final int newActive;
        protected final int newCurrentDelay;

        private PartDelayedActionTransformer() {
            this.oldActive = this.old.allocate();
            this.oldCurrentDelay = this.old.allocate(8);
            this.newActive = this.transformed.allocate();
            this.newCurrentDelay = this.transformed.allocate(8);
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            boolean active = this.getBit(this.oldActive);
            int currentDelay = 0;
            if (active && (currentDelay = this.getDelay() - this.getInt(this.oldCurrentDelay)) < 0) {
                currentDelay = 0;
            }
            this.setBit(this.newActive, active);
            this.setInt(this.newCurrentDelay, currentDelay);
        }

        protected abstract int getDelay();
    }

    private static class PartWireTransformer
    extends CircuitPartTransformer {
        protected final int oldColor;
        protected final int newColor;

        private PartWireTransformer() {
            this.oldColor = this.old.allocate(2);
            this.newColor = this.transformed.allocate(2);
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            this.setInt(this.newColor, this.getInt(this.oldColor));
        }
    }

    private static class PartIOBitTransformer
    extends CircuitPartTransformer {
        protected final int oldRotFreq;
        protected final int newRotFreq;

        private PartIOBitTransformer() {
            this.oldRotFreq = this.old.allocate(6);
            this.newRotFreq = this.transformed.allocate(6);
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            this.setInt(this.newRotFreq, this.getInt(this.oldRotFreq));
        }
    }

    private static abstract class PartCPGateTransformer
    extends CircuitPartTransformer {
        protected final int oldRotation;
        protected final int newRotation;

        private PartCPGateTransformer() {
            this.oldRotation = this.old.allocate(2);
            this.newRotation = this.transformed.allocate(2);
        }

        @Override
        public void transformImpl() {
            super.transformImpl();
            this.setInt(this.newRotation, this.getInt(this.oldRotation));
        }

        protected final boolean getRotatedInput(ForgeDirection side) {
            return this.getInput(MiscUtils.rotn(side, this.getInt(this.oldRotation)));
        }
    }

    private static class CircuitPartTransformer
    extends LegacyLoader.PartTransformer {
        protected final int oldInput;
        protected final int newInput;

        private CircuitPartTransformer() {
            this.oldInput = this.old.allocate(4);
            this.newInput = this.transformed.allocate(4);
        }

        @Override
        public void transformImpl() {
            this.setInt(this.newInput, this.getInt(this.oldInput));
        }

        @Override
        public void postTransform(Vec2 pos, CircuitData cdata) {
            cdata.scheduleInputChange(pos);
            cdata.scheduleTick(pos);
        }

        protected final boolean getInput(ForgeDirection side) {
            return (this.getInt(this.oldInput) << side.ordinal() - 2 & 8) != 0;
        }
    }
}

