/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp.part;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import moe.nightfall.vic.integratedcircuits.Content;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPart;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPartRenderer;
import moe.nightfall.vic.integratedcircuits.cp.ICircuit;
import moe.nightfall.vic.integratedcircuits.misc.CraftingAmount;
import moe.nightfall.vic.integratedcircuits.misc.ItemAmount;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.misc.PropertyStitcher;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class PartCPGate
extends CircuitPart {
    public final PropertyStitcher.IntProperty PROP_ROTATION;

    public PartCPGate() {
        this.PROP_ROTATION = new PropertyStitcher.IntProperty("ROTATION", this.stitcher, 3);
    }

    public final int getRotation(Vec2 pos, ICircuit parent) {
        return this.getProperty(pos, parent, this.PROP_ROTATION);
    }

    public final void setRotation(Vec2 pos, ICircuit parent, int rotation) {
        this.setProperty(pos, parent, this.PROP_ROTATION, rotation);
        this.scheduleInputChange(pos, parent);
        this.notifyNeighbours(pos, parent);
    }

    @Override
    public CircuitPart.Category getCategory() {
        return CircuitPart.Category.MISC;
    }

    @Override
    public void onClick(Vec2 pos, ICircuit parent, int button, boolean ctrl) {
        if (button == 0 && !ctrl) {
            this.cycleProperty(pos, parent, this.PROP_ROTATION);
            this.scheduleInputChange(pos, parent);
            this.notifyNeighbours(pos, parent);
        }
    }

    public ForgeDirection toInternal(Vec2 pos, ICircuit parent, ForgeDirection dir) {
        return MiscUtils.rotn(dir, -this.getRotation(pos, parent));
    }

    public ForgeDirection toExternal(Vec2 pos, ICircuit parent, ForgeDirection dir) {
        return MiscUtils.rotn(dir, this.getRotation(pos, parent));
    }

    @Override
    public ArrayList<String> getInformation(Vec2 pos, ICircuit parent, boolean edit, boolean ctrlDown) {
        ArrayList text = Lists.newArrayList();
        ForgeDirection rot = MiscUtils.getDirection(this.getRotation(pos, parent));
        text.add(EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + MiscUtils.getLocalizedDirection(rot));
        if (edit && !ctrlDown) {
            text.add(I18n.func_135052_a((String)"gui.integratedcircuits.cad.rotate", (Object[])new Object[0]));
        }
        return text;
    }

    @Override
    public void getCraftingCost(CraftingAmount cost, CircuitData parent, Vec2 pos) {
        cost.add(new ItemAmount(Items.field_151137_ax, 0.048));
        cost.add(new ItemAmount(Content.itemSiliconDrop, 0.1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPart(Vec2 pos, ICircuit parent, double x, double y, CircuitPartRenderer.EnumRenderType type) {
        CircuitPartRenderer.renderPartGate(pos, parent, this, x, y, type);
        Vec2 textureOffset = this.getTextureOffset(pos, parent, x, y, type);
        CircuitPartRenderer.addQuad(x, y, textureOffset.x * 16, textureOffset.y * 16, 16.0, 16.0, this.getRotation(pos, parent));
    }

    @SideOnly(value=Side.CLIENT)
    public abstract Vec2 getTextureOffset(Vec2 var1, ICircuit var2, double var3, double var5, CircuitPartRenderer.EnumRenderType var7);
}

