/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp.part;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import moe.nightfall.vic.integratedcircuits.Config;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPart;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPartRenderer;
import moe.nightfall.vic.integratedcircuits.cp.ICircuit;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.misc.PropertyStitcher;
import moe.nightfall.vic.integratedcircuits.misc.RenderUtils;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.common.util.ForgeDirection;

public class PartIOBit
extends CircuitPart {
    public final PropertyStitcher.IntProperty PROP_ROTATION;
    public final PropertyStitcher.IntProperty PROP_FREQUENCY;

    public PartIOBit() {
        this.PROP_ROTATION = new PropertyStitcher.IntProperty("ROTATION", this.stitcher, 3);
        this.PROP_FREQUENCY = new PropertyStitcher.IntProperty("FREQUENCY", this.stitcher, 15);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPart(Vec2 pos, ICircuit parent, double x, double y, CircuitPartRenderer.EnumRenderType type) {
        int freq = this.getFrequency(pos, parent);
        int rot = this.getRotation(pos, parent);
        Tessellator tes = Tessellator.field_78398_a;
        if (type == CircuitPartRenderer.EnumRenderType.WORLD_16x) {
            tes.func_78370_a(188, 167, 60, 255);
            CircuitPartRenderer.addQuad(x, y, 96.0, 48.0, 16.0, 16.0, rot);
        } else {
            tes.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
            CircuitPartRenderer.addQuad(x, y, 32.0, 32.0, 16.0, 16.0, rot);
            if (this.isPowered(pos, parent) && type == CircuitPartRenderer.EnumRenderType.GUI) {
                RenderUtils.applyColorIRGBA(tes, Config.colorGreen);
            } else {
                RenderUtils.applyColorIRGBA(tes, Config.colorGreen, 0.4f);
            }
            CircuitPartRenderer.addQuad(x, y, 64.0, 32.0, 16.0, 16.0, rot);
            if (type == CircuitPartRenderer.EnumRenderType.GUI) {
                if (parent.getCircuitData().getProperties().getModeAtSide(this.getRotation(pos, parent)).isAnalog()) {
                    tes.func_78384_a(this.getFrequency(pos, parent) * 17 << 20, 255);
                } else {
                    tes.func_78384_a(MapColor.func_151644_a((int)freq).field_76291_p, 255);
                }
                CircuitPartRenderer.addQuad(x, y, 48.0, 32.0, 16.0, 16.0, rot);
            }
        }
    }

    public final int getRotation(Vec2 pos, ICircuit parent) {
        return this.getProperty(pos, parent, this.PROP_ROTATION);
    }

    public final void setRotation(Vec2 pos, ICircuit parent, int rotation) {
        this.setProperty(pos, parent, this.PROP_ROTATION, rotation);
    }

    public final int getFrequency(Vec2 pos, ICircuit parent) {
        return this.getProperty(pos, parent, this.PROP_FREQUENCY);
    }

    public final void setFrequency(Vec2 pos, ICircuit parent, int frequency) {
        this.setProperty(pos, parent, this.PROP_FREQUENCY, frequency);
    }

    public final void updateExternalOutput(Vec2 pos, ICircuit parent) {
        ForgeDirection dir = MiscUtils.getDirection(this.getRotation(pos, parent));
        parent.setOutputToSide(dir, this.getFrequency(pos, parent), this.getInputFromSide(pos, parent, dir.getOpposite()));
    }

    @Override
    public boolean canConnectToSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        ForgeDirection dir = MiscUtils.getDirection(this.getRotation(pos, parent));
        return side == dir.getOpposite();
    }

    @Override
    public void onInputChange(Vec2 pos, ICircuit parent) {
        this.scheduleTick(pos, parent);
        this.notifyNeighbours(pos, parent);
    }

    @Override
    public void onScheduledTick(Vec2 pos, ICircuit parent) {
        this.updateExternalOutput(pos, parent);
        this.notifyNeighbours(pos, parent);
    }

    @Override
    public boolean getOutputToSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        ForgeDirection dir = MiscUtils.getDirection(this.getRotation(pos, parent));
        if (side == dir.getOpposite()) {
            return parent.getInputFromSide(dir, this.getFrequency(pos, parent));
        }
        return false;
    }

    public boolean isPowered(Vec2 pos, ICircuit parent) {
        ForgeDirection dir = MiscUtils.getDirection(this.getRotation(pos, parent)).getOpposite();
        return this.getOutputToSide(pos, parent, dir) || this.getNeighbourOnSide(pos, parent, dir).getOutputToSide(pos.offset(dir), parent, dir.getOpposite());
    }
}

