/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp.part;

import moe.nightfall.vic.integratedcircuits.Config;
import moe.nightfall.vic.integratedcircuits.Content;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPart;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPartRenderer;
import moe.nightfall.vic.integratedcircuits.cp.ICircuit;
import moe.nightfall.vic.integratedcircuits.misc.CraftingAmount;
import moe.nightfall.vic.integratedcircuits.misc.ItemAmount;
import moe.nightfall.vic.integratedcircuits.misc.PropertyStitcher;
import moe.nightfall.vic.integratedcircuits.misc.RenderUtils;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Items;
import net.minecraftforge.common.util.ForgeDirection;

public class PartTunnel
extends CircuitPart {
    public final PropertyStitcher.IntProperty PROP_POS_X;
    public final PropertyStitcher.IntProperty PROP_POS_Y;
    public final PropertyStitcher.BooleanProperty PROP_IN;

    public PartTunnel() {
        this.PROP_POS_X = new PropertyStitcher.IntProperty("PROP_POS_X", this.stitcher, 255);
        this.PROP_POS_Y = new PropertyStitcher.IntProperty("PROP_POS_Y", this.stitcher, 255);
        this.PROP_IN = new PropertyStitcher.BooleanProperty("PROP_IN", this.stitcher);
    }

    public Vec2 getConnectedPos(Vec2 pos, ICircuit parent) {
        return new Vec2(this.getProperty(pos, parent, this.PROP_POS_X), this.getProperty(pos, parent, this.PROP_POS_Y));
    }

    public int setConnectedPos(int data, Vec2 pos) {
        data = this.PROP_POS_X.set(pos.x, data);
        data = this.PROP_POS_Y.set(pos.y, data);
        return data;
    }

    public boolean isConnected(Vec2 pos) {
        return pos.x != 255 && pos.y != 255;
    }

    public PartTunnel getConnectedPart(Vec2 pos, ICircuit parent) {
        Vec2 pos2 = this.getConnectedPos(pos, parent);
        if (this.isConnected(pos2)) {
            CircuitPart cp = parent.getCircuitData().getPart(pos2);
            if (cp instanceof PartTunnel) {
                return (PartTunnel)cp;
            }
            this.setProperty(pos, parent, this.PROP_POS_X, 255);
            this.setProperty(pos, parent, this.PROP_POS_Y, 255);
            this.setProperty(pos, parent, this.PROP_IN, false);
            this.markForUpdate(pos, parent);
        }
        return null;
    }

    @Override
    public void onInputChange(Vec2 pos, ICircuit parent) {
        Vec2 pos2 = this.getConnectedPos(pos, parent);
        PartTunnel part = this.getConnectedPart(pos, parent);
        this.setProperty(pos, parent, this.PROP_IN, part == null ? false : part.getOutputToSide(pos2, parent, ForgeDirection.UNKNOWN));
        this.notifyNeighbours(pos, parent);
        if (part != null && this.getOutputToSide(pos, parent, ForgeDirection.UNKNOWN) != part.getProperty(pos2, parent, this.PROP_IN).booleanValue()) {
            part.scheduleInputChange(pos2, parent);
            part.markForUpdate(pos2, parent);
        }
    }

    @Override
    public boolean getOutputToSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        boolean in = this.getProperty(pos, parent, this.PROP_IN);
        if (side == ForgeDirection.UNKNOWN) {
            return this.getInput(pos, parent) && !in;
        }
        return (this.getInput(pos, parent) || in) && !this.getInputFromSide(pos, parent, side);
    }

    @Override
    public void onPlaced(Vec2 pos, ICircuit parent) {
        this.setProperty(pos, parent, this.PROP_POS_X, 255);
        this.setProperty(pos, parent, this.PROP_POS_Y, 255);
        this.setProperty(pos, parent, this.PROP_IN, false);
        this.scheduleInputChange(pos, parent);
    }

    private void dropConnected(Vec2 pos, ICircuit parent, Vec2 oldPos2) {
        PartTunnel oldPart;
        CircuitPart cp;
        if (this.isConnected(oldPos2) && (cp = parent.getCircuitData().getPart(oldPos2)) instanceof PartTunnel && pos.equals((oldPart = (PartTunnel)cp).getConnectedPos(oldPos2, parent))) {
            oldPart.setProperty(oldPos2, parent, this.PROP_POS_X, 255);
            oldPart.setProperty(oldPos2, parent, this.PROP_POS_Y, 255);
            if (oldPart.getProperty(oldPos2, parent, this.PROP_IN).booleanValue()) {
                oldPart.scheduleInputChange(oldPos2, parent);
            }
            oldPart.markForUpdate(oldPos2, parent);
        }
    }

    @Override
    public void onChanged(Vec2 pos, ICircuit parent, int oldMeta) {
        Vec2 oldPos2;
        Vec2 pos2 = this.getConnectedPos(pos, parent);
        if (!pos2.equals(oldPos2 = new Vec2((Integer)this.PROP_POS_X.get(oldMeta), (Integer)this.PROP_POS_Y.get(oldMeta)))) {
            this.dropConnected(pos, parent, oldPos2);
        }
        this.scheduleInputChange(pos, parent);
    }

    @Override
    public void onRemoved(Vec2 pos, ICircuit parent) {
        this.dropConnected(pos, parent, this.getConnectedPos(pos, parent));
    }

    @Override
    public void renderPart(Vec2 pos, ICircuit parent, double x, double y, CircuitPartRenderer.EnumRenderType type) {
        Tessellator tes = Tessellator.field_78398_a;
        RenderUtils.applyColorIRGBA(tes, Config.colorGreen);
        CircuitPartRenderer.addQuad(x, y, 16.0, 64.0, 16.0, 16.0);
        if (this.getInput(pos, parent) || this.getProperty(pos, parent, this.PROP_IN).booleanValue()) {
            RenderUtils.applyColorIRGBA(tes, Config.colorGreen);
        } else {
            RenderUtils.applyColorIRGBA(tes, Config.colorGreen, 0.4f);
        }
        CircuitPartRenderer.addQuad(x, y, 0.0, 64.0, 16.0, 16.0);
    }

    @Override
    public CircuitPart.Category getCategory() {
        return CircuitPart.Category.WIRE;
    }

    @Override
    public String getLocalizedName(Vec2 pos, ICircuit parent) {
        String name = super.getLocalizedName(pos, parent);
        if (!(parent instanceof CircuitPartRenderer.CircuitRenderWrapper) && this.isConnected(this.getConnectedPos(pos, parent))) {
            name = name + " (Linked)";
        }
        return name;
    }

    @Override
    public void getCraftingCost(CraftingAmount amount, CircuitData parent, Vec2 pos) {
        amount.add(new ItemAmount(Items.field_151137_ax, 0.1));
        amount.add(new ItemAmount(Content.itemSiliconDrop, 0.1));
        int data = parent.getMeta(pos);
        Vec2 end = new Vec2((Integer)this.PROP_POS_X.get(data), (Integer)this.PROP_POS_Y.get(data));
        if (this.isConnected(end)) {
            amount.add(new ItemAmount(Items.field_151137_ax, 0.1 * pos.distanceTo(end)));
        }
    }
}

