/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp.part;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Collection;
import moe.nightfall.vic.integratedcircuits.Config;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPart;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPartRenderer;
import moe.nightfall.vic.integratedcircuits.cp.ICircuit;
import moe.nightfall.vic.integratedcircuits.misc.CraftingAmount;
import moe.nightfall.vic.integratedcircuits.misc.ItemAmount;
import moe.nightfall.vic.integratedcircuits.misc.PropertyStitcher;
import moe.nightfall.vic.integratedcircuits.misc.RenderUtils;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Items;
import net.minecraftforge.common.util.ForgeDirection;

public class PartWire
extends CircuitPart {
    public final PropertyStitcher.IntProperty PROP_COLOR;

    public PartWire() {
        this.PROP_COLOR = new PropertyStitcher.IntProperty("COLOR", this.stitcher, 2);
    }

    @Override
    public boolean getOutputToSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        return this.getInput(pos, parent) && !this.getInputFromSide(pos, parent, side);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPart(Vec2 pos, ICircuit parent, double x, double y, CircuitPartRenderer.EnumRenderType type) {
        int color = this.getColor(pos, parent);
        Tessellator tes = Tessellator.field_78398_a;
        if (type == CircuitPartRenderer.EnumRenderType.GUI) {
            switch (color) {
                case 1: {
                    if (this.getInput(pos, parent)) {
                        RenderUtils.applyColorIRGBA(tes, Config.colorRed);
                        break;
                    }
                    RenderUtils.applyColorIRGBA(tes, Config.colorRed, 0.4f);
                    break;
                }
                case 2: {
                    if (this.getInput(pos, parent)) {
                        RenderUtils.applyColorIRGBA(tes, Config.colorOrange);
                        break;
                    }
                    RenderUtils.applyColorIRGBA(tes, Config.colorOrange, 0.4f);
                    break;
                }
                default: {
                    if (this.getInput(pos, parent)) {
                        RenderUtils.applyColorIRGBA(tes, Config.colorGreen);
                        break;
                    }
                    RenderUtils.applyColorIRGBA(tes, Config.colorGreen, 0.4f);
                    break;
                }
            }
        } else {
            RenderUtils.applyColorIRGBA(tes, Config.colorGreen, 0.4f);
        }
        int ty = type == CircuitPartRenderer.EnumRenderType.WORLD_16x ? 48 : 0;
        int con = CircuitPartRenderer.checkConnections(pos, parent, this);
        if ((con & 0xC) == 12 && (con & 0xFFFFFFF3) == 0) {
            CircuitPartRenderer.addQuad(x, y, 96.0, ty, 16.0, 16.0);
        } else if ((con & 3) == 3 && (con & 0xFFFFFFFC) == 0) {
            CircuitPartRenderer.addQuad(x, y, 80.0, ty, 16.0, 16.0);
        } else {
            if ((con & 8) > 0) {
                CircuitPartRenderer.addQuad(x, y, 32.0, ty, 16.0, 16.0);
            }
            if ((con & 4) > 0) {
                CircuitPartRenderer.addQuad(x, y, 64.0, ty, 16.0, 16.0);
            }
            if ((con & 2) > 0) {
                CircuitPartRenderer.addQuad(x, y, 16.0, ty, 16.0, 16.0);
            }
            if ((con & 1) > 0) {
                CircuitPartRenderer.addQuad(x, y, 48.0, ty, 16.0, 16.0);
            }
            CircuitPartRenderer.addQuad(x, y, 0.0, ty, 16.0, 16.0);
        }
    }

    @Override
    public void onInputChange(Vec2 pos, ICircuit parent) {
        this.notifyNeighbours(pos, parent);
    }

    public int getColor(Vec2 pos, ICircuit parent) {
        return this.getProperty(pos, parent, this.PROP_COLOR);
    }

    @Override
    public boolean canConnectToSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        CircuitPart part = this.getNeighbourOnSide(pos, parent, side);
        if (part instanceof PartWire) {
            int pcolor = ((PartWire)part).getColor(pos.offset(side), parent);
            int color = this.getColor(pos, parent);
            if (pcolor == 0 || color == 0) {
                return true;
            }
            return color == pcolor;
        }
        return true;
    }

    @Override
    public void getCraftingCost(CraftingAmount cost, CircuitData parent, Vec2 pos) {
        cost.add(new ItemAmount(Items.field_151137_ax, 0.05));
    }

    @Override
    public String getName(Vec2 pos, ICircuit parent) {
        return super.getName(pos, parent) + "." + this.getColor(pos, parent);
    }

    @Override
    public CircuitPart.Category getCategory() {
        return CircuitPart.Category.WIRE;
    }

    @Override
    public Collection<Integer> getSubtypes() {
        return Arrays.asList(0, 16, 32);
    }
}

