/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp.part.cell;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import moe.nightfall.vic.integratedcircuits.Config;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPart;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPartRenderer;
import moe.nightfall.vic.integratedcircuits.cp.ICircuit;
import moe.nightfall.vic.integratedcircuits.cp.part.PartSimpleGate;
import moe.nightfall.vic.integratedcircuits.misc.MiscUtils;
import moe.nightfall.vic.integratedcircuits.misc.RenderUtils;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.common.util.ForgeDirection;

public class PartANDCell
extends PartSimpleGate {
    @Override
    public CircuitPart.Category getCategory() {
        return CircuitPart.Category.CELL;
    }

    @Override
    public void onInputChange(Vec2 pos, ICircuit parent) {
        super.onInputChange(pos, parent);
        this.notifyNeighbours(pos, parent);
    }

    @Override
    public boolean getOutputToSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        ForgeDirection fd = this.toInternal(pos, parent, side);
        if ((fd == ForgeDirection.NORTH || fd == ForgeDirection.SOUTH) && this.getInputFromSide(pos, parent, side.getOpposite()) && !this.getInputFromSide(pos, parent, side)) {
            return true;
        }
        return super.getOutputToSide(pos, parent, side);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPart(Vec2 pos, ICircuit parent, double x, double y, CircuitPartRenderer.EnumRenderType type) {
        Tessellator tes = Tessellator.field_78398_a;
        int rotation = this.getRotation(pos, parent);
        ForgeDirection fd = MiscUtils.rotn(ForgeDirection.NORTH, rotation);
        if (type == CircuitPartRenderer.EnumRenderType.GUI && (this.getOutputToSide(pos, parent, fd) || this.getInputFromSide(pos, parent, fd) || this.getOutputToSide(pos, parent, fd.getOpposite()) || this.getInputFromSide(pos, parent, fd.getOpposite()))) {
            RenderUtils.applyColorIRGBA(tes, Config.colorGreen);
        } else {
            RenderUtils.applyColorIRGBA(tes, Config.colorGreen, 0.4f);
        }
        CircuitPartRenderer.addQuad(x, y, 0.0, 32.0, 16.0, 16.0, rotation);
        fd = MiscUtils.rotn(ForgeDirection.EAST, rotation);
        if (type == CircuitPartRenderer.EnumRenderType.GUI && (this.getNeighbourOnSide(pos, parent, fd).getInputFromSide(pos.offset(fd), parent, fd.getOpposite()) || this.getInputFromSide(pos, parent, fd))) {
            RenderUtils.applyColorIRGBA(tes, Config.colorGreen);
        } else {
            RenderUtils.applyColorIRGBA(tes, Config.colorGreen, 0.4f);
        }
        CircuitPartRenderer.addQuad(x, y, 128.0, 32.0, 16.0, 16.0, rotation);
        fd = MiscUtils.rotn(ForgeDirection.WEST, rotation);
        if (type == CircuitPartRenderer.EnumRenderType.GUI && (this.getNeighbourOnSide(pos, parent, fd).getInputFromSide(pos.offset(fd), parent, fd.getOpposite()) || this.getInputFromSide(pos, parent, fd))) {
            RenderUtils.applyColorIRGBA(tes, Config.colorGreen);
        } else {
            RenderUtils.applyColorIRGBA(tes, Config.colorGreen, 0.4f);
        }
        Vec2 textureOffset = this.getTextureOffset(pos, parent, x, y, type);
        CircuitPartRenderer.addQuad(x, y, textureOffset.x * 16, textureOffset.y * 16, 16.0, 16.0, rotation);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vec2 getTextureOffset(Vec2 pos, ICircuit parent, double x, double y, CircuitPartRenderer.EnumRenderType type) {
        return new Vec2(7, 2);
    }

    @Override
    protected void calcOutput(Vec2 pos, ICircuit parent) {
        ForgeDirection f1 = this.toExternal(pos, parent, ForgeDirection.NORTH);
        ForgeDirection f2 = f1.getOpposite();
        ForgeDirection f3 = this.toExternal(pos, parent, ForgeDirection.EAST);
        this.setOutput(pos, parent, (this.getInputFromSide(pos, parent, f1) || this.getInputFromSide(pos, parent, f2)) && this.getInputFromSide(pos, parent, f3));
    }

    @Override
    protected boolean hasOutputToSide(Vec2 pos, ICircuit parent, ForgeDirection fd) {
        return fd == ForgeDirection.WEST;
    }
}

