/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp.part.latch;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPart;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPartRenderer;
import moe.nightfall.vic.integratedcircuits.cp.ICircuit;
import moe.nightfall.vic.integratedcircuits.cp.part.PartCPGate;
import moe.nightfall.vic.integratedcircuits.misc.PropertyStitcher;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import moe.nightfall.vic.integratedcircuits.tile.TileEntityCAD;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public class PartRSLatch
extends PartCPGate {
    public final PropertyStitcher.IntProperty PROP_STATE;
    public final PropertyStitcher.BooleanProperty PROP_CHECK;
    public final PropertyStitcher.IntProperty PROP_MODE;

    public PartRSLatch() {
        this.PROP_STATE = new PropertyStitcher.IntProperty("STATE", this.stitcher, 2);
        this.PROP_CHECK = new PropertyStitcher.BooleanProperty("CHECK", this.stitcher);
        this.PROP_MODE = new PropertyStitcher.IntProperty("MODE", this.stitcher, 3);
    }

    @Override
    public void onClick(Vec2 pos, ICircuit parent, int button, boolean ctrl) {
        super.onClick(pos, parent, button, ctrl);
        if (button == 0 && ctrl) {
            this.cycleProperty(pos, parent, this.PROP_MODE);
            this.scheduleInputChange(pos, parent);
            this.notifyNeighbours(pos, parent);
        }
    }

    private boolean isMirrored(Vec2 pos, ICircuit parent) {
        return (this.getProperty(pos, parent, this.PROP_MODE) & 2) != 0;
    }

    private boolean isSpecial(Vec2 pos, ICircuit parent) {
        return (this.getProperty(pos, parent, this.PROP_MODE) & 1) != 0;
    }

    @Override
    public void onInputChange(Vec2 pos, ICircuit parent) {
        this.scheduleTick(pos, parent);
        if (this.isSpecial(pos, parent)) {
            if (this.getProperty(pos, parent, this.PROP_CHECK).booleanValue()) {
                return;
            }
            int st = this.getProperty(pos, parent, this.PROP_STATE);
            ForgeDirection s1 = this.toExternal(pos, parent, ForgeDirection.NORTH);
            boolean in1 = this.getInputFromSide(pos, parent, s1);
            boolean in2 = this.getInputFromSide(pos, parent, s1.getOpposite());
            if (st != 2 && !in1 && in2 || st == 2 && !in2 && in1) {
                this.setProperty(pos, parent, this.PROP_CHECK, true);
            }
            this.notifyNeighbours(pos, parent);
        }
    }

    @Override
    public void onScheduledTick(Vec2 pos, ICircuit parent) {
        boolean in2;
        ForgeDirection s1 = this.toExternal(pos, parent, ForgeDirection.NORTH);
        boolean in1 = this.getInputFromSide(pos, parent, s1);
        if (in1 != (in2 = this.getInputFromSide(pos, parent, s1.getOpposite()))) {
            this.setProperty(pos, parent, this.PROP_STATE, in1 ? 1 : 2);
        } else if (in1 || this.getProperty(pos, parent, this.PROP_CHECK).booleanValue()) {
            this.setProperty(pos, parent, this.PROP_STATE, 0);
            if (!in1 && !(parent instanceof TileEntityCAD)) {
                this.notifyNeighbours(pos, parent);
                return;
            }
        } else if (this.getProperty(pos, parent, this.PROP_STATE) == 0) {
            this.setProperty(pos, parent, this.PROP_STATE, 1);
        }
        this.setProperty(pos, parent, this.PROP_CHECK, false);
        this.notifyNeighbours(pos, parent);
    }

    @Override
    public boolean getOutputToSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        int state = this.getProperty(pos, parent, this.PROP_STATE);
        ForgeDirection s2 = this.toInternal(pos, parent, side);
        boolean special = this.isSpecial(pos, parent);
        boolean mirrored = this.isMirrored(pos, parent);
        if (s2 == ForgeDirection.NORTH) {
            if (special && state != 2) {
                return this.getProperty(pos, parent, this.PROP_CHECK) == false && !this.getInputFromSide(pos, parent, side);
            }
            return false;
        }
        if (state == 0) {
            return false;
        }
        if (s2 == ForgeDirection.SOUTH) {
            if (special && state == 2) {
                return this.getProperty(pos, parent, this.PROP_CHECK) == false && !this.getInputFromSide(pos, parent, side);
            }
            return false;
        }
        if (s2 == ForgeDirection.EAST) {
            return state == 1 != mirrored;
        }
        if (s2 == ForgeDirection.WEST) {
            return state == 1 == mirrored;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vec2 getTextureOffset(Vec2 pos, ICircuit parent, double x, double y, CircuitPartRenderer.EnumRenderType type) {
        return new Vec2(7, 1);
    }

    @Override
    public ArrayList<String> getInformation(Vec2 pos, ICircuit parent, boolean edit, boolean ctrlDown) {
        ArrayList<String> text = super.getInformation(pos, parent, edit, ctrlDown);
        text.add(I18n.func_135052_a((String)"part.integratedcircuits.rslatch.mode", (Object[])new Object[0]) + ": " + (this.isSpecial(pos, parent) ? 1 : 0));
        if (this.isMirrored(pos, parent)) {
            text.add(EnumChatFormatting.ITALIC + I18n.func_135052_a((String)"part.integratedcircuits.rslatch.mirrored", (Object[])new Object[0]));
        }
        if (edit && ctrlDown) {
            text.add(I18n.func_135052_a((String)"gui.integratedcircuits.cad.mode", (Object[])new Object[0]));
        }
        return text;
    }

    @Override
    public CircuitPart.Category getCategory() {
        return CircuitPart.Category.LATCH;
    }
}

