/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp.part.latch;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPart;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPartRenderer;
import moe.nightfall.vic.integratedcircuits.cp.ICircuit;
import moe.nightfall.vic.integratedcircuits.cp.part.PartCPGate;
import moe.nightfall.vic.integratedcircuits.misc.PropertyStitcher;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.util.ForgeDirection;

public class PartToggleLatch
extends PartCPGate {
    public final PropertyStitcher.BooleanProperty PROP_OUT;
    public final PropertyStitcher.BooleanProperty PROP_OLD_NORTH;
    public final PropertyStitcher.BooleanProperty PROP_OLD_SOUTH;

    public PartToggleLatch() {
        this.PROP_OUT = new PropertyStitcher.BooleanProperty("OUT", this.stitcher);
        this.PROP_OLD_NORTH = new PropertyStitcher.BooleanProperty("OLD_NORTH", this.stitcher);
        this.PROP_OLD_SOUTH = new PropertyStitcher.BooleanProperty("OLD_SOUTH", this.stitcher);
    }

    @Override
    public void onClick(Vec2 pos, ICircuit parent, int button, boolean ctrl) {
        super.onClick(pos, parent, button, ctrl);
        if (button == 0 && ctrl) {
            this.invertProperty(pos, parent, this.PROP_OUT);
            this.notifyNeighbours(pos, parent);
        }
    }

    @Override
    public void onInputChange(Vec2 pos, ICircuit parent) {
        this.scheduleTick(pos, parent);
    }

    @Override
    public void onScheduledTick(Vec2 pos, ICircuit parent) {
        ForgeDirection north = this.toExternal(pos, parent, ForgeDirection.NORTH);
        boolean northIn = this.getInputFromSide(pos, parent, north);
        boolean southIn = this.getInputFromSide(pos, parent, north.getOpposite());
        if (northIn && !this.getProperty(pos, parent, this.PROP_OLD_NORTH).booleanValue()) {
            this.invertProperty(pos, parent, this.PROP_OUT);
        }
        if (southIn && !this.getProperty(pos, parent, this.PROP_OLD_SOUTH).booleanValue()) {
            this.invertProperty(pos, parent, this.PROP_OUT);
        }
        this.notifyNeighbours(pos, parent);
        this.setProperty(pos, parent, this.PROP_OLD_NORTH, northIn);
        this.setProperty(pos, parent, this.PROP_OLD_SOUTH, southIn);
    }

    @Override
    public boolean getOutputToSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        ForgeDirection s2 = this.toInternal(pos, parent, side);
        if (s2 == ForgeDirection.EAST) {
            return this.getProperty(pos, parent, this.PROP_OUT);
        }
        if (s2 == ForgeDirection.WEST) {
            return this.getProperty(pos, parent, this.PROP_OUT) == false;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vec2 getTextureOffset(Vec2 pos, ICircuit parent, double x, double y, CircuitPartRenderer.EnumRenderType type) {
        return new Vec2(8, 1);
    }

    @Override
    public ArrayList<String> getInformation(Vec2 pos, ICircuit parent, boolean edit, boolean ctrlDown) {
        ArrayList<String> text = super.getInformation(pos, parent, edit, ctrlDown);
        if (edit && ctrlDown) {
            text.add(I18n.func_135052_a((String)"gui.integratedcircuits.cad.toggle", (Object[])new Object[0]));
        }
        return text;
    }

    @Override
    public CircuitPart.Category getCategory() {
        return CircuitPart.Category.LATCH;
    }
}

