/*
 * Decompiled with CFR 0.152.
 */
package moe.nightfall.vic.integratedcircuits.cp.part.timed;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import moe.nightfall.vic.integratedcircuits.cp.CircuitData;
import moe.nightfall.vic.integratedcircuits.cp.CircuitPartRenderer;
import moe.nightfall.vic.integratedcircuits.cp.ICircuit;
import moe.nightfall.vic.integratedcircuits.cp.part.timed.PartDelayedAction;
import moe.nightfall.vic.integratedcircuits.misc.CraftingAmount;
import moe.nightfall.vic.integratedcircuits.misc.ItemAmount;
import moe.nightfall.vic.integratedcircuits.misc.PropertyStitcher;
import moe.nightfall.vic.integratedcircuits.misc.Vec2;
import net.minecraft.init.Items;
import net.minecraftforge.common.util.ForgeDirection;

public class PartRandomizer
extends PartDelayedAction {
    public final PropertyStitcher.IntProperty PROP_RANDOM;
    private Random random;

    public PartRandomizer() {
        this.PROP_RANDOM = new PropertyStitcher.IntProperty("RANDOM", this.stitcher, 7);
        this.random = new Random();
    }

    @Override
    protected int getDelay(Vec2 pos, ICircuit parent) {
        return 2;
    }

    @Override
    public void onDelay(Vec2 pos, ICircuit parent) {
        this.setProperty(pos, parent, this.PROP_RANDOM, this.random.nextInt(8));
        this.setDelay(pos, parent, true);
        this.notifyNeighbours(pos, parent);
    }

    @Override
    public boolean getOutputToSide(Vec2 pos, ICircuit parent, ForgeDirection side) {
        ForgeDirection s2 = this.toInternal(pos, parent, side);
        if (s2 == ForgeDirection.SOUTH) {
            return false;
        }
        int rand = this.getProperty(pos, parent, this.PROP_RANDOM);
        if (s2 == ForgeDirection.EAST && (rand >> 2 & 1) != 0) {
            return true;
        }
        if (s2 == ForgeDirection.WEST && (rand >> 1 & 1) != 0) {
            return true;
        }
        return s2 == ForgeDirection.NORTH && (rand & 1) != 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vec2 getTextureOffset(Vec2 pos, ICircuit parent, double x, double y, CircuitPartRenderer.EnumRenderType type) {
        return new Vec2(5, 1);
    }

    @Override
    public void onInputChange(Vec2 pos, ICircuit parent) {
        this.scheduleTick(pos, parent);
    }

    @Override
    public void onScheduledTick(Vec2 pos, ICircuit parent) {
        if (!this.getInputFromSide(pos, parent, this.toExternal(pos, parent, ForgeDirection.SOUTH))) {
            this.setDelay(pos, parent, false);
        } else {
            super.onScheduledTick(pos, parent);
            if (!this.isDelayActive(pos, parent)) {
                this.onDelay(pos, parent);
            }
        }
    }

    @Override
    public void getCraftingCost(CraftingAmount cost, CircuitData parent, Vec2 pos) {
        cost.add(new ItemAmount(Items.field_151137_ax, 0.15));
        cost.add(new ItemAmount(Items.field_151114_aO, 0.1));
    }
}

